/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.utils.ApiUtils;

public class ContextAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(ContextAPI.class);
    private static final String PREFIX = "context";
    private static final String TECH_NAME = "technologyName";
    private static final String EXCLUDE_FROM_CONTEXT_REGEX = "excludeFromContext";
    private static final String INCLUDE_IN_CONTEXT_REGEX = "includeInContext";
    private static final String ACTION_NEW_CONTEXT = "newContext";
    private static final String ACTION_REMOVE_CONTEXT = "removeContext";
    private static final String ACTION_SET_CONTEXT_IN_SCOPE = "setContextInScope";
    private static final String ACTION_EXPORT_CONTEXT = "exportContext";
    private static final String ACTION_IMPORT_CONTEXT = "importContext";
    private static final String ACTION_INCLUDE_TECHS = "includeContextTechnologies";
    private static final String ACTION_INCLUDE_ALL_TECHS = "includeAllContextTechnologies";
    private static final String ACTION_EXCLUDE_TECHS = "excludeContextTechnologies";
    private static final String ACTION_EXCLUDE_ALL_TECHS = "excludeAllContextTechnologies";
    private static final String VIEW_EXCLUDE_REGEXS = "excludeRegexs";
    private static final String VIEW_INCLUDE_REGEXS = "includeRegexs";
    private static final String VIEW_CONTEXT_LIST = "contextList";
    private static final String VIEW_CONTEXT = "context";
    private static final String VIEW_ALL_TECHS = "technologyList";
    private static final String VIEW_INCLUDED_TECHS = "includedTechnologyList";
    private static final String VIEW_EXCLUDED_TECHS = "excludedTechnologyList";
    private static final String REGEX_PARAM = "regex";
    private static final String CONTEXT_NAME = "contextName";
    private static final String IN_SCOPE = "booleanInScope";
    private static final String CONTEXT_FILE_PARAM = "contextFile";
    private static final String CONTEXT_ID = "contextId";
    private static final String PARAM_TECH_NAMES = "technologyNames";

    public ContextAPI() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(CONTEXT_NAME);
        arrayList.add(REGEX_PARAM);
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add(CONTEXT_NAME);
        String[] stringArray = new String[]{CONTEXT_NAME, PARAM_TECH_NAMES};
        this.addApiAction(new ApiAction(EXCLUDE_FROM_CONTEXT_REGEX, arrayList));
        this.addApiAction(new ApiAction(INCLUDE_IN_CONTEXT_REGEX, arrayList));
        this.addApiAction(new ApiAction(ACTION_NEW_CONTEXT, arrayList2));
        this.addApiAction(new ApiAction(ACTION_REMOVE_CONTEXT, arrayList2));
        this.addApiAction(new ApiAction(ACTION_EXPORT_CONTEXT, new String[]{CONTEXT_NAME, CONTEXT_FILE_PARAM}, null));
        this.addApiAction(new ApiAction(ACTION_IMPORT_CONTEXT, new String[]{CONTEXT_FILE_PARAM}, null));
        this.addApiAction(new ApiAction(ACTION_INCLUDE_TECHS, stringArray));
        this.addApiAction(new ApiAction(ACTION_INCLUDE_ALL_TECHS, arrayList2));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_TECHS, stringArray));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_ALL_TECHS, arrayList2));
        ArrayList<String> arrayList3 = new ArrayList<String>(2);
        arrayList3.add(CONTEXT_NAME);
        arrayList3.add(IN_SCOPE);
        this.addApiAction(new ApiAction(ACTION_SET_CONTEXT_IN_SCOPE, arrayList3));
        this.addApiView(new ApiView(VIEW_CONTEXT_LIST));
        this.addApiView(new ApiView(VIEW_EXCLUDE_REGEXS, arrayList2));
        this.addApiView(new ApiView(VIEW_INCLUDE_REGEXS, arrayList2));
        this.addApiView(new ApiView("context", arrayList2));
        this.addApiView(new ApiView(VIEW_ALL_TECHS));
        this.addApiView(new ApiView(VIEW_INCLUDED_TECHS, arrayList2));
        this.addApiView(new ApiView(VIEW_EXCLUDED_TECHS, arrayList2));
    }

    @Override
    public String getPrefix() {
        return "context";
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        switch (string) {
            case "excludeFromContext": {
                try {
                    this.addExcludeToContext(this.getContext(jSONObject), jSONObject.getString(REGEX_PARAM));
                    break;
                }
                catch (Exception exception) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                }
            }
            case "includeInContext": {
                this.addIncludeToContext(this.getContext(jSONObject), jSONObject.getString(REGEX_PARAM));
                break;
            }
            case "newContext": {
                Context context = Model.getSingleton().getSession().getNewContext(jSONObject.getString(CONTEXT_NAME));
                Model.getSingleton().getSession().saveContext(context);
                return new ApiResponseElement(CONTEXT_ID, String.valueOf(context.getIndex()));
            }
            case "removeContext": {
                Context context = this.getContext(jSONObject);
                Model.getSingleton().getSession().deleteContext(context);
                break;
            }
            case "setContextInScope": {
                Context context = this.getContext(jSONObject);
                context.setInScope(jSONObject.getBoolean(IN_SCOPE));
                Model.getSingleton().getSession().saveContext(context);
                break;
            }
            case "importContext": {
                Context context;
                String string2 = jSONObject.getString(CONTEXT_FILE_PARAM);
                File file = new File(string2);
                if (!file.exists()) {
                    file = new File(Constant.getContextsDir(), string2);
                }
                if (!file.exists()) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, file.getAbsolutePath());
                }
                try {
                    context = Model.getSingleton().getSession().importContext(file);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                }
                return new ApiResponseElement(CONTEXT_ID, String.valueOf(context.getIndex()));
            }
            case "exportContext": {
                String string3 = jSONObject.getString(CONTEXT_FILE_PARAM);
                Context context = this.getContext(jSONObject);
                File file = new File(string3);
                if (!file.getAbsolutePath().equals(string3)) {
                    file = new File(Constant.getContextsDir(), string3);
                }
                if (!file.getParentFile().canWrite()) {
                    throw new ApiException(ApiException.Type.NO_ACCESS, file.getAbsolutePath());
                }
                try {
                    Model.getSingleton().getSession().exportContext(context, file);
                    break;
                }
                catch (Exception exception) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                }
            }
            case "includeContextTechnologies": {
                String[] stringArray;
                Context context = this.getContext(jSONObject);
                TechSet techSet = context.getTechSet();
                for (String string4 : stringArray = this.getParam(jSONObject, PARAM_TECH_NAMES, "").split(",")) {
                    techSet.include(this.getTech(string4));
                }
                context.save();
                break;
            }
            case "includeAllContextTechnologies": {
                Context context = this.getContext(jSONObject);
                TechSet techSet = new TechSet(Tech.builtInTech);
                context.setTechSet(techSet);
                context.save();
                break;
            }
            case "excludeContextTechnologies": {
                String[] stringArray;
                Context context = this.getContext(jSONObject);
                TechSet techSet = context.getTechSet();
                for (String string5 : stringArray = this.getParam(jSONObject, PARAM_TECH_NAMES, "").split(",")) {
                    techSet.exclude(this.getTech(string5));
                }
                context.save();
                break;
            }
            case "excludeAllContextTechnologies": {
                Context context = this.getContext(jSONObject);
                TechSet techSet = context.getTechSet();
                for (Tech tech : Tech.builtInTech) {
                    techSet.exclude(tech);
                }
                context.save();
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private void addExcludeToContext(Context context, String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>(context.getIncludeInContextRegexs());
        if (arrayList.remove(string)) {
            context.setIncludeInContextRegexs(arrayList);
        } else {
            context.addExcludeFromContextRegex(string);
        }
        Model.getSingleton().getSession().saveContext(context);
    }

    private void addIncludeToContext(Context context, String string) {
        context.addIncludeInContextRegex(string);
        Model.getSingleton().getSession().saveContext(context);
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse;
        log.debug((Object)("handleApiView " + string + " " + jSONObject.toString()));
        switch (string) {
            case "excludeRegexs": {
                apiResponse = new ApiResponseElement(string, this.getContext(jSONObject).getExcludeFromContextRegexs().toString());
                break;
            }
            case "includeRegexs": {
                apiResponse = new ApiResponseElement(string, this.getContext(jSONObject).getIncludeInContextRegexs().toString());
                break;
            }
            case "contextList": {
                ArrayList<String> arrayList = new ArrayList<String>();
                List<Context> list = Model.getSingleton().getSession().getContexts();
                for (Context context : list) {
                    arrayList.add(context.getName());
                }
                apiResponse = new ApiResponseElement(string, ((Object)arrayList).toString());
                break;
            }
            case "context": {
                apiResponse = new ApiResponseElement(this.buildResponseFromContext(this.getContext(jSONObject)));
                break;
            }
            case "technologyList": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (Tech tech : Tech.builtInTech) {
                    apiResponseList.addItem(new ApiResponseElement(TECH_NAME, tech.toString()));
                }
                apiResponse = apiResponseList;
                break;
            }
            case "includedTechnologyList": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                TechSet techSet = this.getContext(jSONObject).getTechSet();
                for (Tech tech : techSet.getIncludeTech()) {
                    apiResponseList.addItem(new ApiResponseElement(TECH_NAME, tech.toString()));
                }
                apiResponse = apiResponseList;
                break;
            }
            case "excludedTechnologyList": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                TechSet techSet = this.getContext(jSONObject).getTechSet();
                for (Tech tech : techSet.getExcludeTech()) {
                    apiResponseList.addItem(new ApiResponseElement(TECH_NAME, tech.toString()));
                }
                apiResponse = apiResponseList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return apiResponse;
    }

    private Context getContext(JSONObject jSONObject) throws ApiException {
        return ApiUtils.getContextByName(jSONObject, CONTEXT_NAME);
    }

    private ApiResponse buildResponseFromContext(Context context) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", context.getName());
        hashMap.put("id", Integer.toString(context.getIndex()));
        hashMap.put("description", context.getDescription());
        hashMap.put("inScope", Boolean.toString(context.isInScope()));
        hashMap.put(VIEW_EXCLUDE_REGEXS, context.getExcludeFromContextRegexs().toString());
        hashMap.put(VIEW_INCLUDE_REGEXS, context.getIncludeInContextRegexs().toString());
        AuthenticationMethod authenticationMethod = context.getAuthenticationMethod();
        if (authenticationMethod != null) {
            object = authenticationMethod.getLoggedInIndicatorPattern();
            hashMap.put("loggedInPattern", object == null ? "" : ((Pattern)object).toString());
            object = authenticationMethod.getLoggedOutIndicatorPattern();
            hashMap.put("loggedOutPattern", object == null ? "" : ((Pattern)object).toString());
            AuthenticationMethodType authenticationMethodType = authenticationMethod.getType();
            hashMap.put("authType", authenticationMethodType == null ? "" : authenticationMethodType.getName());
        }
        if ((object = context.getAuthorizationDetectionMethod()) != null) {
            hashMap.put("authenticationDetectionMethodId", String.valueOf(object.getMethodUniqueIdentifier()));
        }
        hashMap.put("urlParameterParserClass", context.getUrlParamParser().getClass().getCanonicalName());
        hashMap.put("urlParameterParserConfig", context.getUrlParamParser().getConfig());
        hashMap.put("postParameterParserClass", context.getPostParamParser().getClass().getCanonicalName());
        hashMap.put("postParameterParserConfig", context.getPostParamParser().getConfig());
        return new ApiResponseSet("context", hashMap);
    }

    private Tech getTech(String string) throws ApiException {
        for (Tech tech : Tech.builtInTech) {
            if (!tech.toString().equalsIgnoreCase(string)) continue;
            return tech;
        }
        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "The tech " + string + " does not exist");
    }
}

