/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 20 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 24 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  RELEASE_BUILD:
//@line 29 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 31 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 34 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 38 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 46 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 48 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 53 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 55 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 60 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 62 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 67 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 69 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 74 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 76 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_SAFE_BROWSING:
//@line 79 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 83 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 88 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 90 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 95 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 97 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 102 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 104 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 109 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 111 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 116 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 118 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 123 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 125 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 130 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 132 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

//@line 134 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 138 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 140 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 143 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 147 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

//@line 150 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  platform:
//@line 152 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 168 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 185 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 187 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 192 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 194 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 199 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 201 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 204 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 208 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 213 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 215 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 220 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 222 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_B2GDROID:
//@line 227 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 229 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 234 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 236 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 239 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 243 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 246 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 250 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 255 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 257 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 260 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  true,
//@line 264 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 269 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 271 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 276 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  false,
//@line 278 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "bluegriffon",
  MOZ_APP_VERSION: "2.2",
  MOZ_APP_VERSION_DISPLAY: "2.2",
  MOZ_BUILD_APP: "bluegriffon",
  MOZ_MACBUNDLE_NAME: "BlueGriffon.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk3",
  ANDROID_PACKAGE_NAME: "org.mozilla.bluegriffon",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  MOZ_ANDROID_APZ:
//@line 298 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
    false,
//@line 300 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 308 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  MOZ_NUWA_PROCESS:
//@line 314 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
    false
//@line 316 "/build/bluegriffon/src/mozilla-central-f14898695ee0/toolkit/modules/AppConstants.jsm"
});
