/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.daemon.WorkerDaemonExecutionException;
import org.gradle.process.daemon.WorkerDaemonExecutor;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.daemon.DaemonForkOptions;
import org.gradle.process.internal.daemon.WorkSpec;
import org.gradle.process.internal.daemon.WorkerDaemon;
import org.gradle.process.internal.daemon.WorkerDaemonAction;
import org.gradle.process.internal.daemon.WorkerDaemonFactory;
import org.gradle.process.internal.daemon.WorkerDaemonProtocol;
import org.gradle.process.internal.daemon.WorkerDaemonResult;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkerDaemonExecutor<T>
implements WorkerDaemonExecutor {
    private final WorkerDaemonFactory workerDaemonFactory;
    private final JavaForkOptions javaForkOptions;
    private final Set<File> classpath = Sets.newLinkedHashSet();
    private final Class<? extends T> implementationClass;
    private final Class<? extends WorkerDaemonProtocol> serverImplementationClass;
    private Serializable[] params = new Serializable[0];

    public AbstractWorkerDaemonExecutor(WorkerDaemonFactory workerDaemonFactory, FileResolver fileResolver, Class<? extends T> implementationClass, Class<? extends WorkerDaemonProtocol> serverImplementationClass) {
        this.workerDaemonFactory = workerDaemonFactory;
        this.javaForkOptions = new DefaultJavaForkOptions(fileResolver);
        this.implementationClass = implementationClass;
        this.serverImplementationClass = serverImplementationClass;
        this.javaForkOptions.workingDir((Object)new File("").getAbsoluteFile());
    }

    @Override
    public WorkerDaemonExecutor classpath(Iterable<File> files) {
        GUtil.addToCollection(this.classpath, (Iterable[])new Iterable[]{files});
        return this;
    }

    @Override
    public WorkerDaemonExecutor forkOptions(Action<? super JavaForkOptions> forkOptionsAction) {
        forkOptionsAction.execute((Object)this.javaForkOptions);
        return this;
    }

    @Override
    public JavaForkOptions getForkOptions() {
        return this.javaForkOptions;
    }

    @Override
    public WorkerDaemonExecutor params(Serializable ... params) {
        this.params = params;
        return this;
    }

    protected Class<? extends T> getImplementationClass() {
        return this.implementationClass;
    }

    protected Serializable[] getParams() {
        return this.params;
    }

    abstract WorkSpec getSpec();

    abstract WorkerDaemonAction getAction();

    @Override
    public void execute() {
        WorkSpec spec = this.getSpec();
        WorkerDaemonAction action = this.getAction();
        try {
            WorkerDaemon daemon = this.workerDaemonFactory.getDaemon(this.serverImplementationClass, this.getForkOptions().getWorkingDir(), this.getDaemonForkOptions());
            WorkerDaemonResult result = daemon.execute(action, spec);
            if (!result.isSuccess()) {
                throw result.getException();
            }
        }
        catch (Throwable t) {
            throw new WorkerDaemonExecutionException("A failure occurred while executing " + action.getDescription(), t);
        }
    }

    DaemonForkOptions getDaemonForkOptions() {
        List paramTypes = CollectionUtils.collect((Object[])this.getParams(), (Transformer)new Transformer<Class<?>, Object>(){

            public Class<?> transform(Object o) {
                return o.getClass();
            }
        });
        return this.toDaemonOptions(this.implementationClass, paramTypes, this.javaForkOptions, this.classpath);
    }

    private DaemonForkOptions toDaemonOptions(Class<?> actionClass, Iterable<Class<?>> paramClasses, JavaForkOptions forkOptions, Iterable<File> classpath) {
        ImmutableSet.Builder classpathBuilder = ImmutableSet.builder();
        ImmutableSet.Builder sharedPackagesBuilder = ImmutableSet.builder();
        if (classpath != null) {
            classpathBuilder.addAll(classpath);
        }
        AbstractWorkerDaemonExecutor.addVisibilityFor(actionClass, (ImmutableSet.Builder<File>)classpathBuilder, (ImmutableSet.Builder<String>)sharedPackagesBuilder);
        for (Class<?> paramClass : paramClasses) {
            AbstractWorkerDaemonExecutor.addVisibilityFor(paramClass, (ImmutableSet.Builder<File>)classpathBuilder, (ImmutableSet.Builder<String>)sharedPackagesBuilder);
        }
        ImmutableSet daemonClasspath = classpathBuilder.build();
        ImmutableSet daemonSharedPackages = sharedPackagesBuilder.build();
        return new DaemonForkOptions(forkOptions.getMinHeapSize(), forkOptions.getMaxHeapSize(), forkOptions.getAllJvmArgs(), (Iterable<File>)daemonClasspath, (Iterable<String>)daemonSharedPackages);
    }

    private static void addVisibilityFor(Class<?> visibleClass, ImmutableSet.Builder<File> classpathBuilder, ImmutableSet.Builder<String> sharedPackagesBuilder) {
        if (visibleClass.getClassLoader() != null) {
            classpathBuilder.addAll((Iterable)ClasspathUtil.getClasspath((ClassLoader)visibleClass.getClassLoader()).getAsFiles());
        }
        if (visibleClass.getPackage() == null || "".equals(visibleClass.getPackage().getName())) {
            sharedPackagesBuilder.add((Object)"DEFAULT");
        } else {
            sharedPackagesBuilder.add((Object)visibleClass.getPackage().getName());
        }
    }
}

