/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolution;
import com.oracle.truffle.api.interop.java.UnboxNodeSubNodeGen;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

abstract class UnboxNodeSub
extends JavaObjectMessageResolution.UnboxNode {
    UnboxNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2);

    @Specialization
    protected Object accessWithTarget(JavaObject object) {
        return this.access(object);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new UNBOXRootNode(language);
    }

    private static final class UNBOXRootNode
    extends RootNode {
        @Node.Child
        private UnboxNodeSub node = UnboxNodeSubNodeGen.create();

        protected UNBOXRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            try {
                return this.node.executeWithTarget(frame, receiver);
            }
            catch (UnsupportedSpecializationException e) {
                if (e.getNode() instanceof UnboxNodeSub) {
                    throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                }
                throw e;
            }
        }
    }
}

