/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SuppressFBWarnings;

public final class SourceSection {
    private static final String UNKNOWN = "<unknown>";
    private final Source source;
    private final int charIndex;
    private final int charLength;
    private final String identifier;
    private final int startLine;
    private final int startColumn;
    private final String kind;

    SourceSection(Source source, String identifier, int startLine, int startColumn, int charIndex, int charLength) {
        this.kind = null;
        this.source = source;
        this.identifier = identifier;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.charIndex = charIndex;
        this.charLength = charLength;
    }

    SourceSection(Source source, int charIndex, int charLength) {
        this.source = source;
        this.charIndex = charIndex;
        this.charLength = charLength;
        this.kind = null;
        this.identifier = null;
        this.startLine = -1;
        this.startColumn = -1;
    }

    SourceSection(Source source) {
        this.source = source;
        this.charIndex = 0;
        this.charLength = -1;
        this.kind = null;
        this.identifier = null;
        this.startLine = -1;
        this.startColumn = -1;
    }

    private SourceSection(String kind, String identifier) {
        this.source = null;
        this.kind = kind;
        this.identifier = identifier;
        this.startLine = -1;
        this.startColumn = -1;
        this.charIndex = -1;
        this.charLength = -1;
    }

    public boolean isAvailable() {
        return this.charLength != -1 && this.source != null;
    }

    boolean isValid() {
        return this.isAvailable() ? this.charIndex + this.charLength <= this.getSource().getCode().length() : false;
    }

    public Source getSource() {
        return this.source;
    }

    public int getStartLine() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        if (this.startLine == -1) {
            return this.source.getLineNumber(this.getCharIndex());
        }
        return this.startLine;
    }

    @Deprecated
    public LineLocation getLineLocation() {
        if (!this.isValid()) {
            return null;
        }
        return this.source.createLineLocation(this.getStartLine());
    }

    public int getStartColumn() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        if (this.startColumn == -1) {
            return this.source.getColumnNumber(this.getCharIndex());
        }
        return this.startColumn;
    }

    public int getEndLine() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        return this.source.getLineNumber(this.getCharIndex() + Math.max(0, this.getCharLength() - 1));
    }

    public int getEndColumn() {
        if (this.source == null) {
            return -1;
        }
        if (!this.isValid()) {
            return 1;
        }
        return this.source.getColumnNumber(this.getCharIndex() + Math.max(0, this.getCharLength() - 1));
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public int getCharLength() {
        if (this.source == null) {
            return -1;
        }
        return this.charLength == -1 ? 0 : this.charLength;
    }

    public int getCharEndIndex() {
        if (this.source == null) {
            return -1;
        }
        return this.getCharIndex() + this.getCharLength();
    }

    @Deprecated
    public String getIdentifier() {
        return this.identifier;
    }

    public String getCode() {
        if (this.source == null) {
            return "<unavailable>";
        }
        if (!this.isValid()) {
            return "";
        }
        return this.source.getCode(this.getCharIndex(), this.getCharLength());
    }

    @Deprecated
    public String getShortDescription() {
        if (this.source == null) {
            return this.kind == null ? UNKNOWN : this.kind;
        }
        return String.format("%s:%d", this.source.getName(), this.getStartLine());
    }

    public String toString() {
        if (this.source == null) {
            return this.kind == null ? UNKNOWN : this.kind;
        }
        StringBuilder b = new StringBuilder();
        b.append("SourceSection(source=").append(this.getSource().getName());
        if (this.isAvailable()) {
            b.append(", index=").append(this.getCharIndex());
            b.append(", length=").append(this.getCharLength());
            if (this.isValid()) {
                b.append(", code=").append(this.getCode().replaceAll("\\n", "\\\\n"));
            } else {
                b.append(", valid=false");
            }
        } else {
            b.append(" available=false");
        }
        b.append(")");
        return b.toString();
    }

    public int hashCode() {
        if (!this.isAvailable()) {
            return System.identityHashCode(this);
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.charIndex;
        result = 31 * result + this.charLength;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + this.startColumn;
        result = 31 * result + this.startLine;
        return result;
    }

    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSection)) {
            return false;
        }
        SourceSection other = (SourceSection)obj;
        if (!this.isAvailable()) {
            return this == obj;
        }
        if (this.charIndex != other.charIndex) {
            return false;
        }
        if (this.charLength != other.charLength) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        return this.startLine == other.startLine;
    }

    @Deprecated
    public static SourceSection createUnavailable(String kind, String name) {
        return new SourceSection(kind, name == null ? UNKNOWN : name);
    }
}

