/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;

public class LowerFixnumChecker {
    public static boolean SUCCESS = true;

    public static void checkLowerFixnumArguments(NodeFactory<? extends RubyNode> nodeFactory, int initialSkip, CoreMethod methodAnnotation) {
        Class<? extends RubyNode> nodeClass = nodeFactory.getNodeClass();
        byte[] lowerArgs = null;
        for (Method specialization : nodeClass.getDeclaredMethods()) {
            int i;
            if (!specialization.isAnnotationPresent(Specialization.class)) continue;
            Class<?>[] argumentTypes = specialization.getParameterTypes();
            int skip = initialSkip;
            if (argumentTypes.length > 0 && argumentTypes[0] == VirtualFrame.class) {
                ++skip;
            }
            int end = argumentTypes.length;
            Annotation[][] annos = specialization.getParameterAnnotations();
            for (i = end - 1; i >= skip; --i) {
                boolean cached = false;
                for (Annotation anno : annos[i]) {
                    cached |= anno instanceof Cached;
                }
                if (!cached) break;
                --end;
            }
            if (lowerArgs == null) {
                lowerArgs = new byte[end - skip];
            } else assert (lowerArgs.length == end - skip);
            for (i = skip; i < end; ++i) {
                Class<?> argumentType = argumentTypes[i];
                if (argumentType == Integer.TYPE) {
                    int n = i - skip;
                    lowerArgs[n] = (byte)(lowerArgs[n] | 1);
                    continue;
                }
                if (argumentType != Long.TYPE) continue;
                int n = i - skip;
                lowerArgs[n] = (byte)(lowerArgs[n] | 2);
            }
        }
        int[] lowerFixnum = methodAnnotation.lowerFixnum();
        for (int i = 0; i < lowerArgs.length; ++i) {
            boolean shouldLower;
            boolean bl = shouldLower = lowerArgs[i] == true;
            if (!shouldLower || ArrayUtils.contains(lowerFixnum, i + 1)) continue;
            SUCCESS = false;
            System.err.println("Node " + nodeFactory.getNodeClass().getCanonicalName() + " should use lowerFixnum for argument " + (i + 1));
        }
    }
}

