/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.ObjectNodes;
import org.jruby.truffle.core.ObjectNodesFactory;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

public class HashNode
extends RubyBaseNode {
    @Node.Child
    private CallDispatchHeadNode hashNode;
    @Node.Child
    private ObjectNodes.ObjectIDPrimitiveNode objectIDNode;
    private final ConditionProfile isIntegerProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isLongProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isBignumProfile = ConditionProfile.createBinaryProfile();

    public int hash(VirtualFrame frame, Object key, boolean compareByIdentity) {
        Object hashedObject = compareByIdentity ? this.objectID(key) : this.hash(frame, key);
        if (this.isIntegerProfile.profile(hashedObject instanceof Integer)) {
            return (Integer)hashedObject;
        }
        if (this.isLongProfile.profile(hashedObject instanceof Long)) {
            return (int)((Long)hashedObject).longValue();
        }
        if (this.isBignumProfile.profile(Layouts.BIGNUM.isBignum(hashedObject))) {
            return Layouts.BIGNUM.getValue((DynamicObject)hashedObject).hashCode();
        }
        throw new UnsupportedOperationException();
    }

    private Object hash(VirtualFrame frame, Object object) {
        if (this.hashNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.hashNode = this.insert(DispatchHeadNodeFactory.createMethodCall(true));
        }
        return this.hashNode.call(frame, object, "hash", new Object[0]);
    }

    private Object objectID(Object object) {
        if (this.objectIDNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.objectIDNode = this.insert(ObjectNodesFactory.ObjectIDPrimitiveNodeFactory.create(null));
        }
        return this.objectIDNode.executeObjectID(object);
    }
}

