/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.math.BigInteger;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;

@CoreClass(value="Integer")
public abstract class IntegerNodes {

    @CoreMethod(names={"upto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class UpToNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode uptoInternalCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object upto(VirtualFrame frame, int from, int to, DynamicObject block) {
            int count = 0;
            try {
                for (int i = from; i <= to; ++i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return this.nil();
        }

        @Specialization
        public Object upto(VirtualFrame frame, int from, double to, DynamicObject block) {
            return this.upto(frame, from, (int)Math.floor(to), block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object upto(VirtualFrame frame, long from, long to, DynamicObject block) {
            int count = 0;
            try {
                for (long i = from; i <= to; ++i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return this.nil();
        }

        @Specialization
        public Object upto(VirtualFrame frame, long from, double to, DynamicObject block) {
            return this.upto(frame, from, (long)Math.ceil(to), block);
        }

        @Specialization(guards={"isDynamicObject(from) || isDynamicObject(to)"})
        public Object upto(VirtualFrame frame, Object from, Object to, DynamicObject block) {
            if (this.uptoInternalCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.uptoInternalCall = this.insert(DispatchHeadNodeFactory.createMethodCall());
            }
            return this.uptoInternalCall.callWithBlock(frame, from, "upto_internal", block, to);
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int toI(int n) {
            return n;
        }

        @Specialization
        public long toI(long n) {
            return n;
        }

        @Specialization(guards={"isRubyBignum(n)"})
        public DynamicObject toI(DynamicObject n) {
            return n;
        }
    }

    @CoreMethod(names={"times"}, needsBlock=true)
    public static abstract class TimesNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject times(VirtualFrame frame, int n, NotProvided block) {
            int[] array = new int[n];
            for (int i = 0; i < n; ++i) {
                array[i] = i;
            }
            return this.createArray(array, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public int times(VirtualFrame frame, int n, DynamicObject block, @Cached(value="createCountingProfile()") LoopConditionProfile loopProfile) {
            int i = 0;
            loopProfile.profileCounted(n);
            try {
                while (loopProfile.inject(i < n)) {
                    this.yield(frame, block, i);
                    ++i;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, i);
                }
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public long times(VirtualFrame frame, long n, DynamicObject block, @Cached(value="createCountingProfile()") LoopConditionProfile loopProfile) {
            long i = 0L;
            loopProfile.profileCounted(n);
            try {
                while (loopProfile.inject(i < n)) {
                    this.yield(frame, block, i);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, i < Integer.MAX_VALUE ? (int)i : Integer.MAX_VALUE);
                }
                throw throwable;
            }
            if (CompilerDirectives.inInterpreter()) {
                LoopNode.reportLoopCount(this, i < Integer.MAX_VALUE ? (int)i : Integer.MAX_VALUE);
            }
            return n;
        }

        @Specialization(guards={"isRubyBignum(n)"})
        public Object times(VirtualFrame frame, DynamicObject n, DynamicObject block, @Cached(value="create(getSourceIndexLength())") FixnumOrBignumNode fixnumOrBignumNode) {
            BigInteger i = BigInteger.ZERO;
            while (i.compareTo(Layouts.BIGNUM.getValue(n)) < 0) {
                this.yield(frame, block, fixnumOrBignumNode.fixnumOrBignum(i));
                i = i.add(BigInteger.ONE);
            }
            return n;
        }
    }

    @CoreMethod(names={"downto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class DownToNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode downtoInternalCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object downto(VirtualFrame frame, int from, int to, DynamicObject block) {
            int count = 0;
            try {
                for (int i = from; i >= to; --i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return this.nil();
        }

        @Specialization
        public Object downto(VirtualFrame frame, int from, double to, DynamicObject block) {
            return this.downto(frame, from, (int)Math.ceil(to), block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object downto(VirtualFrame frame, long from, long to, DynamicObject block) {
            int count = 0;
            try {
                for (long i = from; i >= to; --i) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, i);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    LoopNode.reportLoopCount(this, count);
                }
            }
            return this.nil();
        }

        @Specialization
        public Object downto(VirtualFrame frame, long from, double to, DynamicObject block) {
            return this.downto(frame, from, (long)Math.ceil(to), block);
        }

        @Specialization(guards={"isDynamicObject(from) || isDynamicObject(to)"})
        public Object downto(VirtualFrame frame, Object from, Object to, DynamicObject block) {
            if (this.downtoInternalCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.downtoInternalCall = this.insert(DispatchHeadNodeFactory.createMethodCall());
            }
            return this.downtoInternalCall.callWithBlock(frame, from, "downto_internal", block, to);
        }
    }
}

