/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import java.io.File;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.ReturnID;

public class ParseEnvironment {
    private LexicalScope lexicalScope = null;
    private boolean dynamicConstantLookup = false;
    private final String corePath;

    public ParseEnvironment(RubyContext context) {
        this.corePath = context.getCoreLibrary().getCoreLoadPath() + File.separator + "core" + File.separator;
    }

    public String getCorePath() {
        return this.corePath;
    }

    public void resetLexicalScope(LexicalScope lexicalScope) {
        this.lexicalScope = lexicalScope;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public LexicalScope pushLexicalScope() {
        this.lexicalScope = new LexicalScope(this.getLexicalScope());
        return this.lexicalScope;
    }

    public void popLexicalScope() {
        this.lexicalScope = this.getLexicalScope().getParent();
    }

    public boolean isDynamicConstantLookup() {
        return this.dynamicConstantLookup;
    }

    public void setDynamicConstantLookup(boolean dynamicConstantLookup) {
        this.dynamicConstantLookup = dynamicConstantLookup;
    }

    public ReturnID allocateReturnID() {
        return new ReturnID();
    }

    public BreakID allocateBreakID() {
        return new BreakID();
    }
}

