/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrEnumConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetterCallImpl;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.RematerializableValueKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J0\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u001e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J(\u0010 \u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/CallGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "addParametersToCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "call", "Lorg/jetbrains/kotlin/psi2ir/intermediate/CallBuilder;", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallWithIndexedArgumentsBase;", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateCall", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "generateCallWithArgumentReordering", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "resultType", "generateDelegatingConstructorCall", "generateEnumConstructorSuperCall", "generateFunctionCall", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateGetVariable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "typeArguments", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generatePropertyGetterCall", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "kotlin-compiler"})
public final class CallGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generateCall(int startOffset, int endOffset, @NotNull CallBuilder call2, @Nullable IrStatementOrigin origin) {
        IrExpression irExpression;
        CallableDescriptor descriptor2;
        Intrinsics.checkParameterIsNotNull(call2, "call");
        CallableDescriptor callableDescriptor = descriptor2 = call2.getDescriptor();
        if (callableDescriptor instanceof PropertyDescriptor) {
            irExpression = this.generatePropertyGetterCall((PropertyDescriptor)descriptor2, startOffset, endOffset, call2);
        } else if (callableDescriptor instanceof VariableDescriptor) {
            irExpression = call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, startOffset, endOffset, descriptor2, call2, origin){
                final /* synthetic */ CallGenerator this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ CallableDescriptor $descriptor;
                final /* synthetic */ CallBuilder $call;
                final /* synthetic */ IrStatementOrigin $origin;

                @NotNull
                public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiverValue, @Nullable IntermediateValue extensionReceiverValue) {
                    return this.this$0.generateGetVariable(this.$startOffset, this.$endOffset, (VariableDescriptor)this.$descriptor, ArgumentsGenerationUtilsKt.getTypeArguments(this.$call.getOriginal()), this.$origin);
                }
                {
                    this.this$0 = callGenerator;
                    this.$startOffset = n;
                    this.$endOffset = n2;
                    this.$descriptor = callableDescriptor;
                    this.$call = callBuilder;
                    this.$origin = irStatementOrigin;
                    super(2);
                }
            });
        } else if (callableDescriptor instanceof FunctionDescriptor) {
            irExpression = this.generateFunctionCall((FunctionDescriptor)descriptor2, startOffset, endOffset, origin, call2);
        } else {
            String string = "Unexpected callable descriptor: " + descriptor2 + " " + descriptor2.getClass().getSimpleName();
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return irExpression;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IrExpression generateCall$default(CallGenerator callGenerator, int n, int n2, CallBuilder callBuilder, IrStatementOrigin irStatementOrigin, int n3, Object object) {
        if ((n3 & 8) != 0) {
            irStatementOrigin = null;
        }
        return callGenerator.generateCall(n, n2, callBuilder, irStatementOrigin);
    }

    @NotNull
    public final IrExpression generateGetVariable(int startOffset, int endOffset, @NotNull VariableDescriptor descriptor2, @Nullable Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments, @Nullable IrStatementOrigin origin) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated()) {
            KotlinType kotlinType = ((LocalVariableDescriptor)descriptor2).getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
            VariableAccessorDescriptor variableAccessorDescriptor = ((LocalVariableDescriptor)descriptor2).getGetter();
            if (variableAccessorDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(variableAccessorDescriptor, "descriptor.getter!!");
            CallableDescriptor callableDescriptor = variableAccessorDescriptor;
            IrStatementOrigin irStatementOrigin = origin;
            if (irStatementOrigin == null) {
                irStatementOrigin = IrStatementOrigin.GET_LOCAL_PROPERTY.INSTANCE;
            }
            irExpression = new IrCallImpl(startOffset, endOffset, kotlinType, callableDescriptor, typeArguments, irStatementOrigin, null, 64, null);
        } else {
            irExpression = new IrGetValueImpl(startOffset, endOffset, descriptor2, origin);
        }
        return irExpression;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IrExpression generateGetVariable$default(CallGenerator callGenerator, int n, int n2, VariableDescriptor variableDescriptor, Map map2, IrStatementOrigin irStatementOrigin, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            irStatementOrigin = null;
        }
        return callGenerator.generateGetVariable(n, n2, variableDescriptor, map2, irStatementOrigin);
    }

    @NotNull
    public final IrExpression generateDelegatingConstructorCall(int startOffset, int endOffset, @NotNull CallBuilder call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        CallableDescriptor descriptor2 = call2.getDescriptor();
        if (!(descriptor2 instanceof ClassConstructorDescriptor)) {
            throw (Throwable)((Object)new AssertionError((Object)("Class constructor expected: " + descriptor2)));
        }
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, startOffset, endOffset, descriptor2, call2){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ CallBuilder $call;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiver, @Nullable IntermediateValue extensionReceiver) {
                IrDelegatingConstructorCallImpl irCall = new IrDelegatingConstructorCallImpl(this.$startOffset, this.$endOffset, (ClassConstructorDescriptor)this.$descriptor, ArgumentsGenerationUtilsKt.getTypeArguments(this.$call.getOriginal()));
                IntermediateValue intermediateValue = dispatchReceiver;
                irCall.setDispatchReceiver(intermediateValue != null ? intermediateValue.load() : null);
                IntermediateValue intermediateValue2 = extensionReceiver;
                irCall.setExtensionReceiver(intermediateValue2 != null ? intermediateValue2.load() : null);
                IrCallWithIndexedArgumentsBase irCallWithIndexedArgumentsBase = irCall;
                SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(this.$descriptor).getUnitType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "descriptor.builtIns.unitType");
                return CallGenerator.access$addParametersToCall(this.this$0, this.$startOffset, this.$endOffset, this.$call, irCallWithIndexedArgumentsBase, simpleType2);
            }
            {
                this.this$0 = callGenerator;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$descriptor = callableDescriptor;
                this.$call = callBuilder;
                super(2);
            }
        });
    }

    @NotNull
    public final IrExpression generateEnumConstructorSuperCall(int startOffset, int endOffset, @NotNull CallBuilder call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        CallableDescriptor constructorDescriptor = call2.getDescriptor();
        if (!(constructorDescriptor instanceof ClassConstructorDescriptor)) {
            throw (Throwable)((Object)new AssertionError((Object)("Constructor expected: " + constructorDescriptor)));
        }
        ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)constructorDescriptor).getContainingDeclaration();
        if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ENUM_CLASS) ^ true) {
            throw (Throwable)((Object)new AssertionError((Object)("Enum class constructor expected: " + classDescriptor)));
        }
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, startOffset, endOffset, constructorDescriptor, call2){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ CallableDescriptor $constructorDescriptor;
            final /* synthetic */ CallBuilder $call;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiver, @Nullable IntermediateValue extensionReceiver) {
                if (dispatchReceiver != null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Dispatch receiver should be null: " + dispatchReceiver)));
                }
                if (extensionReceiver != null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Extension receiver should be null: " + extensionReceiver)));
                }
                IrEnumConstructorCallImpl irCall = new IrEnumConstructorCallImpl(this.$startOffset, this.$endOffset, (ClassConstructorDescriptor)this.$constructorDescriptor);
                IrCallWithIndexedArgumentsBase irCallWithIndexedArgumentsBase = irCall;
                KotlinType kotlinType = ((ClassConstructorDescriptor)this.$constructorDescriptor).getReturnType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "constructorDescriptor.returnType");
                return CallGenerator.access$addParametersToCall(this.this$0, this.$startOffset, this.$endOffset, this.$call, irCallWithIndexedArgumentsBase, kotlinType);
            }
            {
                this.this$0 = callGenerator;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$constructorDescriptor = callableDescriptor;
                this.$call = callBuilder;
                super(2);
            }
        });
    }

    private final IrExpression generatePropertyGetterCall(PropertyDescriptor descriptor2, int startOffset, int endOffset, CallBuilder call2) {
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)new Function2<IntermediateValue, IntermediateValue, IrExpression>(descriptor2, startOffset, endOffset, call2){
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ CallBuilder $call;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiverValue, @Nullable IntermediateValue extensionReceiverValue) {
                IrExpression irExpression;
                PropertyGetterDescriptor propertyGetterDescriptor = this.$descriptor.getGetter();
                if (propertyGetterDescriptor != null) {
                    PropertyGetterDescriptor propertyGetterDescriptor2;
                    PropertyGetterDescriptor getter2;
                    PropertyGetterDescriptor propertyGetterDescriptor3 = getter2 = (propertyGetterDescriptor2 = propertyGetterDescriptor);
                    Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor3, "getter");
                    IntermediateValue intermediateValue = dispatchReceiverValue;
                    IntermediateValue intermediateValue2 = extensionReceiverValue;
                    irExpression = new IrGetterCallImpl(this.$startOffset, this.$endOffset, (CallableDescriptor)propertyGetterDescriptor3, ArgumentsGenerationUtilsKt.getTypeArguments(this.$call.getOriginal()), intermediateValue != null ? intermediateValue.load() : null, intermediateValue2 != null ? intermediateValue2.load() : null, IrStatementOrigin.GET_PROPERTY.INSTANCE, this.$call.getSuperQualifier());
                } else {
                    IntermediateValue intermediateValue = dispatchReceiverValue;
                    irExpression = new IrGetFieldImpl(this.$startOffset, this.$endOffset, this.$descriptor, intermediateValue != null ? intermediateValue.load() : null, (IrStatementOrigin)IrStatementOrigin.GET_PROPERTY.INSTANCE, this.$call.getSuperQualifier());
                }
                return irExpression;
            }
            {
                this.$descriptor = propertyDescriptor;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$call = callBuilder;
                super(2);
            }
        });
    }

    private final IrExpression generateFunctionCall(FunctionDescriptor descriptor2, int startOffset, int endOffset, IrStatementOrigin origin, CallBuilder call2) {
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType returnType = kotlinType;
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, startOffset, endOffset, returnType, descriptor2, call2, origin){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ KotlinType $returnType;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ CallBuilder $call;
            final /* synthetic */ IrStatementOrigin $origin;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiverValue, @Nullable IntermediateValue extensionReceiverValue) {
                KotlinType kotlinType = this.$returnType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "returnType");
                IrCallImpl irCall = new IrCallImpl(this.$startOffset, this.$endOffset, kotlinType, this.$descriptor, ArgumentsGenerationUtilsKt.getTypeArguments(this.$call.getOriginal()), this.$origin, this.$call.getSuperQualifier());
                IntermediateValue intermediateValue = dispatchReceiverValue;
                irCall.setDispatchReceiver(intermediateValue != null ? intermediateValue.load() : null);
                IntermediateValue intermediateValue2 = extensionReceiverValue;
                irCall.setExtensionReceiver(intermediateValue2 != null ? intermediateValue2.load() : null);
                IrCallWithIndexedArgumentsBase irCallWithIndexedArgumentsBase = irCall;
                KotlinType kotlinType2 = this.$returnType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "returnType");
                return CallGenerator.access$addParametersToCall(this.this$0, this.$startOffset, this.$endOffset, this.$call, irCallWithIndexedArgumentsBase, kotlinType2);
            }
            {
                this.this$0 = callGenerator;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$returnType = kotlinType;
                this.$descriptor = functionDescriptor;
                this.$call = callBuilder;
                this.$origin = irStatementOrigin;
                super(2);
            }
        });
    }

    private final IrExpression addParametersToCall(int startOffset, int endOffset, CallBuilder call2, IrCallWithIndexedArgumentsBase irCall, KotlinType returnType) {
        IrExpression irExpression;
        if (CallBuilderKt.isValueArgumentReorderingRequired(call2)) {
            irExpression = this.generateCallWithArgumentReordering(irCall, startOffset, endOffset, call2, returnType);
        } else {
            List<IrExpression> valueArguments2 = CallBuilderKt.getValueArgumentsInParameterOrder(call2);
            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)valueArguments2)) {
                int index2 = indexedValue.component1();
                IrExpression valueArgument = (IrExpression)indexedValue.component2();
                irCall.putValueArgument(index2, valueArgument);
            }
            irExpression = irCall;
        }
        return irExpression;
    }

    private final IrExpression generateCallWithArgumentReordering(IrMemberAccessExpression irCall, int startOffset, int endOffset, CallBuilder call2, KotlinType resultType) {
        Object irArgumentValue;
        ValueParameterDescriptor valueParameterDescriptor;
        Map map2;
        ResolvedCall<?> resolvedCall2 = call2.getOriginal();
        Collection<ResolvedValueArgument> valueArgumentsInEvaluationOrder = resolvedCall2.getValueArguments().values();
        List<ValueParameterDescriptor> valueParameters = resolvedCall2.getResultingDescriptor().getValueParameters();
        IrBlockImpl irBlock = new IrBlockImpl(startOffset, endOffset, resultType, IrStatementOrigin.ARGUMENTS_REORDERING_FOR_CALL.INSTANCE);
        HashMap valueArgumentsToValueParameters = new HashMap();
        List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)list2)) {
            int index2 = indexedValue.component1();
            ResolvedValueArgument valueArgument = (ResolvedValueArgument)indexedValue.component2();
            ValueParameterDescriptor valueParameter = valueParameters.get(index2);
            Map map3 = valueArgumentsToValueParameters;
            Intrinsics.checkExpressionValueIsNotNull(valueArgument, "valueArgument");
            Intrinsics.checkExpressionValueIsNotNull(valueParameter, "valueParameter");
            map3.put(map2, valueParameterDescriptor);
        }
        HashMap irArgumentValues = new HashMap();
        for (ResolvedValueArgument valueArgument : valueArgumentsInEvaluationOrder) {
            IrExpression irArgument;
            ValueParameterDescriptor valueParameter;
            Object v = valueArgumentsToValueParameters.get(valueArgument);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            ValueParameterDescriptor valueParameterDescriptor2 = valueParameter = (ValueParameterDescriptor)v;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "valueParameter");
            if (call2.getValueArgument(valueParameterDescriptor2) == null) {
                continue;
            }
            irArgumentValue = RematerializableValueKt.createTemporaryVariableInBlock(this.getScope(), irArgument, irBlock, valueParameter.getName().asString());
            map2 = irArgumentValues;
            Intrinsics.checkExpressionValueIsNotNull(valueParameter, "valueParameter");
            Object object = irArgumentValue;
            map2.put(valueParameterDescriptor, object);
        }
        List<ResolvedValueArgument> list3 = resolvedCall2.getValueArgumentsByIndex();
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        Iterable $receiver$iv = list3;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n = index$iv++;
            irArgumentValue = (ResolvedValueArgument)item$iv;
            int index3 = n;
            ValueParameterDescriptor valueParameter = valueParameters.get(index3);
            IntermediateValue intermediateValue = (IntermediateValue)irArgumentValues.get(valueParameter);
            irCall.putValueArgument(index3, intermediateValue != null ? intermediateValue.load() : null);
        }
        irBlock.getStatements().add(irCall);
        return irBlock;
    }

    public CallGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$addParametersToCall(CallGenerator $this, int startOffset, int endOffset, @NotNull CallBuilder call2, @NotNull IrCallWithIndexedArgumentsBase irCall, @NotNull KotlinType returnType) {
        return $this.addParametersToCall(startOffset, endOffset, call2, irCall, returnType);
    }
}

