RetroActive Theme for RetroArch & Lakka
====================

About RetroActive
-----------------

The initial motivation was to complete the flatui icons by coloring those in the monochrome set, it ended up becoming much more. Every icon has been redrawn and adjusted, and new icons have been added to better complete the set. A translucent white border has been added to ensure they always look great on a dark or light background.

RetroActive icons minimize the use of logos of any type and best embody the spirit of the original flatui and monochrome themes. In some cases, media label styles have been left in place to increase recognizability. An effort was also made to color-coordinate the label with the system when possible. In order to complete the theme, ported game and system-level icons still have branding.  

Source files for development of this theme can be found at https://github.com/baxysquare/baxy-retroarch-themes

Guidelines
----------

### Palette

 * Icons use the 60 color palette found in the color palette folder. 
 * The use of grayscale in 5% increments is encouraged as a baseline.  Once the icon looks great in grayscale, feel free to add color in order to make the icon as recognizable as possible.
 * Use of gradients is discouraged in favor of maintaining a flat look.
 * Translucency is discouraged except for the 8px white border, which should be set to 50% transparency. 

### Layout

 * The design should be easily recognizable.
 * The icons should be set to a 256x256 canvas and should be centered on a 64x64 grid. Snap design elements to the grid wherever possible to provide maximum clarity and scalability.
 * The icon must have a 8px white border and 8px margin, effectively reducing the icon size to 232x232.
 
### Style

 * The level of detail is expanded beyond the scope of the monochrome set, but favors flat design and recognizability over absolute realism.

### Export
 * The original source files were created with Adobe Illustrator and saved as PDF files. The SVG and PNG files can be created using the ImageMagick Mogrify command.

Colophon
----------

### Theme Font
 * This theme uses the [Metrophobic](https://fonts.google.com/specimen/Metrophobic) typeface by [Vernon Adams](http://sansoxygen.com/) coverered under the [Open Font License](http://scripts.sil.org/cms/scripts/page.php?site_id=nrsi&id=OFL_web).