/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.lib.HashSet;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

class ServerConnection
implements Runnable {
    boolean keepAlive;
    private String user;
    private String password;
    int dbID;
    private volatile Session session;
    private Socket socket;
    private Server server;
    private DataInputStream dataInput;
    private BufferedOutputStream dataOutput;
    private static int mCurrentThread = 0;
    private int mThread;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    RowOutputBinary rowOut = new RowOutputBinary(4096);
    RowInputBinary rowIn = new RowInputBinary(this.rowOut);
    Thread runnerThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConnection(Socket socket, Server server) {
        this.socket = socket;
        this.server = server;
        Object object = ServerConnection.class;
        synchronized (ServerConnection.class) {
            this.mThread = mCurrentThread++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = server.serverConnSet;
            synchronized (object) {
                server.serverConnSet.add(this);
            }
            return;
        }
    }

    void signalClose() {
        this.keepAlive = false;
        if (!Thread.currentThread().equals(this.runnerThread)) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        HashSet hashSet = this.server.serverConnSet;
        synchronized (hashSet) {
            this.server.serverConnSet.remove(this);
        }
    }

    private void init() {
        this.runnerThread = Thread.currentThread();
        this.keepAlive = true;
        try {
            Result result;
            this.socket.setTcpNoDelay(true);
            this.dataInput = new DataInputStream(this.socket.getInputStream());
            this.dataOutput = new BufferedOutputStream(this.socket.getOutputStream());
            Result result2 = Result.read(this.rowIn, this.dataInput);
            try {
                this.dbID = this.server.getDBID(result2.subSubString);
                this.user = result2.getMainString();
                this.password = result2.getSubString();
                if (!this.server.isSilent()) {
                    this.server.printWithThread(this.mThread + ":trying to connect user " + this.user);
                }
                this.session = DatabaseManager.newSession(this.dbID, result2.getMainString(), result2.getSubString());
                result = new Result(1);
                result.databaseID = this.session.getDatabase().databaseID;
                result.sessionID = this.session.getId();
            }
            catch (HsqlException hsqlException) {
                this.session = null;
                result = new Result(hsqlException, null);
            }
            catch (RuntimeException runtimeException) {
                this.session = null;
                result = new Result(runtimeException, null);
            }
            Result.write(result, this.rowOut, this.dataOutput);
            return;
        }
        catch (Exception exception) {
            this.server.printWithThread(this.mThread + ":couldn't connect " + this.user);
            this.close();
            return;
        }
    }

    public void run() {
        this.init();
        if (this.session != null) {
            try {
                while (this.keepAlive) {
                    Result result = Result.read(this.rowIn, this.dataInput);
                    this.server.printRequest(this.mThread, result);
                    Result result2 = result.mode == 10 ? this.resetSession() : this.session.execute(result);
                    Result.write(result2, this.rowOut, this.dataOutput);
                    this.rowOut.setBuffer(this.mainBuffer);
                    this.rowIn.resetRow(this.mainBuffer.length);
                }
            }
            catch (IOException iOException) {
                this.server.printWithThread(this.mThread + ":disconnected " + this.user);
            }
            catch (HsqlException hsqlException) {
                this.server.printStackTrace(hsqlException);
            }
        }
        this.close();
    }

    private Result resetSession() {
        Result result;
        if (!this.server.isSilent()) {
            this.server.printWithThread(this.mThread + ":trying to connect user " + this.user);
        }
        try {
            this.session.close();
            this.session = DatabaseManager.newSession(this.dbID, this.user, this.password);
            result = new Result(1);
            result.databaseID = this.session.getDatabase().databaseID;
            result.sessionID = this.session.getId();
        }
        catch (HsqlException hsqlException) {
            this.session = null;
            result = new Result(hsqlException, null);
        }
        return result;
    }

    String getConnectionThreadName() {
        return "HSQLDB Connection @" + Integer.toString(this.hashCode(), 16);
    }
}

