/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;

public class ValidateModelStep
extends IterateStructuralProcessStep {
    public static final int LAYOUT_OK = 0;
    public static final int NEED_MORE_DATA = 1;
    public static final int BOX_MUST_BE_CLOSED = 2;
    private Object layoutFailureNodeId;
    private int layoutFailureResolution;
    private LogicalPageBox root;

    public synchronized boolean isLayoutable(LogicalPageBox logicalPageBox) {
        this.layoutFailureNodeId = null;
        this.layoutFailureResolution = 0;
        this.root = logicalPageBox;
        this.startProcessing(logicalPageBox);
        this.root = null;
        return this.layoutFailureNodeId == null;
    }

    public Object getLayoutFailureNodeId() {
        return this.layoutFailureNodeId;
    }

    public int getLayoutFailureResolution() {
        return this.layoutFailureResolution;
    }

    protected void finishBlockBox(BlockRenderBox blockRenderBox) {
        if (this.layoutFailureNodeId != null) {
            return;
        }
        if (!blockRenderBox.isOpen()) {
            return;
        }
        if (blockRenderBox instanceof TableSectionRenderBox) {
            RenderNode renderNode = blockRenderBox.getFirstChild();
            int n = 0;
            while (renderNode != null) {
                if (!(renderNode instanceof TableRowRenderBox)) {
                    renderNode = renderNode.getNext();
                    continue;
                }
                --n;
                TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)renderNode;
                TableRowInfoStructure tableRowInfoStructure = tableRowRenderBox.getRowInfoStructure();
                if (tableRowInfoStructure.isValidationDone()) {
                    int n2 = tableRowInfoStructure.getCellCount();
                    for (int i = 0; i < n2; ++i) {
                        TableCell tableCell = tableRowInfoStructure.getCellAt(i);
                        n = Math.max(n, tableCell.getRowSpan() - 1);
                    }
                } else {
                    for (RenderNode renderNode2 = tableRowRenderBox.getFirstChild(); renderNode2 != null; renderNode2 = renderNode2.getNext()) {
                        if (!(renderNode2 instanceof TableCellRenderBox)) continue;
                        TableCellRenderBox tableCellRenderBox = (TableCellRenderBox)renderNode2;
                        n = Math.max(n, tableCellRenderBox.getRowSpan() - 1);
                    }
                }
                renderNode = renderNode.getNext();
            }
            if (n >= 1) {
                this.layoutFailureNodeId = blockRenderBox.getInstanceId();
                this.layoutFailureResolution = 1;
            }
        }
    }

    protected boolean startBlockBox(BlockRenderBox blockRenderBox) {
        if (this.layoutFailureNodeId != null) {
            return false;
        }
        if (!blockRenderBox.isOpen()) {
            return false;
        }
        if (blockRenderBox instanceof TableRenderBox) {
            TableRenderBox tableRenderBox = (TableRenderBox)blockRenderBox;
            if (tableRenderBox.isAutoLayout()) {
                this.layoutFailureNodeId = blockRenderBox.getInstanceId();
                this.layoutFailureResolution = 2;
                return false;
            }
            boolean bl = false;
            for (RenderNode renderNode = tableRenderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
                TableSectionRenderBox tableSectionRenderBox;
                if (!(renderNode instanceof TableSectionRenderBox) || !DisplayRole.TABLE_ROW_GROUP.equals((tableSectionRenderBox = (TableSectionRenderBox)renderNode).getDisplayRole())) continue;
                bl = true;
                boolean bl2 = false;
                for (RenderNode renderNode2 = tableSectionRenderBox.getVisibleFirst(); renderNode2 != null; renderNode2 = renderNode2.getNext()) {
                    if (!(renderNode2 instanceof TableRowRenderBox)) continue;
                    if (renderNode2.isOpen()) {
                        this.layoutFailureNodeId = renderNode2.getInstanceId();
                        this.layoutFailureResolution = 2;
                        return false;
                    }
                    bl2 = true;
                }
                if (bl2) continue;
                this.layoutFailureNodeId = blockRenderBox.getInstanceId();
                this.layoutFailureResolution = 1;
                return false;
            }
            if (!bl) {
                this.layoutFailureNodeId = blockRenderBox.getInstanceId();
                this.layoutFailureResolution = 1;
                return false;
            }
        } else if (blockRenderBox instanceof TableRowRenderBox) {
            TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)blockRenderBox;
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)tableRowRenderBox.getParent();
            if (DisplayRole.TABLE_ROW_GROUP.equals(tableSectionRenderBox.getDisplayRole()) && tableRowRenderBox.getVisiblePrev() == null) {
                this.layoutFailureNodeId = blockRenderBox.getInstanceId();
                this.layoutFailureResolution = 2;
                return false;
            }
        } else if (blockRenderBox instanceof ParagraphRenderBox) {
            this.layoutFailureNodeId = blockRenderBox.getInstanceId();
            this.layoutFailureResolution = 2;
            return false;
        }
        return true;
    }

    protected boolean startInlineBox(InlineRenderBox inlineRenderBox) {
        if (this.layoutFailureNodeId != null) {
            return false;
        }
        return super.startInlineBox(inlineRenderBox);
    }

    protected void startNormalFlow(NormalFlowRenderBox normalFlowRenderBox) {
        if (this.layoutFailureNodeId != null) {
            return;
        }
        if (this.root.getContentArea() != normalFlowRenderBox && normalFlowRenderBox.isOpen()) {
            this.layoutFailureNodeId = normalFlowRenderBox.getInstanceId();
            this.layoutFailureResolution = 2;
        }
    }
}

