/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.BasicGradleUI;
import org.gradle.gradleplugin.userinterface.swing.generic.MainGradlePanel;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputUILord;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.GradleTab;

public abstract class AbstractGradleUIInstance
implements BasicGradleUI {
    protected MainGradlePanel gradlePanel;
    protected GradlePluginLord gradlePluginLord = new GradlePluginLord();
    protected SettingsNode settings;
    protected AlternateUIInteraction alternateUIInteraction;
    protected JPanel mainPanel;

    public void initialize(SettingsNode settings, AlternateUIInteraction alternateUIInteraction) {
        this.settings = settings;
        this.alternateUIInteraction = alternateUIInteraction;
        this.setupUI();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    protected void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.createMainGradlePanel(), "Center");
    }

    protected Component createMainGradlePanel() {
        this.gradlePanel = new MainGradlePanel(this.gradlePluginLord, this.getOutputUILord(), this.settings, this.alternateUIInteraction);
        return this.gradlePanel;
    }

    public abstract OutputUILord getOutputUILord();

    public void aboutToShow() {
        this.gradlePanel.aboutToShow();
    }

    public boolean canClose(BasicGradleUI.CloseInteraction closeInteraction) {
        if (!this.gradlePluginLord.isBusy()) {
            return true;
        }
        return closeInteraction.promptUserToConfirmClosingWhileBusy();
    }

    public void close() {
        this.gradlePanel.aboutToClose();
    }

    public File getCurrentDirectory() {
        return this.gradlePluginLord.getCurrentDirectory();
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.gradlePluginLord.setCurrentDirectory(currentDirectory);
    }

    public void addGradleTab(int index, GradleTab gradleTab) {
        this.gradlePanel.addGradleTab(index, gradleTab);
    }

    public void removeGradleTab(GradleTab gradleTab) {
        this.gradlePanel.removeGradleTab(gradleTab);
    }

    public int getGradleTabCount() {
        return this.gradlePanel.getGradleTabCount();
    }

    public String getGradleTabName(int index) {
        return this.gradlePanel.getGradleTabName(index);
    }

    public GradlePluginLord getGradlePluginLord() {
        return this.gradlePluginLord;
    }

    public int getGradleTabIndex(String name) {
        return this.gradlePanel.getGradleTabIndex(name);
    }

    public int getCurrentGradleTab() {
        return this.gradlePanel.getCurrentGradleTab();
    }

    public void setCurrentGradleTab(int index) {
        this.gradlePanel.setCurrentGradleTab(index);
    }

    public void executeCommand(String commandLineArguments, String displayName) {
        this.gradlePluginLord.addExecutionRequestToQueue(commandLineArguments, displayName);
    }

    public void refreshTaskTree() {
        this.gradlePluginLord.addRefreshRequestToQueue();
    }

    public void refreshTaskTree(String additionalCommandLineArguments) {
        this.gradlePluginLord.addRefreshRequestToQueue(additionalCommandLineArguments);
    }

    public boolean isBusy() {
        return this.gradlePluginLord.isBusy();
    }

    public void setCustomPanelToSetupTab(JComponent component) {
        this.gradlePanel.setCustomPanelToSetupTab(component);
    }

    public void setOutputTextFont(Font font) {
        this.getOutputUILord().setOutputTextFont(font);
    }
}

