/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collection;
import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.CacheLockReleasingModuleComponentsRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.CachingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ErrorHandlingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.IvyDynamicResolveModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.LocalModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.NoRepositoriesResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.StartParameterResolutionOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.UserResolverChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryCachedRepositoryFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultComponentSelectionRules;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.resource.cached.CachedArtifactIndex;
import org.gradle.util.BuildCommencedTimeProvider;

public class ResolveIvyFactory {
    private final ModuleVersionsCache moduleVersionsCache;
    private final ModuleMetaDataCache moduleMetaDataCache;
    private final ModuleArtifactsCache moduleArtifactsCache;
    private final CachedArtifactIndex artifactAtRepositoryCachedResolutionIndex;
    private final CacheLockingManager cacheLockingManager;
    private final StartParameterResolutionOverride startParameterResolutionOverride;
    private final BuildCommencedTimeProvider timeProvider;
    private final InMemoryCachedRepositoryFactory inMemoryCache;
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;

    public ResolveIvyFactory(ModuleVersionsCache moduleVersionsCache, ModuleMetaDataCache moduleMetaDataCache, ModuleArtifactsCache moduleArtifactsCache, CachedArtifactIndex artifactAtRepositoryCachedResolutionIndex, CacheLockingManager cacheLockingManager, StartParameterResolutionOverride startParameterResolutionOverride, BuildCommencedTimeProvider timeProvider, InMemoryCachedRepositoryFactory inMemoryCache, VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator) {
        this.moduleVersionsCache = moduleVersionsCache;
        this.moduleMetaDataCache = moduleMetaDataCache;
        this.moduleArtifactsCache = moduleArtifactsCache;
        this.artifactAtRepositoryCachedResolutionIndex = artifactAtRepositoryCachedResolutionIndex;
        this.cacheLockingManager = cacheLockingManager;
        this.startParameterResolutionOverride = startParameterResolutionOverride;
        this.timeProvider = timeProvider;
        this.inMemoryCache = inMemoryCache;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
    }

    public ComponentResolvers create(ResolutionStrategyInternal resolutionStrategy, Collection<? extends ResolutionAwareRepository> repositories, ComponentMetadataProcessor metadataProcessor) {
        if (repositories.isEmpty()) {
            return new NoRepositoriesResolver();
        }
        ResolutionRules resolutionRules = resolutionStrategy.getResolutionRules();
        CachePolicy cachePolicy = resolutionStrategy.getCachePolicy();
        this.startParameterResolutionOverride.addResolutionRules(resolutionRules);
        UserResolverChain moduleResolver = new UserResolverChain(this.versionSelectorScheme, this.versionComparator, resolutionStrategy.getComponentSelection());
        ParentModuleLookupResolver parentModuleResolver = new ParentModuleLookupResolver(this.versionSelectorScheme, this.versionComparator, this.cacheLockingManager);
        for (ResolutionAwareRepository resolutionAwareRepository : repositories) {
            ConfiguredModuleComponentRepository baseRepository = resolutionAwareRepository.createResolver();
            if (baseRepository instanceof ExternalResourceResolver) {
                ((ExternalResourceResolver)baseRepository).setComponentResolvers(parentModuleResolver);
            }
            ModuleComponentRepository moduleComponentRepository = baseRepository;
            if (baseRepository.isLocal()) {
                moduleComponentRepository = new LocalModuleComponentRepository(baseRepository, metadataProcessor);
            } else {
                moduleComponentRepository = new CacheLockReleasingModuleComponentsRepository(moduleComponentRepository, this.cacheLockingManager);
                moduleComponentRepository = this.startParameterResolutionOverride.overrideModuleVersionRepository(moduleComponentRepository);
                moduleComponentRepository = new CachingModuleComponentRepository(moduleComponentRepository, this.moduleVersionsCache, this.moduleMetaDataCache, this.moduleArtifactsCache, this.artifactAtRepositoryCachedResolutionIndex, cachePolicy, this.timeProvider, metadataProcessor);
            }
            if (baseRepository.isDynamicResolveMode()) {
                moduleComponentRepository = IvyDynamicResolveModuleComponentRepositoryAccess.wrap(moduleComponentRepository);
            }
            moduleComponentRepository = this.inMemoryCache.cached(moduleComponentRepository);
            moduleComponentRepository = new ErrorHandlingModuleComponentRepository(moduleComponentRepository);
            moduleResolver.add(moduleComponentRepository);
            parentModuleResolver.add(moduleComponentRepository);
        }
        return moduleResolver;
    }

    private static class ParentModuleLookupResolver
    implements ComponentResolvers,
    DependencyToComponentIdResolver,
    ComponentMetaDataResolver,
    ArtifactResolver {
        private final CacheLockingManager cacheLockingManager;
        private final UserResolverChain delegate;

        public ParentModuleLookupResolver(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, CacheLockingManager cacheLockingManager) {
            this.delegate = new UserResolverChain(versionSelectorScheme, versionComparator, new DefaultComponentSelectionRules());
            this.cacheLockingManager = cacheLockingManager;
        }

        public void add(ModuleComponentRepository moduleComponentRepository) {
            this.delegate.add(moduleComponentRepository);
        }

        @Override
        public DependencyToComponentIdResolver getComponentIdResolver() {
            return this;
        }

        @Override
        public ComponentMetaDataResolver getComponentResolver() {
            return this;
        }

        @Override
        public ArtifactResolver getArtifactResolver() {
            return this;
        }

        @Override
        public void resolve(final DependencyMetadata dependency, final BuildableComponentIdResolveResult result) {
            this.cacheLockingManager.useCache(new Runnable(){

                @Override
                public void run() {
                    ParentModuleLookupResolver.this.delegate.getComponentIdResolver().resolve(dependency, result);
                }
            });
        }

        @Override
        public void resolve(final ComponentIdentifier identifier, final ComponentOverrideMetadata componentOverrideMetadata, final BuildableComponentResolveResult result) {
            this.cacheLockingManager.useCache(new Runnable(){

                @Override
                public void run() {
                    ParentModuleLookupResolver.this.delegate.getComponentResolver().resolve(identifier, componentOverrideMetadata, result);
                }
            });
        }

        @Override
        public void resolveArtifactsWithType(final ComponentResolveMetadata component, final ArtifactType artifactType, final BuildableArtifactSetResolveResult result) {
            this.cacheLockingManager.useCache(new Runnable(){

                @Override
                public void run() {
                    ParentModuleLookupResolver.this.delegate.getArtifactResolver().resolveArtifactsWithType(component, artifactType, result);
                }
            });
        }

        @Override
        public void resolveArtifacts(final ComponentResolveMetadata component, final BuildableComponentArtifactsResolveResult result) {
            this.cacheLockingManager.useCache(new Runnable(){

                @Override
                public void run() {
                    ParentModuleLookupResolver.this.delegate.getArtifactResolver().resolveArtifacts(component, result);
                }
            });
        }

        @Override
        public void resolveArtifact(final ComponentArtifactMetadata artifact, final ModuleSource moduleSource, final BuildableArtifactResolveResult result) {
            this.cacheLockingManager.useCache(new Runnable(){

                @Override
                public void run() {
                    ParentModuleLookupResolver.this.delegate.getArtifactResolver().resolveArtifact(artifact, moduleSource, result);
                }
            });
        }
    }
}

