/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetaData;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.DefaultCachedMetaData;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntrySerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataStore;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleMetaDataCache
implements ModuleMetaDataCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModuleMetaDataCache.class);
    private final BuildCommencedTimeProvider timeProvider;
    private final CacheLockingManager cacheLockingManager;
    private final ModuleMetadataStore moduleMetadataStore;
    private PersistentIndexedCache<ModuleComponentAtRepositoryKey, ModuleMetadataCacheEntry> cache;

    public DefaultModuleMetaDataCache(BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager, ArtifactCacheMetaData artifactCacheMetaData) {
        this.timeProvider = timeProvider;
        this.cacheLockingManager = cacheLockingManager;
        this.moduleMetadataStore = new ModuleMetadataStore(new PathKeyFileStore(artifactCacheMetaData.getMetaDataStoreDirectory()), new ModuleMetadataSerializer());
    }

    private PersistentIndexedCache<ModuleComponentAtRepositoryKey, ModuleMetadataCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private PersistentIndexedCache<ModuleComponentAtRepositoryKey, ModuleMetadataCacheEntry> initCache() {
        return this.cacheLockingManager.createCache("module-metadata", new RevisionKeySerializer(), new ModuleMetadataCacheEntrySerializer());
    }

    @Override
    public ModuleMetaDataCache.CachedMetaData getCachedModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier componentId) {
        ModuleComponentAtRepositoryKey key = this.createKey(repository, componentId);
        ModuleMetadataCacheEntry entry = (ModuleMetadataCacheEntry)this.getCache().get((Object)key);
        if (entry == null) {
            return null;
        }
        if (entry.isMissing()) {
            return new DefaultCachedMetaData(entry, null, this.timeProvider);
        }
        MutableModuleComponentResolveMetadata metadata = this.moduleMetadataStore.getModuleDescriptor(key);
        if (metadata == null) {
            this.getCache().remove((Object)key);
            return null;
        }
        return new DefaultCachedMetaData(entry, entry.configure(metadata), this.timeProvider);
    }

    @Override
    public ModuleMetaDataCache.CachedMetaData cacheMissing(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        LOGGER.debug("Recording absence of module descriptor in cache: {} [changing = {}]", (Object)id, (Object)false);
        ModuleMetadataCacheEntry entry = ModuleMetadataCacheEntry.forMissingModule(this.timeProvider.getCurrentTime());
        this.getCache().put((Object)this.createKey(repository, id), (Object)entry);
        return new DefaultCachedMetaData(entry, null, this.timeProvider);
    }

    @Override
    public ModuleMetaDataCache.CachedMetaData cacheMetaData(ModuleComponentRepository repository, ModuleComponentResolveMetadata metadata) {
        LOGGER.debug("Recording module descriptor in cache: {} [changing = {}]", (Object)metadata.getComponentId(), (Object)metadata.isChanging());
        ModuleComponentAtRepositoryKey key = this.createKey(repository, metadata.getComponentId());
        LocallyAvailableResource resource = this.moduleMetadataStore.putModuleDescriptor(key, metadata);
        ModuleMetadataCacheEntry entry = this.createEntry(metadata, resource.getSha1());
        this.getCache().put((Object)key, (Object)entry);
        return new DefaultCachedMetaData(entry, null, this.timeProvider);
    }

    private ModuleComponentAtRepositoryKey createKey(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        return new ModuleComponentAtRepositoryKey(repository.getId(), id);
    }

    private ModuleMetadataCacheEntry createEntry(ModuleComponentResolveMetadata metaData, HashValue moduleDescriptorHash) {
        return ModuleMetadataCacheEntry.forMetaData(metaData, this.timeProvider.getCurrentTime(), moduleDescriptorHash.asBigInteger());
    }

    private static class RevisionKeySerializer
    extends AbstractSerializer<ModuleComponentAtRepositoryKey> {
        private final ComponentIdentifierSerializer componentIdSerializer = new ComponentIdentifierSerializer();

        private RevisionKeySerializer() {
        }

        public void write(Encoder encoder, ModuleComponentAtRepositoryKey value) throws Exception {
            encoder.writeString((CharSequence)value.getRepositoryId());
            this.componentIdSerializer.write(encoder, (ComponentIdentifier)value.getComponentId());
        }

        public ModuleComponentAtRepositoryKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            ModuleComponentIdentifier identifier = (ModuleComponentIdentifier)this.componentIdSerializer.read(decoder);
            return new ModuleComponentAtRepositoryKey(resolverId, identifier);
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            RevisionKeySerializer rhs = (RevisionKeySerializer)((Object)obj);
            return Objects.equal((Object)((Object)this.componentIdSerializer), (Object)((Object)rhs.componentIdSerializer));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.componentIdSerializer});
        }
    }
}

