/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

public class RelationTreeModel
implements TreeModel {
    private Relation root = null;
    private final CopyOnWriteArrayList<TreeModelListener> listeners = new CopyOnWriteArrayList();

    protected int getNumRelationChildren(Relation relation) {
        if (relation == null) {
            return 0;
        }
        int n = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isRelation()) continue;
            ++n;
        }
        return n;
    }

    protected Relation getRelationChildByIdx(Relation relation, int n) {
        if (relation == null) {
            return null;
        }
        int n2 = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isRelation()) continue;
            if (n2 == n) {
                return relationMember.getRelation();
            }
            ++n2;
        }
        return null;
    }

    protected int getIndexForRelationChild(Relation relation, Relation relation2) {
        if (relation == null || relation2 == null) {
            return -1;
        }
        int n = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isRelation()) continue;
            if (relationMember.getMember() == relation2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void populate(Relation relation) {
        if (relation == null) {
            relation = new Relation();
        }
        this.root = relation;
        this.fireRootReplacedEvent();
    }

    public void populate(List<RelationMember> list) {
        if (list == null) {
            return;
        }
        Relation relation = new Relation();
        relation.setMembers(list);
        this.root = relation;
        this.fireRootReplacedEvent();
    }

    protected void fireRootReplacedEvent() {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.root));
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireRefreshNode(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public void refreshNode(TreePath treePath) {
        this.fireRefreshNode(treePath);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getRelationChildByIdx((Relation)object, n);
    }

    @Override
    public int getChildCount(Object object) {
        return this.getNumRelationChildren((Relation)object);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.getIndexForRelationChild((Relation)object, (Relation)object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        Relation relation = (Relation)object;
        if (relation.isIncomplete()) {
            return false;
        }
        return this.getNumRelationChildren(relation) == 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null) {
            this.listeners.addIfAbsent(treeModelListener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }
}

