/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Optional;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.tools.I18n;

public class XmlStreamParsingException
extends XMLStreamException {
    public XmlStreamParsingException(String string, Location location) {
        super(string);
        this.location = location;
    }

    public XmlStreamParsingException(String string, Location location, Throwable throwable) {
        super(string, throwable);
        this.location = location;
    }

    @Override
    public String getMessage() {
        String string = Optional.ofNullable(super.getMessage()).orElseGet(() -> this.getClass().getName());
        if (this.getLocation() == null) {
            return string;
        }
        string = string + ' ' + I18n.tr("(at line {0}, column {1})", this.getLocation().getLineNumber(), this.getLocation().getColumnNumber());
        int n = this.getLocation().getCharacterOffset();
        if (n > -1) {
            string = string + ". " + I18n.tr("{0} bytes have been read", n);
        }
        return string;
    }
}

