/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.CommandTargetManager;
import org.freehep.util.commanddispatcher.SimpleCommandTarget;

class MultiTarget
implements SimpleCommandTarget {
    private List l = new ArrayList();
    private MultiGroup group = new MultiGroup();
    private MultiCommandState myState = new MultiCommandState();

    MultiTarget(String command) {
    }

    void add(CommandTarget t) {
        this.l.add(t);
        this.group.notifyObservers();
        t.getGroup().addObserver(this.group);
    }

    void removeGroup(CommandGroup g) {
        boolean wasChanged = false;
        Iterator i = this.l.iterator();
        while (i.hasNext()) {
            CommandTarget t = (CommandTarget)i.next();
            if (t.getGroup() != g) continue;
            i.remove();
            g.deleteObserver(this.group);
            wasChanged = true;
        }
        if (wasChanged) {
            this.group.notifyObservers();
        }
    }

    public void enable(CommandState state) {
        this.myState.setEnabled(false);
        for (int i = 0; i < this.l.size(); ++i) {
            ((CommandTarget)this.l.get(i)).enable(this.myState);
            if (!this.myState.isEnabled()) continue;
            state.setEnabled(true);
            return;
        }
        state.setEnabled(false);
    }

    public CommandGroup getGroup() {
        return this.group;
    }

    public void invoke() {
        for (int i = 0; i < this.l.size(); ++i) {
            SimpleCommandTarget target = (SimpleCommandTarget)this.l.get(i);
            this.myState.setEnabled(false);
            target.enable(this.myState);
            if (!this.myState.isEnabled()) continue;
            target.invoke();
        }
    }

    private class MultiGroup
    extends Observable
    implements CommandGroup,
    Observer {
        private MultiGroup() {
        }

        public CommandTarget acceptCommand(String command) {
            return MultiTarget.this;
        }

        public void setManager(CommandTargetManager manager) {
        }

        public void update(Observable o, Object arg) {
            this.notifyObservers(arg);
        }

        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }

    private class MultiCommandState
    implements CommandState {
        boolean enabled = false;

        private MultiCommandState() {
        }

        boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean state) {
            this.enabled = state;
        }

        public void setText(String text) {
        }

        public void setToolTipText(String text) {
        }
    }
}

