package contextlib
import (
	πg "grumpy"
	π_grumpyΓlibΓfunctools "grumpy/lib/functools"
	π_grumpyΓlibΓsys "grumpy/lib/sys"
	π_grumpyΓlibΓwarnings "grumpy/lib/warnings"
)
func initModule(πF *πg.Frame, _ []*πg.Object) (*πg.Object, *πg.BaseException) {
	ßDeprecationWarning := πg.InternStr("DeprecationWarning")
	ßGeneratorContextManager := πg.InternStr("GeneratorContextManager")
	ßNone := πg.InternStr("None")
	ßRuntimeError := πg.InternStr("RuntimeError")
	ßStopIteration := πg.InternStr("StopIteration")
	ß__all__ := πg.InternStr("__all__")
	ß__enter__ := πg.InternStr("__enter__")
	ß__exit__ := πg.InternStr("__exit__")
	ß__init__ := πg.InternStr("__init__")
	ß__metaclass__ := πg.InternStr("__metaclass__")
	ß__module__ := πg.InternStr("__module__")
	ß__name__ := πg.InternStr("__name__")
	ßappend := πg.InternStr("append")
	ßclose := πg.InternStr("close")
	ßclosing := πg.InternStr("closing")
	ßcontextmanager := πg.InternStr("contextmanager")
	ßexc_info := πg.InternStr("exc_info")
	ßfunctools := πg.InternStr("functools")
	ßgen := πg.InternStr("gen")
	ßnested := πg.InternStr("nested")
	ßnext := πg.InternStr("next")
	ßobject := πg.InternStr("object")
	ßpop := πg.InternStr("pop")
	ßsys := πg.InternStr("sys")
	ßthing := πg.InternStr("thing")
	ßthrow := πg.InternStr("throw")
	ßwarn := πg.InternStr("warn")
	ßwarnings := πg.InternStr("warnings")
	ßwraps := πg.InternStr("wraps")
	var πTemp001 *πg.Object
	_ = πTemp001
	var πTemp002 []*πg.Object
	_ = πTemp002
	var πTemp003 *πg.Object
	_ = πTemp003
	var πTemp004 *πg.Dict
	_ = πTemp004
	var πTemp005 *πg.Object
	_ = πTemp005
	var πTemp006 []πg.FunctionArg
	_ = πTemp006
	var πTemp007 *πg.Object
	_ = πTemp007
	var πTemp008 *πg.Object
	_ = πTemp008
	var πE *πg.BaseException; _ = πE
	for ; πF.State() >= 0; πF.PopCheckpoint() {
		switch πF.State() {
		case 0:
		default: panic("unexpected function state")
		}
		// line 1: """Utilities for with-statement contexts.  See PEP 343."""
		πF.SetLineno(1)
		// line 3: import sys
		πF.SetLineno(3)
		if πTemp002, πE = πg.ImportModule(πF, "sys", []*πg.Code{π_grumpyΓlibΓsys.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßsys.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 5: import functools
		πF.SetLineno(5)
		if πTemp002, πE = πg.ImportModule(πF, "functools", []*πg.Code{π_grumpyΓlibΓfunctools.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßfunctools.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 6: wraps = functools.wraps
		πF.SetLineno(6)
		if πTemp001, πE = πg.ResolveGlobal(πF, ßfunctools); πE != nil {
			continue
		}
		if πTemp003, πE = πg.GetAttr(πF, πTemp001, ßwraps, nil); πE != nil {
			continue
		}
		if πE = πF.Globals().SetItem(πF, ßwraps.ToObject(), πTemp003); πE != nil {
			continue
		}
		// line 8: import warnings
		πF.SetLineno(8)
		if πTemp002, πE = πg.ImportModule(πF, "warnings", []*πg.Code{π_grumpyΓlibΓwarnings.Code}); πE != nil {
			continue
		}
		πTemp001 = πTemp002[0]
		if πE = πF.Globals().SetItem(πF, ßwarnings.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 9: warn = warnings.warn
		πF.SetLineno(9)
		if πTemp001, πE = πg.ResolveGlobal(πF, ßwarnings); πE != nil {
			continue
		}
		if πTemp003, πE = πg.GetAttr(πF, πTemp001, ßwarn, nil); πE != nil {
			continue
		}
		if πE = πF.Globals().SetItem(πF, ßwarn.ToObject(), πTemp003); πE != nil {
			continue
		}
		// line 12: __all__ = ["contextmanager", "nested", "closing"]
		πF.SetLineno(12)
		πTemp002 = make([]*πg.Object, 3)
		πTemp002[0] = ßcontextmanager.ToObject()
		πTemp002[1] = ßnested.ToObject()
		πTemp002[2] = ßclosing.ToObject()
		πTemp001 = πg.NewList(πTemp002...).ToObject()
		if πE = πF.Globals().SetItem(πF, ß__all__.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 14: class GeneratorContextManager(object):
		πF.SetLineno(14)
		πTemp002 = make([]*πg.Object, 1)
		if πTemp005, πE = πg.ResolveGlobal(πF, ßobject); πE != nil {
			continue
		}
		πTemp002[0] = πTemp005
		πTemp004 = πg.NewDict()
		if πTemp001, πE = πF.Globals().GetItem(πF, ß__name__.ToObject()); πE != nil {
			continue
		}
		if πE = πTemp004.SetItem(πF, ß__module__.ToObject(), πTemp001); πE != nil {
			continue
		}
		_, πE = πg.NewCode("GeneratorContextManager", "third_party/stdlib/contextlib.py", nil, 0, func(πF *πg.Frame, _ []*πg.Object) (*πg.Object, *πg.BaseException) {
			πClass := πTemp004
			_ = πClass
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 []πg.FunctionArg
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 *πg.Object
			_ = πTemp004
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 15: """Helper for @contextmanager decorator."""
				πF.SetLineno(15)
				// line 17: def __init__(self, gen):
				πF.SetLineno(17)
				πTemp002 = make([]πg.FunctionArg, 2)
				πTemp002[0] = πg.FunctionArg{Name: "self", Def: nil}
				πTemp002[1] = πg.FunctionArg{Name: "gen", Def: nil}
				πTemp001 = πg.NewFunction(πg.NewCode("__init__", "third_party/stdlib/contextlib.py", πTemp002, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
					var µself *πg.Object = πArgs[0]; _ = µself
					var µgen *πg.Object = πArgs[1]; _ = µgen
					var πTemp001 *πg.Object
					_ = πTemp001
					var πE *πg.BaseException; _ = πE
					for ; πF.State() >= 0; πF.PopCheckpoint() {
						switch πF.State() {
						case 0:
						default: panic("unexpected function state")
						}
						// line 18: self.gen = gen
						πF.SetLineno(18)
						if πE = πg.CheckLocal(πF, µgen, "gen"); πE != nil {
							continue
						}
						if πE = πg.Tie(πF, πg.TieTarget{Target: &πTemp001}, µgen); πE != nil {
							continue
						}
						if πE = πg.CheckLocal(πF, µself, "self"); πE != nil {
							continue
						}
						if πE = πg.SetAttr(πF, µself, ßgen, πTemp001); πE != nil {
							continue
						}
						return nil, nil
					}
					return nil, πE
				}), πF.Globals()).ToObject()
				if πE = πClass.SetItem(πF, ß__init__.ToObject(), πTemp001); πE != nil {
					continue
				}
				// line 20: def __enter__(self):
				πF.SetLineno(20)
				πTemp002 = make([]πg.FunctionArg, 1)
				πTemp002[0] = πg.FunctionArg{Name: "self", Def: nil}
				πTemp003 = πg.NewFunction(πg.NewCode("__enter__", "third_party/stdlib/contextlib.py", πTemp002, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
					var µself *πg.Object = πArgs[0]; _ = µself
					var πTemp001 *πg.Object
					_ = πTemp001
					var πTemp002 *πg.Object
					_ = πTemp002
					var πTemp003 *πg.BaseException
					_ = πTemp003
					var πTemp004 *πg.Traceback
					_ = πTemp004
					var πTemp005 bool
					_ = πTemp005
					var πTemp006 []*πg.Object
					_ = πTemp006
					var πE *πg.BaseException; _ = πE
					for ; πF.State() >= 0; πF.PopCheckpoint() {
						switch πF.State() {
						case 0:
						case 1: goto Label1
						default: panic("unexpected function state")
						}
						// line 21: try:
						πF.SetLineno(21)
						πF.PushCheckpoint(1)
						// line 22: return self.gen.next()
						πF.SetLineno(22)
						if πE = πg.CheckLocal(πF, µself, "self"); πE != nil {
							continue
						}
						if πTemp001, πE = πg.GetAttr(πF, µself, ßgen, nil); πE != nil {
							continue
						}
						if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßnext, nil); πE != nil {
							continue
						}
						if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
							continue
						}
						return πTemp001, nil
						πF.PopCheckpoint()
						goto Label2
					Label1:
						πTemp003, πTemp004 = πF.ExcInfo()
						if πTemp001, πE = πg.ResolveGlobal(πF, ßStopIteration); πE != nil {
							continue
						}
						if πTemp005, πE = πg.IsInstance(πF, πTemp003.ToObject(), πTemp001); πE != nil {
							continue
						}
						if πTemp005 {
							goto Label3
						}
						πE = πF.Raise(πTemp003.ToObject(), nil, πTemp004.ToObject())
						continue
						// line 23: except StopIteration:
						πF.SetLineno(23)
					Label3:
						πTemp006 = πF.MakeArgs(1)
						πTemp006[0] = πg.NewStr("generator didn't yield").ToObject()
						if πTemp001, πE = πg.ResolveGlobal(πF, ßRuntimeError); πE != nil {
							continue
						}
						if πTemp002, πE = πTemp001.Call(πF, πTemp006, nil); πE != nil {
							continue
						}
						πF.FreeArgs(πTemp006)
						// line 24: raise RuntimeError("generator didn't yield")
						πF.SetLineno(24)
						πE = πF.Raise(πTemp002, nil, nil)
						continue
						πE = nil
						πF.RestoreExc(nil, nil)
						goto Label2
					Label2:
						return nil, nil
					}
					return nil, πE
				}), πF.Globals()).ToObject()
				if πE = πClass.SetItem(πF, ß__enter__.ToObject(), πTemp003); πE != nil {
					continue
				}
				// line 26: def __exit__(self, type, value, traceback):
				πF.SetLineno(26)
				πTemp002 = make([]πg.FunctionArg, 4)
				πTemp002[0] = πg.FunctionArg{Name: "self", Def: nil}
				πTemp002[1] = πg.FunctionArg{Name: "type", Def: nil}
				πTemp002[2] = πg.FunctionArg{Name: "value", Def: nil}
				πTemp002[3] = πg.FunctionArg{Name: "traceback", Def: nil}
				πTemp004 = πg.NewFunction(πg.NewCode("__exit__", "third_party/stdlib/contextlib.py", πTemp002, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
					var µself *πg.Object = πArgs[0]; _ = µself
					var µtype *πg.Object = πArgs[1]; _ = µtype
					var µvalue *πg.Object = πArgs[2]; _ = µvalue
					var µtraceback *πg.Object = πArgs[3]; _ = µtraceback
					var µexc *πg.Object = πg.UnboundLocal; _ = µexc
					var πTemp001 *πg.Object
					_ = πTemp001
					var πTemp002 *πg.Object
					_ = πTemp002
					var πTemp003 bool
					_ = πTemp003
					var πTemp004 []*πg.Object
					_ = πTemp004
					var πTemp005 *πg.BaseException
					_ = πTemp005
					var πTemp006 *πg.Traceback
					_ = πTemp006
					var πTemp007 *πg.Object
					_ = πTemp007
					var πTemp008 *πg.Object
					_ = πTemp008
					var πTemp009 *πg.Object
					_ = πTemp009
					var πE *πg.BaseException; _ = πE
					for ; πF.State() >= 0; πF.PopCheckpoint() {
						switch πF.State() {
						case 0:
						case 9: goto Label9
						case 4: goto Label4
						default: panic("unexpected function state")
						}
						if πE = πg.CheckLocal(πF, µtype, "type"); πE != nil {
							continue
						}
						if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
							continue
						}
						πTemp001 = πg.GetBool(µtype == πTemp002).ToObject()
						if πTemp003, πE = πg.IsTrue(πF, πTemp001); πE != nil {
							return nil, πE
						}
						if πTemp003 {
							goto Label1
						}
						goto Label2
						// line 27: if type is None:
						πF.SetLineno(27)
					Label1:
						// line 28: try:
						πF.SetLineno(28)
						πF.PushCheckpoint(4)
						// line 29: self.gen.next()
						πF.SetLineno(29)
						if πE = πg.CheckLocal(πF, µself, "self"); πE != nil {
							continue
						}
						if πTemp001, πE = πg.GetAttr(πF, µself, ßgen, nil); πE != nil {
							continue
						}
						if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßnext, nil); πE != nil {
							continue
						}
						if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
							continue
						}
						πF.PopCheckpoint()
						πTemp004 = πF.MakeArgs(1)
						πTemp004[0] = πg.NewStr("generator didn't stop").ToObject()
						if πTemp001, πE = πg.ResolveGlobal(πF, ßRuntimeError); πE != nil {
							continue
						}
						if πTemp002, πE = πTemp001.Call(πF, πTemp004, nil); πE != nil {
							continue
						}
						πF.FreeArgs(πTemp004)
						// line 33: raise RuntimeError("generator didn't stop")
						πF.SetLineno(33)
						πE = πF.Raise(πTemp002, nil, nil)
						continue
						goto Label5
					Label4:
						πTemp005, πTemp006 = πF.ExcInfo()
						if πTemp001, πE = πg.ResolveGlobal(πF, ßStopIteration); πE != nil {
							continue
						}
						if πTemp003, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
							continue
						}
						if πTemp003 {
							goto Label6
						}
						πE = πF.Raise(πTemp005.ToObject(), nil, πTemp006.ToObject())
						continue
						// line 30: except StopIteration:
						πF.SetLineno(30)
					Label6:
						// line 31: return
						πF.SetLineno(31)
						return nil, nil
						πE = nil
						πF.RestoreExc(nil, nil)
						goto Label5
					Label5:
						goto Label3
					Label2:
						if πE = πg.CheckLocal(πF, µvalue, "value"); πE != nil {
							continue
						}
						if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
							continue
						}
						πTemp001 = πg.GetBool(µvalue == πTemp002).ToObject()
						if πTemp003, πE = πg.IsTrue(πF, πTemp001); πE != nil {
							return nil, πE
						}
						if πTemp003 {
							goto Label7
						}
						goto Label8
						// line 35: if value is None:
						πF.SetLineno(35)
					Label7:
						// line 38: value = type()
						πF.SetLineno(38)
						if πE = πg.CheckLocal(πF, µtype, "type"); πE != nil {
							continue
						}
						if πTemp001, πE = µtype.Call(πF, nil, nil); πE != nil {
							continue
						}
						µvalue = πTemp001
						goto Label8
					Label8:
						// line 39: try:
						πF.SetLineno(39)
						πF.PushCheckpoint(9)
						// line 40: self.gen.throw(type, value, traceback)
						πF.SetLineno(40)
						πTemp004 = πF.MakeArgs(3)
						if πE = πg.CheckLocal(πF, µtype, "type"); πE != nil {
							continue
						}
						πTemp004[0] = µtype
						if πE = πg.CheckLocal(πF, µvalue, "value"); πE != nil {
							continue
						}
						πTemp004[1] = µvalue
						if πE = πg.CheckLocal(πF, µtraceback, "traceback"); πE != nil {
							continue
						}
						πTemp004[2] = µtraceback
						if πE = πg.CheckLocal(πF, µself, "self"); πE != nil {
							continue
						}
						if πTemp001, πE = πg.GetAttr(πF, µself, ßgen, nil); πE != nil {
							continue
						}
						if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßthrow, nil); πE != nil {
							continue
						}
						if πTemp001, πE = πTemp002.Call(πF, πTemp004, nil); πE != nil {
							continue
						}
						πF.FreeArgs(πTemp004)
						πTemp004 = πF.MakeArgs(1)
						πTemp004[0] = πg.NewStr("generator didn't stop after throw()").ToObject()
						if πTemp001, πE = πg.ResolveGlobal(πF, ßRuntimeError); πE != nil {
							continue
						}
						if πTemp002, πE = πTemp001.Call(πF, πTemp004, nil); πE != nil {
							continue
						}
						πF.FreeArgs(πTemp004)
						// line 41: raise RuntimeError("generator didn't stop after throw()")
						πF.SetLineno(41)
						πE = πF.Raise(πTemp002, nil, nil)
						continue
						πF.PopCheckpoint()
						goto Label10
					Label9:
						πTemp005, πTemp006 = πF.ExcInfo()
						if πTemp001, πE = πg.ResolveGlobal(πF, ßStopIteration); πE != nil {
							continue
						}
						if πTemp003, πE = πg.IsInstance(πF, πTemp005.ToObject(), πTemp001); πE != nil {
							continue
						}
						if πTemp003 {
							goto Label11
						}
						goto Label12
						// line 42: except StopIteration, exc:
						πF.SetLineno(42)
					Label11:
						µexc = πTemp005.ToObject()
						// line 46: return exc is not value
						πF.SetLineno(46)
						if πE = πg.CheckLocal(πF, µexc, "exc"); πE != nil {
							continue
						}
						if πE = πg.CheckLocal(πF, µvalue, "value"); πE != nil {
							continue
						}
						πTemp001 = πg.GetBool(µexc != µvalue).ToObject()
						return πTemp001, nil
						πE = nil
						πF.RestoreExc(nil, nil)
						goto Label10
						// line 47: except:
						πF.SetLineno(47)
					Label12:
						πTemp002 = πg.NewInt(1).ToObject()
						if πTemp008, πE = πg.ResolveGlobal(πF, ßsys); πE != nil {
							continue
						}
						if πTemp009, πE = πg.GetAttr(πF, πTemp008, ßexc_info, nil); πE != nil {
							continue
						}
						if πTemp008, πE = πTemp009.Call(πF, nil, nil); πE != nil {
							continue
						}
						if πTemp007, πE = πg.GetItem(πF, πTemp008, πTemp002); πE != nil {
							continue
						}
						if πE = πg.CheckLocal(πF, µvalue, "value"); πE != nil {
							continue
						}
						πTemp001 = πg.GetBool(πTemp007 != µvalue).ToObject()
						if πTemp003, πE = πg.IsTrue(πF, πTemp001); πE != nil {
							return nil, πE
						}
						if πTemp003 {
							goto Label13
						}
						goto Label14
						// line 55: if sys.exc_info()[1] is not value:
						πF.SetLineno(55)
					Label13:
						// line 56: raise
						πF.SetLineno(56)
						πE = πF.Raise(nil, nil, nil)
						continue
						goto Label14
					Label14:
						πE = nil
						πF.RestoreExc(nil, nil)
						goto Label10
					Label10:
						goto Label3
					Label3:
						return nil, nil
					}
					return nil, πE
				}), πF.Globals()).ToObject()
				if πE = πClass.SetItem(πF, ß__exit__.ToObject(), πTemp004); πE != nil {
					continue
				}
				return nil, nil
			}
			return nil, πE
		}).Eval(πF, πF.Globals(), nil, nil)
		if πE != nil {
			return nil, πE
		}
		if πTemp003, πE = πTemp004.GetItem(πF, ß__metaclass__.ToObject()); πE != nil {
			return nil, πE
		}
		if πTemp003 == nil {
			πTemp003 = πg.TypeType.ToObject()
		}
		if πTemp005, πE = πTemp003.Call(πF, []*πg.Object{πg.NewStr("GeneratorContextManager").ToObject(), πg.NewTuple(πTemp002...).ToObject(), πTemp004.ToObject()}, nil); πE != nil {
			continue
		}
		if πE = πF.Globals().SetItem(πF, ßGeneratorContextManager.ToObject(), πTemp005); πE != nil {
			continue
		}
		// line 59: def contextmanager(func):
		πF.SetLineno(59)
		πTemp006 = make([]πg.FunctionArg, 1)
		πTemp006[0] = πg.FunctionArg{Name: "func", Def: nil}
		πTemp001 = πg.NewFunction(πg.NewCode("contextmanager", "third_party/stdlib/contextlib.py", πTemp006, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µfunc *πg.Object = πArgs[0]; _ = µfunc
			var µhelper *πg.Object = πg.UnboundLocal; _ = µhelper
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 []πg.FunctionArg
			_ = πTemp002
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 86: """
				πF.SetLineno(86)
				// line 87: @wraps(func)
				πF.SetLineno(87)
				πTemp002 = make([]πg.FunctionArg, 0)
				πTemp001 = πg.NewFunction(πg.NewCode("helper", "third_party/stdlib/contextlib.py", πTemp002, πg.CodeFlagVarArg | πg.CodeFlagKWArg, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
					var µargs *πg.Object = πArgs[0]; _ = µargs
					var µkwds *πg.Object = πArgs[1]; _ = µkwds
					var πTemp001 []*πg.Object
					_ = πTemp001
					var πTemp002 *πg.Object
					_ = πTemp002
					var πTemp003 *πg.Object
					_ = πTemp003
					var πE *πg.BaseException; _ = πE
					for ; πF.State() >= 0; πF.PopCheckpoint() {
						switch πF.State() {
						case 0:
						default: panic("unexpected function state")
						}
						// line 89: return GeneratorContextManager(func(*args, **kwds))
						πF.SetLineno(89)
						πTemp001 = πF.MakeArgs(1)
						if πE = πg.CheckLocal(πF, µargs, "args"); πE != nil {
							continue
						}
						if πE = πg.CheckLocal(πF, µkwds, "kwds"); πE != nil {
							continue
						}
						if πE = πg.CheckLocal(πF, µfunc, "func"); πE != nil {
							continue
						}
						if πTemp002, πE = πg.Invoke(πF, µfunc, nil, µargs, nil, µkwds); πE != nil {
							continue
						}
						πTemp001[0] = πTemp002
						if πTemp002, πE = πg.ResolveGlobal(πF, ßGeneratorContextManager); πE != nil {
							continue
						}
						if πTemp003, πE = πTemp002.Call(πF, πTemp001, nil); πE != nil {
							continue
						}
						πF.FreeArgs(πTemp001)
						return πTemp003, nil
						return nil, nil
					}
					return nil, πE
				}), πF.Globals()).ToObject()
				µhelper = πTemp001
				// line 90: return helper
				πF.SetLineno(90)
				if πE = πg.CheckLocal(πF, µhelper, "helper"); πE != nil {
					continue
				}
				return µhelper, nil
				return nil, nil
			}
			return nil, πE
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßcontextmanager.ToObject(), πTemp001); πE != nil {
			continue
		}
		// line 93: @contextmanager
		πF.SetLineno(93)
		πTemp006 = make([]πg.FunctionArg, 0)
		πTemp003 = πg.NewFunction(πg.NewCode("nested", "third_party/stdlib/contextlib.py", πTemp006, πg.CodeFlagVarArg, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
			var µmanagers *πg.Object = πArgs[0]; _ = µmanagers
			var µexits *πg.Object = πg.UnboundLocal; _ = µexits
			var µvars *πg.Object = πg.UnboundLocal; _ = µvars
			var µexc *πg.Object = πg.UnboundLocal; _ = µexc
			var µmgr *πg.Object = πg.UnboundLocal; _ = µmgr
			var µexit *πg.Object = πg.UnboundLocal; _ = µexit
			var µenter *πg.Object = πg.UnboundLocal; _ = µenter
			var πTemp001 []*πg.Object
			_ = πTemp001
			var πTemp002 *πg.Object
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 *πg.Object
			_ = πTemp004
			var πTemp005 *πg.Object
			_ = πTemp005
			var πTemp006 *πg.BaseException
			_ = πTemp006
			var πTemp007 *πg.Traceback
			_ = πTemp007
			var πTemp008 bool
			_ = πTemp008
			var πTemp009 bool
			_ = πTemp009
			var πTemp010 *πg.BaseException
			_ = πTemp010
			return πg.NewGenerator(πF, func(πSent *πg.Object) (*πg.Object, *πg.BaseException) {
				var πE *πg.BaseException; _ = πE
				for ; πF.State() >= 0; πF.PopCheckpoint() {
					switch πF.State() {
					case 0:
					case 1: goto Label1
					case 2: goto Label2
					case 6: goto Label6
					case 9: goto Label9
					default: panic("unexpected function state")
					}
					// line 107: """
					πF.SetLineno(107)
					// line 108: warn("With-statements now directly support multiple context managers",
					πF.SetLineno(108)
					πTemp001 = πF.MakeArgs(3)
					πTemp001[0] = πg.NewStr("With-statements now directly support multiple context managers").ToObject()
					if πTemp002, πE = πg.ResolveGlobal(πF, ßDeprecationWarning); πE != nil {
						continue
					}
					πTemp001[1] = πTemp002
					πTemp001[2] = πg.NewInt(3).ToObject()
					if πTemp002, πE = πg.ResolveGlobal(πF, ßwarn); πE != nil {
						continue
					}
					if πTemp003, πE = πTemp002.Call(πF, πTemp001, nil); πE != nil {
						continue
					}
					πF.FreeArgs(πTemp001)
					// line 110: exits = []
					πF.SetLineno(110)
					πTemp001 = make([]*πg.Object, 0)
					πTemp002 = πg.NewList(πTemp001...).ToObject()
					µexits = πTemp002
					// line 111: vars = []
					πF.SetLineno(111)
					πTemp001 = make([]*πg.Object, 0)
					πTemp002 = πg.NewList(πTemp001...).ToObject()
					µvars = πTemp002
					// line 112: exc = (None, None, None)
					πF.SetLineno(112)
					πTemp001 = make([]*πg.Object, 3)
					if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[0] = πTemp002
					if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[1] = πTemp002
					if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[2] = πTemp002
					πTemp002 = πg.NewTuple(πTemp001...).ToObject()
					µexc = πTemp002
					// line 113: try:
					πF.SetLineno(113)
					πF.PushCheckpoint(1)
					// line 113: try:
					πF.SetLineno(113)
					πF.PushCheckpoint(2)
					// line 114: for mgr in managers:
					πF.SetLineno(114)
					if πE = πg.CheckLocal(πF, µmanagers, "managers"); πE != nil {
						continue
					}
					if πTemp002, πE = πg.Iter(πF, µmanagers); πE != nil {
						continue
					}
				Label4:
					if πTemp003, πE = πg.Next(πF, πTemp002); πE != nil {
						isStop, exc := πg.IsInstance(πF, πE.ToObject(), πg.StopIterationType.ToObject())
						if exc != nil {
							πE = exc
							continue
						}
						if !isStop {
							continue
						}
						πE = nil
						πF.RestoreExc(nil, nil)
						goto Label5
					}
					µmgr = πTemp003
					// line 115: exit = mgr.__exit__
					πF.SetLineno(115)
					if πE = πg.CheckLocal(πF, µmgr, "mgr"); πE != nil {
						continue
					}
					if πTemp004, πE = πg.GetAttr(πF, µmgr, ß__exit__, nil); πE != nil {
						continue
					}
					µexit = πTemp004
					// line 116: enter = mgr.__enter__
					πF.SetLineno(116)
					if πE = πg.CheckLocal(πF, µmgr, "mgr"); πE != nil {
						continue
					}
					if πTemp004, πE = πg.GetAttr(πF, µmgr, ß__enter__, nil); πE != nil {
						continue
					}
					µenter = πTemp004
					// line 117: vars.append(enter())
					πF.SetLineno(117)
					πTemp001 = πF.MakeArgs(1)
					if πE = πg.CheckLocal(πF, µenter, "enter"); πE != nil {
						continue
					}
					if πTemp004, πE = µenter.Call(πF, nil, nil); πE != nil {
						continue
					}
					πTemp001[0] = πTemp004
					if πE = πg.CheckLocal(πF, µvars, "vars"); πE != nil {
						continue
					}
					if πTemp004, πE = πg.GetAttr(πF, µvars, ßappend, nil); πE != nil {
						continue
					}
					if πTemp005, πE = πTemp004.Call(πF, πTemp001, nil); πE != nil {
						continue
					}
					πF.FreeArgs(πTemp001)
					// line 118: exits.append(exit)
					πF.SetLineno(118)
					πTemp001 = πF.MakeArgs(1)
					if πE = πg.CheckLocal(πF, µexit, "exit"); πE != nil {
						continue
					}
					πTemp001[0] = µexit
					if πE = πg.CheckLocal(πF, µexits, "exits"); πE != nil {
						continue
					}
					if πTemp004, πE = πg.GetAttr(πF, µexits, ßappend, nil); πE != nil {
						continue
					}
					if πTemp005, πE = πTemp004.Call(πF, πTemp001, nil); πE != nil {
						continue
					}
					πF.FreeArgs(πTemp001)
					goto Label4
					goto Label5
				Label5:
					// line 119: yield vars
					πF.SetLineno(119)
					if πE = πg.CheckLocal(πF, µvars, "vars"); πE != nil {
						continue
					}
					πF.PushCheckpoint(6)
					return µvars, nil
				Label6:
					πTemp002 = πSent
					πF.PopCheckpoint()
					goto Label3
					// line 120: except:
					πF.SetLineno(120)
				Label2:
					// line 121: exc = sys.exc_info()
					πF.SetLineno(121)
					if πTemp002, πE = πg.ResolveGlobal(πF, ßsys); πE != nil {
						continue
					}
					if πTemp003, πE = πg.GetAttr(πF, πTemp002, ßexc_info, nil); πE != nil {
						continue
					}
					if πTemp002, πE = πTemp003.Call(πF, nil, nil); πE != nil {
						continue
					}
					µexc = πTemp002
					πE = nil
					πF.RestoreExc(nil, nil)
				Label3:
					πF.PopCheckpoint()
				Label1:
					πE = nil
					πTemp006, πTemp007 = πF.RestoreExc(nil, nil)
					// line 123: while exits:
					πF.SetLineno(123)
				Label7:
					if πE = πg.CheckLocal(πF, µexits, "exits"); πE != nil {
						continue
					}
					if πTemp008, πE = πg.IsTrue(πF, µexits); πE != nil {
						continue
					}
					if !πTemp008 {
						goto Label8
					}
					// line 124: exit = exits.pop()
					πF.SetLineno(124)
					if πE = πg.CheckLocal(πF, µexits, "exits"); πE != nil {
						continue
					}
					if πTemp002, πE = πg.GetAttr(πF, µexits, ßpop, nil); πE != nil {
						continue
					}
					if πTemp003, πE = πTemp002.Call(πF, nil, nil); πE != nil {
						continue
					}
					µexit = πTemp003
					// line 125: try:
					πF.SetLineno(125)
					πF.PushCheckpoint(9)
					if πE = πg.CheckLocal(πF, µexc, "exc"); πE != nil {
						continue
					}
					if πE = πg.CheckLocal(πF, µexit, "exit"); πE != nil {
						continue
					}
					if πTemp002, πE = πg.Invoke(πF, µexit, nil, µexc, nil, nil); πE != nil {
						continue
					}
					if πTemp009, πE = πg.IsTrue(πF, πTemp002); πE != nil {
						return nil, πE
					}
					if πTemp009 {
						goto Label11
					}
					goto Label12
					// line 126: if exit(*exc):
					πF.SetLineno(126)
				Label11:
					// line 127: exc = (None, None, None)
					πF.SetLineno(127)
					πTemp001 = make([]*πg.Object, 3)
					if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[0] = πTemp002
					if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[1] = πTemp002
					if πTemp002, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[2] = πTemp002
					πTemp002 = πg.NewTuple(πTemp001...).ToObject()
					µexc = πTemp002
					goto Label12
				Label12:
					πF.PopCheckpoint()
					goto Label10
					// line 128: except:
					πF.SetLineno(128)
				Label9:
					// line 129: exc = sys.exc_info()
					πF.SetLineno(129)
					if πTemp002, πE = πg.ResolveGlobal(πF, ßsys); πE != nil {
						continue
					}
					if πTemp003, πE = πg.GetAttr(πF, πTemp002, ßexc_info, nil); πE != nil {
						continue
					}
					if πTemp002, πE = πTemp003.Call(πF, nil, nil); πE != nil {
						continue
					}
					µexc = πTemp002
					πE = nil
					πF.RestoreExc(nil, nil)
				Label10:
					goto Label7
					goto Label8
				Label8:
					if πE = πg.CheckLocal(πF, µexc, "exc"); πE != nil {
						continue
					}
					πTemp001 = make([]*πg.Object, 3)
					if πTemp003, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[0] = πTemp003
					if πTemp003, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[1] = πTemp003
					if πTemp003, πE = πg.ResolveGlobal(πF, ßNone); πE != nil {
						continue
					}
					πTemp001[2] = πTemp003
					πTemp003 = πg.NewTuple(πTemp001...).ToObject()
					if πTemp002, πE = πg.NE(πF, µexc, πTemp003); πE != nil {
						continue
					}
					if πTemp008, πE = πg.IsTrue(πF, πTemp002); πE != nil {
						return nil, πE
					}
					if πTemp008 {
						goto Label13
					}
					goto Label14
					// line 130: if exc != (None, None, None):
					πF.SetLineno(130)
				Label13:
					πTemp002 = πg.NewInt(0).ToObject()
					if πE = πg.CheckLocal(πF, µexc, "exc"); πE != nil {
						continue
					}
					if πTemp003, πE = πg.GetItem(πF, µexc, πTemp002); πE != nil {
						continue
					}
					πTemp002 = πg.NewInt(1).ToObject()
					if πE = πg.CheckLocal(πF, µexc, "exc"); πE != nil {
						continue
					}
					if πTemp004, πE = πg.GetItem(πF, µexc, πTemp002); πE != nil {
						continue
					}
					πTemp002 = πg.NewInt(2).ToObject()
					if πE = πg.CheckLocal(πF, µexc, "exc"); πE != nil {
						continue
					}
					if πTemp005, πE = πg.GetItem(πF, µexc, πTemp002); πE != nil {
						continue
					}
					// line 134: raise exc[0], exc[1], exc[2]
					πF.SetLineno(134)
					πE = πF.Raise(πTemp003, πTemp004, πTemp005)
					continue
					goto Label14
				Label14:
					if πTemp006 != nil {
						πE = πF.Raise(πTemp006.ToObject(), nil, πTemp007.ToObject())
						continue
					}
					return nil, nil
				}
				return nil, πE
			}).ToObject(), nil
		}), πF.Globals()).ToObject()
		if πE = πF.Globals().SetItem(πF, ßnested.ToObject(), πTemp003); πE != nil {
			continue
		}
		// line 137: class closing(object):
		πF.SetLineno(137)
		πTemp002 = make([]*πg.Object, 1)
		if πTemp008, πE = πg.ResolveGlobal(πF, ßobject); πE != nil {
			continue
		}
		πTemp002[0] = πTemp008
		πTemp004 = πg.NewDict()
		if πTemp005, πE = πF.Globals().GetItem(πF, ß__name__.ToObject()); πE != nil {
			continue
		}
		if πE = πTemp004.SetItem(πF, ß__module__.ToObject(), πTemp005); πE != nil {
			continue
		}
		_, πE = πg.NewCode("closing", "third_party/stdlib/contextlib.py", nil, 0, func(πF *πg.Frame, _ []*πg.Object) (*πg.Object, *πg.BaseException) {
			πClass := πTemp004
			_ = πClass
			var πTemp001 *πg.Object
			_ = πTemp001
			var πTemp002 []πg.FunctionArg
			_ = πTemp002
			var πTemp003 *πg.Object
			_ = πTemp003
			var πTemp004 *πg.Object
			_ = πTemp004
			var πE *πg.BaseException; _ = πE
			for ; πF.State() >= 0; πF.PopCheckpoint() {
				switch πF.State() {
				case 0:
				default: panic("unexpected function state")
				}
				// line 153: """
				πF.SetLineno(153)
				// line 154: def __init__(self, thing):
				πF.SetLineno(154)
				πTemp002 = make([]πg.FunctionArg, 2)
				πTemp002[0] = πg.FunctionArg{Name: "self", Def: nil}
				πTemp002[1] = πg.FunctionArg{Name: "thing", Def: nil}
				πTemp001 = πg.NewFunction(πg.NewCode("__init__", "third_party/stdlib/contextlib.py", πTemp002, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
					var µself *πg.Object = πArgs[0]; _ = µself
					var µthing *πg.Object = πArgs[1]; _ = µthing
					var πTemp001 *πg.Object
					_ = πTemp001
					var πE *πg.BaseException; _ = πE
					for ; πF.State() >= 0; πF.PopCheckpoint() {
						switch πF.State() {
						case 0:
						default: panic("unexpected function state")
						}
						// line 155: self.thing = thing
						πF.SetLineno(155)
						if πE = πg.CheckLocal(πF, µthing, "thing"); πE != nil {
							continue
						}
						if πE = πg.Tie(πF, πg.TieTarget{Target: &πTemp001}, µthing); πE != nil {
							continue
						}
						if πE = πg.CheckLocal(πF, µself, "self"); πE != nil {
							continue
						}
						if πE = πg.SetAttr(πF, µself, ßthing, πTemp001); πE != nil {
							continue
						}
						return nil, nil
					}
					return nil, πE
				}), πF.Globals()).ToObject()
				if πE = πClass.SetItem(πF, ß__init__.ToObject(), πTemp001); πE != nil {
					continue
				}
				// line 156: def __enter__(self):
				πF.SetLineno(156)
				πTemp002 = make([]πg.FunctionArg, 1)
				πTemp002[0] = πg.FunctionArg{Name: "self", Def: nil}
				πTemp003 = πg.NewFunction(πg.NewCode("__enter__", "third_party/stdlib/contextlib.py", πTemp002, 0, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
					var µself *πg.Object = πArgs[0]; _ = µself
					var πTemp001 *πg.Object
					_ = πTemp001
					var πE *πg.BaseException; _ = πE
					for ; πF.State() >= 0; πF.PopCheckpoint() {
						switch πF.State() {
						case 0:
						default: panic("unexpected function state")
						}
						// line 157: return self.thing
						πF.SetLineno(157)
						if πE = πg.CheckLocal(πF, µself, "self"); πE != nil {
							continue
						}
						if πTemp001, πE = πg.GetAttr(πF, µself, ßthing, nil); πE != nil {
							continue
						}
						return πTemp001, nil
						return nil, nil
					}
					return nil, πE
				}), πF.Globals()).ToObject()
				if πE = πClass.SetItem(πF, ß__enter__.ToObject(), πTemp003); πE != nil {
					continue
				}
				// line 158: def __exit__(self, *exc_info):
				πF.SetLineno(158)
				πTemp002 = make([]πg.FunctionArg, 1)
				πTemp002[0] = πg.FunctionArg{Name: "self", Def: nil}
				πTemp004 = πg.NewFunction(πg.NewCode("__exit__", "third_party/stdlib/contextlib.py", πTemp002, πg.CodeFlagVarArg, func(πF *πg.Frame, πArgs []*πg.Object) (*πg.Object, *πg.BaseException) {
					var µself *πg.Object = πArgs[0]; _ = µself
					var µexc_info *πg.Object = πArgs[1]; _ = µexc_info
					var πTemp001 *πg.Object
					_ = πTemp001
					var πTemp002 *πg.Object
					_ = πTemp002
					var πE *πg.BaseException; _ = πE
					for ; πF.State() >= 0; πF.PopCheckpoint() {
						switch πF.State() {
						case 0:
						default: panic("unexpected function state")
						}
						// line 159: self.thing.close()
						πF.SetLineno(159)
						if πE = πg.CheckLocal(πF, µself, "self"); πE != nil {
							continue
						}
						if πTemp001, πE = πg.GetAttr(πF, µself, ßthing, nil); πE != nil {
							continue
						}
						if πTemp002, πE = πg.GetAttr(πF, πTemp001, ßclose, nil); πE != nil {
							continue
						}
						if πTemp001, πE = πTemp002.Call(πF, nil, nil); πE != nil {
							continue
						}
						return nil, nil
					}
					return nil, πE
				}), πF.Globals()).ToObject()
				if πE = πClass.SetItem(πF, ß__exit__.ToObject(), πTemp004); πE != nil {
					continue
				}
				return nil, nil
			}
			return nil, πE
		}).Eval(πF, πF.Globals(), nil, nil)
		if πE != nil {
			return nil, πE
		}
		if πTemp007, πE = πTemp004.GetItem(πF, ß__metaclass__.ToObject()); πE != nil {
			return nil, πE
		}
		if πTemp007 == nil {
			πTemp007 = πg.TypeType.ToObject()
		}
		if πTemp008, πE = πTemp007.Call(πF, []*πg.Object{πg.NewStr("closing").ToObject(), πg.NewTuple(πTemp002...).ToObject(), πTemp004.ToObject()}, nil); πE != nil {
			continue
		}
		if πE = πF.Globals().SetItem(πF, ßclosing.ToObject(), πTemp008); πE != nil {
			continue
		}
		return nil, nil
	}
	return nil, πE
}
var Code *πg.Code
func init() {
	Code = πg.NewCode("<module>", "third_party/stdlib/contextlib.py", nil, 0, initModule)
}
