/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadByteNode
extends FormatNode {
    private final ConditionProfile rangeProfile = ConditionProfile.createBinaryProfile();

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame, 1);
        throw new IllegalStateException();
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int index = this.advanceSourcePositionNoThrow(frame);
        if (this.rangeProfile.profile(index == -1)) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return source[index];
    }
}

