/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.joni.Region;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.regexp.MatchDataLayout;

@GeneratedBy(value=MatchDataLayout.class)
public class MatchDataLayoutImpl
extends BasicObjectLayoutImpl
implements MatchDataLayout {
    public static final MatchDataLayout INSTANCE = new MatchDataLayoutImpl();
    protected static final Shape.Allocator MATCH_DATA_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey SOURCE_IDENTIFIER = new HiddenKey("source");
    protected static final Property SOURCE_PROPERTY = Property.create(SOURCE_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey REGEXP_IDENTIFIER = new HiddenKey("regexp");
    protected static final Property REGEXP_PROPERTY = Property.create(REGEXP_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey REGION_IDENTIFIER = new HiddenKey("region");
    protected static final Property REGION_PROPERTY = Property.create(REGION_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(Region.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey VALUES_IDENTIFIER = new HiddenKey("values");
    protected static final Property VALUES_PROPERTY = Property.create(VALUES_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(Object[].class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey PRE_IDENTIFIER = new HiddenKey("pre");
    protected static final Property PRE_PROPERTY = Property.create(PRE_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey POST_IDENTIFIER = new HiddenKey("post");
    protected static final Property POST_PROPERTY = Property.create(POST_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey GLOBAL_IDENTIFIER = new HiddenKey("global");
    protected static final Property GLOBAL_PROPERTY = Property.create(GLOBAL_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey CHAR_OFFSETS_IDENTIFIER = new HiddenKey("charOffsets");
    protected static final Property CHAR_OFFSETS_PROPERTY = Property.create(CHAR_OFFSETS_IDENTIFIER, MATCH_DATA_ALLOCATOR.locationForType(Region.class), 0);

    protected MatchDataLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createMatchDataShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new MatchDataType(logicalClass, metaClass)).addProperty(SOURCE_PROPERTY).addProperty(REGEXP_PROPERTY).addProperty(REGION_PROPERTY).addProperty(VALUES_PROPERTY).addProperty(PRE_PROPERTY).addProperty(POST_PROPERTY).addProperty(GLOBAL_PROPERTY).addProperty(CHAR_OFFSETS_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createMatchData(DynamicObjectFactory factory, DynamicObject source, DynamicObject regexp, Region region, Object[] values, DynamicObject pre, DynamicObject post, DynamicObject global, Region charOffsets) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (MatchDataLayoutImpl.createsMatchData(factory));
        assert (factory.getShape().hasProperty(SOURCE_IDENTIFIER));
        assert (factory.getShape().hasProperty(REGEXP_IDENTIFIER));
        assert (factory.getShape().hasProperty(REGION_IDENTIFIER));
        assert (factory.getShape().hasProperty(VALUES_IDENTIFIER));
        assert (factory.getShape().hasProperty(PRE_IDENTIFIER));
        assert (factory.getShape().hasProperty(POST_IDENTIFIER));
        assert (factory.getShape().hasProperty(GLOBAL_IDENTIFIER));
        assert (factory.getShape().hasProperty(CHAR_OFFSETS_IDENTIFIER));
        assert (source != null);
        assert (regexp != null);
        assert (region != null);
        assert (values != null);
        assert (pre != null);
        assert (post != null);
        assert (global != null);
        return factory.newInstance(source, regexp, region, values, pre, post, global, charOffsets);
    }

    @Override
    public boolean isMatchData(Object object) {
        return object instanceof DynamicObject && this.isMatchData((DynamicObject)object);
    }

    @Override
    public boolean isMatchData(DynamicObject object) {
        return MatchDataLayoutImpl.isMatchData(object.getShape().getObjectType());
    }

    private static boolean isMatchData(ObjectType objectType) {
        return objectType instanceof MatchDataType;
    }

    private static boolean createsMatchData(DynamicObjectFactory factory) {
        return MatchDataLayoutImpl.isMatchData(factory.getShape().getObjectType());
    }

    @Override
    public DynamicObject getSource(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(SOURCE_IDENTIFIER));
        return (DynamicObject)SOURCE_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public DynamicObject getRegexp(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(REGEXP_IDENTIFIER));
        return (DynamicObject)REGEXP_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public Region getRegion(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(REGION_IDENTIFIER));
        return (Region)REGION_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public Object[] getValues(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(VALUES_IDENTIFIER));
        return (Object[])VALUES_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public DynamicObject getPre(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(PRE_IDENTIFIER));
        return (DynamicObject)PRE_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public DynamicObject getPost(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(POST_IDENTIFIER));
        return (DynamicObject)POST_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public DynamicObject getGlobal(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(GLOBAL_IDENTIFIER));
        return (DynamicObject)GLOBAL_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public Region getCharOffsets(DynamicObject object) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(CHAR_OFFSETS_IDENTIFIER));
        return (Region)CHAR_OFFSETS_PROPERTY.get(object, this.isMatchData(object));
    }

    @Override
    public void setCharOffsets(DynamicObject object, Region value) {
        assert (this.isMatchData(object));
        assert (object.getShape().hasProperty(CHAR_OFFSETS_IDENTIFIER));
        try {
            CHAR_OFFSETS_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class MatchDataType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public MatchDataType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public MatchDataType setLogicalClass(DynamicObject logicalClass) {
            return new MatchDataType(logicalClass, this.metaClass);
        }

        @Override
        public MatchDataType setMetaClass(DynamicObject metaClass) {
            return new MatchDataType(this.logicalClass, metaClass);
        }
    }
}

