/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.time;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jruby.truffle.core.time.RubyDateFormatter;
import org.jruby.truffle.core.time.RubyTimeOutputFormatter;

public class StrftimeLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int CONVERSION = 1;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\n\u0000\u0001\u0000\u0018\u0000\u0001\u0001\u0001\u0000\u0001\f\u0005\u0000\u0001\u0004\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0003\t\u0002\u0001\n\u0006\u0000\u0002\u0004\u0001\u0006\u0001\u0004\u0001\u0005\u0002\u0004\u0002\b\u0002\u0000\u0001\u0004\u0001\b\u0001\u0004\u0001\u0007\u0003\u0004\u0001\b\u0001\u0004\u0003\b\u0002\u0006\u0001\u0004\u0003\u0000\u0002\u0001\u0001\u0000\u0002\u0004\u0001\u0006\u0002\b\u0001\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0003\b\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0003\u0004\u0001\b\u0001\u0004\u0001\b\u0001\u0006\u0001\t\u0001\u000b\uff85\u0000";
    private static final char[] ZZ_CMAP = StrftimeLexer.zzUnpackCMap("\n\u0000\u0001\u0000\u0018\u0000\u0001\u0001\u0001\u0000\u0001\f\u0005\u0000\u0001\u0004\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0003\t\u0002\u0001\n\u0006\u0000\u0002\u0004\u0001\u0006\u0001\u0004\u0001\u0005\u0002\u0004\u0002\b\u0002\u0000\u0001\u0004\u0001\b\u0001\u0004\u0001\u0007\u0003\u0004\u0001\b\u0001\u0004\u0003\b\u0002\u0006\u0001\u0004\u0003\u0000\u0002\u0001\u0001\u0000\u0002\u0004\u0001\u0006\u0002\b\u0001\u0000\u0002\u0004\u0001\u0000\u0001\u0004\u0003\b\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0000\u0003\u0004\u0001\b\u0001\u0004\u0001\b\u0001\u0006\u0001\t\u0001\u000b\uff85\u0000");
    private static final int[] ZZ_ACTION = StrftimeLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0002\u0001\u0001\u0002\u0003\u0000\u0003\u0003\u0001\u0004\u0003\u0003\u0001\u0005\u0003\u0000\u0001\u0006\b\u0000";
    private static final int[] ZZ_ROWMAP = StrftimeLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\r\u0000\u001a\u0000'\u00004\u0000A\u0000N\u0000[\u00004\u0000h\u0000u\u00004\u0000\u0082\u0000\u008f\u0000\u009c\u00004\u0000\u00a9\u0000h\u0000u\u00004\u0000\u00b6\u0000\u00c3\u0000\u00d0\u0000\u00dd\u0000\u00ea\u0000\u00f7\u0000\u0104\u0000\u0111";
    private static final int[] ZZ_TRANS = StrftimeLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\f\u0003\u0001\u0004\u0004\u0000\u0001\u0005\u0001\u0006\u0001\u0005\u0001\u0007\u0002\u0005\u0001\b\u0001\u0005\u0001\u0000\f\t\u0001\u0000\u0001\t\u0001\n\u0001\u000b\u0001\n\u0001\f\u0001\r\u0001\f\u0001\u000e\u0002\f\u0001\u000f\u0001\f\u0001\u0010\u0013\u0000\u0001\u0005\u0002\u0000\u0001\u0005\u000b\u0000\u0002\u0005\r\u0000\u0001\u0011\u0001\u0005\u0002\u0000\u0001\u0012\u0001\u0013\u0001\u0012\u0001\u0014\u0001\u0015\u0001\u0014\u0001\u0016\u0002\u0014\u0001\u0017\u0001\u0014\u0003\u0000\u0002\u0013\u0001\u0014\u0001\u0015\u0001\u0014\u0001\u0016\u0002\u0014\u0001\u0017\u0001\u0014\u0007\u0000\u0001\f\u0002\u0000\u0001\f\u000b\u0000\u0002\f\r\u0000\u0001\u0018\u0001\f\u000b\u0000\u0001\u0019\u0001\u0005\u0007\u0000\u0001\u0014\u0002\u0000\u0001\u0014\u000b\u0000\u0002\u0014\r\u0000\u0001\u001a\u0001\u0014\u000b\u0000\u0001\u001b\u0001\f\f\u0000\u0001\u0005\u000b\u0000\u0001\u001c\u0001\u0014\f\u0000\u0001\f\f\u0000\u0001\u0014\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = StrftimeLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0002\u0003\u0001\t\u0003\u0000\u0001\r\u0002\u0007\u0001\r\u0003\u0005\u0001\t\u0001\u0000\u0002\u0002\u0001\r\b\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    StringBuilder stringBuf = new StringBuilder();

    private static int[] zzUnpackAction() {
        int[] result = new int[28];
        int offset = 0;
        offset = StrftimeLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[28];
        int offset = 0;
        offset = StrftimeLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[286];
        int offset = 0;
        offset = StrftimeLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[28];
        int offset = 0;
        offset = StrftimeLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public RubyDateFormatter.Token rawString() {
        String str = this.stringBuf.toString();
        this.stringBuf.setLength(0);
        return RubyDateFormatter.Token.str(str);
    }

    public RubyDateFormatter.Token directive(char c) {
        if (c == 'z') {
            int colons = this.yylength() - 1;
            return RubyDateFormatter.Token.zoneOffsetColons(colons);
        }
        RubyDateFormatter.Token token = RubyDateFormatter.Token.format(c);
        if (token != null) {
            return token;
        }
        return RubyDateFormatter.Token.special(c);
    }

    public RubyDateFormatter.Token formatter(String str) {
        char c;
        int i;
        int len = str.length();
        for (i = 1; i < len && ((c = str.charAt(i)) < '1' || c > '9'); ++i) {
        }
        String flags = str.substring(1, i);
        int width = 0;
        while (i < len) {
            width = 10 * width + (str.charAt(i) - 48);
            ++i;
        }
        return RubyDateFormatter.Token.formatter(new RubyTimeOutputFormatter(flags, width));
    }

    public StrftimeLexer(Reader in) {
        this.zzReader = in;
    }

    public StrftimeLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 110) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public RubyDateFormatter.Token yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        this.zzPushbackPos = -1;
        int zzPushbackPosL = -1;
        block14: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            boolean zzWasPushback = false;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    this.zzPushbackPos = zzPushbackPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    zzPushbackPosL = this.zzPushbackPos;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 2) == 2) {
                    zzPushbackPosL = zzCurrentPosL;
                }
                if ((zzAttributes & 1) != 1) continue;
                zzWasPushback = (zzAttributes & 4) == 4;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzWasPushback) {
                this.zzMarkedPos = zzPushbackPosL;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 5: {
                    return RubyDateFormatter.Token.str("%");
                }
                case 7: {
                    continue block14;
                }
                case 2: {
                    this.yybegin(0);
                    return this.directive(this.yycharat(this.yylength() - 1));
                }
                case 8: {
                    continue block14;
                }
                case 3: {
                    this.stringBuf.append(this.yycharat(0));
                }
                case 9: {
                    continue block14;
                }
                case 1: {
                    this.stringBuf.append(this.yycharat(0));
                    return this.rawString();
                }
                case 10: {
                    continue block14;
                }
                case 6: {
                    this.yybegin(1);
                    return this.formatter(this.yytext());
                }
                case 11: {
                    continue block14;
                }
                case 4: {
                    this.yybegin(1);
                }
                case 12: {
                    continue block14;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

