/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.TruffleFatalException;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;

public class ExceptionTranslatingNode
extends RubyNode {
    private final UnsupportedOperationBehavior unsupportedOperationBehavior;
    @Node.Child
    private RubyNode child;
    private final BranchProfile controlProfile = BranchProfile.create();
    private final BranchProfile arithmeticProfile = BranchProfile.create();
    private final BranchProfile unsupportedProfile = BranchProfile.create();
    private final BranchProfile errorProfile = BranchProfile.create();

    public ExceptionTranslatingNode(RubyNode child, UnsupportedOperationBehavior unsupportedOperationBehavior) {
        this.child = child;
        this.unsupportedOperationBehavior = unsupportedOperationBehavior;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.child.execute(frame);
        }
        catch (ControlFlowException exception) {
            this.controlProfile.enter();
            throw exception;
        }
        catch (ArithmeticException exception) {
            this.arithmeticProfile.enter();
            throw new RaiseException(this.translate(exception));
        }
        catch (UnsupportedSpecializationException exception) {
            this.unsupportedProfile.enter();
            throw new RaiseException(this.translate(exception));
        }
        catch (TruffleFatalException exception) {
            this.errorProfile.enter();
            throw exception;
        }
        catch (StackOverflowError error) {
            this.errorProfile.enter();
            throw new RaiseException(this.translate(error));
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (IllegalArgumentException e) {
            this.errorProfile.enter();
            throw new RaiseException(this.translate(e));
        }
        catch (Throwable exception) {
            this.errorProfile.enter();
            throw new RaiseException(this.translate(exception));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject translate(ArithmeticException exception) {
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA) {
            exception.printStackTrace();
        }
        return this.coreExceptions().zeroDivisionError(this, exception);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject translate(StackOverflowError error) {
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA) {
            error.printStackTrace();
        }
        return this.coreExceptions().systemStackErrorStackLevelTooDeep(this, error);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject translate(IllegalArgumentException exception) {
        String message;
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA) {
            exception.printStackTrace();
        }
        if ((message = exception.getMessage()) == null) {
            message = exception.toString();
        }
        return this.coreExceptions().argumentError(message, (Node)this, (Throwable)exception);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject translate(UnsupportedSpecializationException exception) {
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA) {
            exception.printStackTrace();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Truffle doesn't have a case for the ");
        builder.append(exception.getNode().getClass().getName());
        builder.append(" node with values of type ");
        for (Object value : exception.getSuppliedValues()) {
            builder.append(" ");
            if (value == null) {
                builder.append("null");
            } else if (value instanceof DynamicObject) {
                DynamicObject dynamicObject = (DynamicObject)value;
                builder.append(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(dynamicObject)).getName());
                builder.append("(");
                builder.append(value.getClass().getName());
                builder.append(")");
                if (RubyGuards.isRubyArray(value)) {
                    DynamicObject array = (DynamicObject)value;
                    builder.append("[");
                    if (Layouts.ARRAY.getStore(array) == null) {
                        builder.append("null");
                    } else {
                        builder.append(Layouts.ARRAY.getStore(array).getClass().getName());
                    }
                    builder.append(",");
                    builder.append(Layouts.ARRAY.getSize(array));
                    builder.append("]");
                } else if (RubyGuards.isRubyHash(value)) {
                    Object store = Layouts.HASH.getStore((DynamicObject)value);
                    if (store == null) {
                        builder.append("[null]");
                    } else {
                        builder.append("[");
                        builder.append(store.getClass().getName());
                        builder.append("]");
                    }
                }
            } else {
                builder.append(value.getClass().getName());
            }
            if (!(value instanceof Number) && !(value instanceof Boolean)) continue;
            builder.append("=");
            builder.append(value.toString());
        }
        switch (this.unsupportedOperationBehavior) {
            case TYPE_ERROR: {
                return this.coreExceptions().typeError(builder.toString(), this, exception);
            }
            case ARGUMENT_ERROR: {
                return this.coreExceptions().argumentError(builder.toString(), (Node)this, (Throwable)exception);
            }
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject translate(Throwable throwable) {
        Throwable t;
        if (throwable instanceof AssertionError && !this.getContext().getOptions().EXCEPTIONS_TRANSLATE_ASSERT) {
            throw (AssertionError)((Object)throwable);
        }
        if (this.getContext().getOptions().EXCEPTIONS_PRINT_JAVA || this.getContext().getOptions().EXCEPTIONS_PRINT_UNCAUGHT_JAVA) {
            throwable.printStackTrace();
        }
        if ((t = throwable) instanceof JavaException) {
            t = t.getCause();
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append('\n');
        while (t != null) {
            String message = t.getMessage();
            messageBuilder.append(t.getClass().getSimpleName());
            messageBuilder.append(" ");
            if (message != null) {
                messageBuilder.append(message);
            } else {
                messageBuilder.append("<no message>");
            }
            if (t.getStackTrace().length > 0) {
                messageBuilder.append(" ");
                messageBuilder.append(t.getStackTrace()[0].toString());
            }
            if ((t = t.getCause()) == null) continue;
            messageBuilder.append("\nCaused by: ");
        }
        return this.coreExceptions().internalError(messageBuilder.toString(), this, throwable);
    }
}

