/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.element.interfaces.GridElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Selector {
    private void selectHelper(boolean applyAfterAction, Collection<GridElement> elements) {
        for (GridElement e : this.expand(elements)) {
            if (this.getSelectedElements().contains(e)) continue;
            this.getSelectedElements().add(e);
            this.doAfterSelect(e);
        }
        if (applyAfterAction) {
            this.doAfterSelectionChanged();
        }
    }

    private void deselectHelper(boolean applyAfterAction, Collection<GridElement> elements) {
        for (GridElement e : this.expand(elements)) {
            Iterator<GridElement> iter = this.getSelectedElements().iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(e)) continue;
                iter.remove();
                this.doAfterDeselect(e);
            }
        }
        if (applyAfterAction) {
            this.doAfterSelectionChanged();
        }
    }

    private List<GridElement> expand(Collection<GridElement> elements) {
        Map<Integer, Collection<GridElement>> map = Selector.createGroupElementMap(this.getAllElements());
        ArrayList<GridElement> elemenentsWithGroups = new ArrayList<GridElement>();
        for (GridElement e : elements) {
            Collection<GridElement> set;
            if (e.getGroup() == null || (set = map.get(e.getGroup())) == null) continue;
            for (GridElement g : set) {
                if (g == e) continue;
                elemenentsWithGroups.add(g);
            }
        }
        elemenentsWithGroups.addAll(elements);
        return elemenentsWithGroups;
    }

    public void select(GridElement element) {
        this.select(Arrays.asList(element));
    }

    public void deselect(GridElement element) {
        this.deselect(Arrays.asList(element));
    }

    public abstract List<GridElement> getSelectedElements();

    public boolean isSelected(GridElement ge) {
        return this.getSelectedElements().contains(ge);
    }

    public boolean isSelectedOnly(GridElement ge) {
        return this.getSelectedElements().size() == 1 && this.isSelected(ge);
    }

    public void selectOnly(GridElement element) {
        this.selectOnly(Arrays.asList(element));
    }

    public void selectOnly(Collection<GridElement> elements) {
        this.deselectHelper(false, this.getSelectedElements());
        this.selectHelper(true, elements);
    }

    public void select(Collection<GridElement> elements) {
        this.selectHelper(true, elements);
    }

    public void deselect(Collection<GridElement> elements) {
        this.deselectHelper(true, elements);
    }

    public void deselectAll() {
        this.deselect(this.getSelectedElements());
    }

    public void deselectAllWithoutAfterAction() {
        this.deselectHelper(false, this.getSelectedElements());
    }

    public void doAfterDeselect(GridElement e) {
        e.getComponent().afterModelUpdate();
    }

    public void doAfterSelectionChanged() {
    }

    public void doAfterSelect(GridElement e) {
        e.getComponent().afterModelUpdate();
    }

    public void moveToLastPosInList(GridElement element) {
        List<GridElement> elements = this.getSelectedElements();
        elements.remove(element);
        elements.add(element);
    }

    public Integer getUnusedGroup() {
        return Selector.getUnusedGroupId(Selector.createGroupElementMap(this.getAllElements()).keySet());
    }

    public abstract List<GridElement> getAllElements();

    public static void replaceGroupsWithNewGroups(Collection<GridElement> elements, Selector selector) {
        HashSet<Integer> usedIds = new HashSet<Integer>(Selector.createGroupElementMap(selector.getAllElements()).keySet());
        Map<Integer, Collection<GridElement>> groupedElements = Selector.createGroupElementMap(elements);
        for (Map.Entry<Integer, Collection<GridElement>> entry : groupedElements.entrySet()) {
            Integer unusedId = Selector.getUnusedGroupId(usedIds);
            usedIds.add(unusedId);
            for (GridElement e : entry.getValue()) {
                e.setProperty("group", unusedId);
            }
        }
    }

    public static Integer getUnusedGroupId(Collection<Integer> usedGroups) {
        Integer newGroup = usedGroups.isEmpty() ? Integer.valueOf(1) : Integer.valueOf(Collections.max(usedGroups) + 1);
        return newGroup;
    }

    public static Map<Integer, Collection<GridElement>> createGroupElementMap(Collection<GridElement> elements) {
        HashMap<Integer, Collection<GridElement>> returnmap = new HashMap<Integer, Collection<GridElement>>();
        for (GridElement e : elements) {
            if (e.getGroup() == null) continue;
            ArrayList<GridElement> elementsWithGroup = (ArrayList<GridElement>)returnmap.get(e.getGroup());
            if (elementsWithGroup == null) {
                elementsWithGroup = new ArrayList<GridElement>();
                returnmap.put(e.getGroup(), elementsWithGroup);
            }
            elementsWithGroup.add(e);
        }
        return returnmap;
    }
}

