/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Container;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DefaultLayoutStyle
extends LayoutStyle {
    private static final DefaultLayoutStyle INSTANCE = new DefaultLayoutStyle();

    public static LayoutStyle getInstance() {
        return INSTANCE;
    }

    @Override
    public int getPreferredGap(JComponent component1, JComponent component2, LayoutStyle.ComponentPlacement type, int position, Container parent) {
        int indent;
        if (component1 == null || component2 == null || type == null) {
            throw new NullPointerException();
        }
        this.checkPosition(position);
        if (type == LayoutStyle.ComponentPlacement.INDENT && (position == 3 || position == 7) && (indent = this.getIndent(component1, position)) > 0) {
            return indent;
        }
        return type == LayoutStyle.ComponentPlacement.UNRELATED ? 12 : 6;
    }

    @Override
    public int getContainerGap(JComponent component, int position, Container parent) {
        if (component == null) {
            throw new NullPointerException();
        }
        this.checkPosition(position);
        return 6;
    }

    protected boolean isLabelAndNonlabel(JComponent c1, JComponent c2, int position) {
        if (position == 3 || position == 7) {
            boolean c1Label = c1 instanceof JLabel;
            boolean c2Label = c2 instanceof JLabel;
            return (c1Label || c2Label) && c1Label != c2Label;
        }
        return false;
    }

    protected int getButtonGap(JComponent source, JComponent target, int position, int offset) {
        if ((offset -= this.getButtonGap(source, position)) > 0) {
            offset -= this.getButtonGap(target, this.flipDirection(position));
        }
        if (offset < 0) {
            return 0;
        }
        return offset;
    }

    protected int getButtonGap(JComponent source, int position, int offset) {
        return Math.max(offset -= this.getButtonGap(source, position), 0);
    }

    public int getButtonGap(JComponent c, int position) {
        Border border;
        String classID = c.getUIClassID();
        if ((classID == "CheckBoxUI" || classID == "RadioButtonUI") && !((AbstractButton)c).isBorderPainted() && (border = c.getBorder()) instanceof UIResource) {
            return this.getInset(c, position);
        }
        return 0;
    }

    private void checkPosition(int position) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException();
        }
    }

    protected int flipDirection(int position) {
        switch (position) {
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        assert (false);
        return 0;
    }

    protected int getIndent(JComponent c, int position) {
        String classID = c.getUIClassID();
        if (classID == "CheckBoxUI" || classID == "RadioButtonUI") {
            AbstractButton button = (AbstractButton)c;
            Insets insets = c.getInsets();
            Icon icon = this.getIcon(button);
            int gap = button.getIconTextGap();
            if (this.isLeftAligned(button, position)) {
                return insets.left + icon.getIconWidth() + gap;
            }
            if (this.isRightAligned(button, position)) {
                return insets.right + icon.getIconWidth() + gap;
            }
        }
        return 0;
    }

    private Icon getIcon(AbstractButton button) {
        Object oIcon;
        Icon icon = button.getIcon();
        if (icon != null) {
            return icon;
        }
        String key = null;
        if (button instanceof JCheckBox) {
            key = "CheckBox.icon";
        } else if (button instanceof JRadioButton) {
            key = "RadioButton.icon";
        }
        if (key != null && (oIcon = UIManager.get(key)) instanceof Icon) {
            return (Icon)oIcon;
        }
        return null;
    }

    private boolean isLeftAligned(AbstractButton button, int position) {
        if (position == 7) {
            boolean ltr = button.getComponentOrientation().isLeftToRight();
            int hAlign = button.getHorizontalAlignment();
            return ltr && (hAlign == 2 || hAlign == 10) || !ltr && hAlign == 11;
        }
        return false;
    }

    private boolean isRightAligned(AbstractButton button, int position) {
        if (position == 3) {
            boolean ltr = button.getComponentOrientation().isLeftToRight();
            int hAlign = button.getHorizontalAlignment();
            return ltr && (hAlign == 4 || hAlign == 11) || !ltr && hAlign == 10;
        }
        return false;
    }

    private int getInset(JComponent c, int position) {
        return this.getInset(c.getInsets(), position);
    }

    private int getInset(Insets insets, int position) {
        if (insets == null) {
            return 0;
        }
        switch (position) {
            case 1: {
                return insets.top;
            }
            case 5: {
                return insets.bottom;
            }
            case 3: {
                return insets.right;
            }
            case 7: {
                return insets.left;
            }
        }
        assert (false);
        return 0;
    }
}

