/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.event.SimpleProfilingStateAdapter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.SnippetPanel;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.LockContentionWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.actions.HeapDumpAction;
import org.netbeans.modules.profiler.actions.ModifyProfilingAction;
import org.netbeans.modules.profiler.actions.RerunAction;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.RunGCAction;
import org.netbeans.modules.profiler.actions.ShowTelemetryViewAction;
import org.netbeans.modules.profiler.actions.StopAction;
import org.netbeans.modules.profiler.actions.TelemetryOverviewAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ProfilerControlPanel2
extends ProfilerTopComponent {
    private static final Logger LOGGER = Logger.getLogger(ProfilerControlPanel2.class.getName());
    private static final String HELP_CTX_KEY = "ProfilerControlPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProfilerControlPanel.HelpCtx");
    private static final String RENAME_SNAPSHOT_HELP_CTX_KEY = "ProfilerControlPanel.RenameSnapshot.HelpCtx";
    private static final HelpCtx RENAME_SNAPSHOT_HELP_CTX = new HelpCtx("ProfilerControlPanel.RenameSnapshot.HelpCtx");
    private static ProfilerControlPanel2 defaultInstance;
    private static final Image windowIcon;
    private static final Icon cpuIcon;
    private static final Icon fragmentIcon;
    private static final Icon memoryIcon;
    private static final Icon heapDumpIcon;
    private static final Icon emptyIcon;
    private static final String ID = "profiler_cp";
    private static final Integer EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS;
    private static final Color CP_BACKGROUND_COLOR;
    private final BasicTelemetryPanel basicTelemetrySnippet;
    private final JScrollPane scrollPane;
    private final ResultsSnippetPanel resultsSnippet;
    private final SnapshotsPanel snapshotsSnippet;
    private final SnippetPanel spBasicTelemetry;
    private final SnippetPanel spControls;
    private final SnippetPanel spResults;
    private final SnippetPanel spSnapshots;
    private final SnippetPanel spStatus;
    private final SnippetPanel spView;
    private final StatusPanel statusSnippet;
    private boolean initialized = false;
    private Listener listener;

    public ProfilerControlPanel2() {
        this.setName(Bundle.LAB_ControlPanelName());
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_ControlPanelAcessDescr());
        this.setLayout(new BorderLayout());
        ControlsPanel controlsPanel = new ControlsPanel();
        this.statusSnippet = new StatusPanel();
        ViewPanel viewPanel = new ViewPanel();
        this.snapshotsSnippet = new SnapshotsPanel();
        this.resultsSnippet = new ResultsSnippetPanel();
        this.basicTelemetrySnippet = new BasicTelemetryPanel();
        SnippetPanel.Padding padding = new SnippetPanel.Padding();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.spControls = new SnippetPanel(Bundle.ProfilerControlPanel2_ControlsSnippetName(), (JComponent)controlsPanel);
        jPanel.add((Component)this.spControls, gridBagConstraints);
        this.spStatus = new SnippetPanel(Bundle.ProfilerControlPanel2_StatusSnippetName(), (JComponent)this.statusSnippet);
        jPanel.add((Component)this.spStatus, gridBagConstraints);
        this.spResults = new SnippetPanel(Bundle.ProfilerControlPanel2_ResultsSnippetName(), (JComponent)this.resultsSnippet);
        jPanel.add((Component)this.spResults, gridBagConstraints);
        this.spSnapshots = new SnippetPanel(Bundle.ProfilerControlPanel2_SnapshotsSnippetName(), (JComponent)this.snapshotsSnippet);
        jPanel.add((Component)this.spSnapshots, gridBagConstraints);
        this.spView = new SnippetPanel(Bundle.ProfilerControlPanel2_ViewSnippetName(), (JComponent)viewPanel);
        jPanel.add((Component)this.spView, gridBagConstraints);
        this.spBasicTelemetry = new SnippetPanel(Bundle.ProfilerControlPanel2_TelemetrySnippetName(), (JComponent)this.basicTelemetrySnippet);
        jPanel.add((Component)this.spBasicTelemetry, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)padding, gridBagConstraints);
        this.scrollPane = new JScrollPane(jPanel, 20, 30);
        this.spControls.setBorder((Border)BorderFactory.createMatteBorder(2, 0, 0, 0, CP_BACKGROUND_COLOR));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setBackground(CP_BACKGROUND_COLOR);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.add(this.scrollPane, "Center");
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)new SimpleProfilingStateAdapter(){

            protected void update() {
                ProfilerControlPanel2.this.updateStatus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ProfilerControlPanel2.this.scrollPane.getVerticalScrollBar().setBlockIncrement((int)((float)ProfilerControlPanel2.this.scrollPane.getVerticalScrollBar().getModel().getExtent() * 0.95f));
                ProfilerControlPanel2.this.scrollPane.getHorizontalScrollBar().setBlockIncrement((int)((float)ProfilerControlPanel2.this.scrollPane.getHorizontalScrollBar().getModel().getExtent() * 0.95f));
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.listener = (Listener)Lookup.getDefault().lookup(Listener.class);
        this.listener.setDelegate((Object)this);
    }

    public static synchronized boolean hasDefault() {
        return defaultInstance != null;
    }

    public static synchronized ProfilerControlPanel2 getDefault() {
        while (defaultInstance == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    defaultInstance = (ProfilerControlPanel2)WindowManager.getDefault().findTopComponent(ProfilerControlPanel2.ID);
                    if (defaultInstance == null) {
                        defaultInstance = new ProfilerControlPanel2();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
                break;
            }
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                ProfilerLogger.info((String)("InterruptedException in ProfilerControlPanel2.getDefault() [will retry]: " + interruptedException.getMessage()));
            }
            catch (Throwable throwable) {
                ProfilerLogger.severe((String)("Throwable in ProfilerControlPanel2.getDefault(): " + throwable.getMessage()));
                break;
            }
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setProfiledProject(Lookup.Provider provider) {
        this.snapshotsSnippet.setDisplayedProject(provider);
    }

    public String getToolTipText() {
        return Bundle.ProfilerControlPanel2_ControlPanelToolTip();
    }

    public static synchronized void closeIfOpened() {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (defaultInstance != null && defaultInstance.isOpened()) {
                    defaultInstance.close();
                }
            }
        });
    }

    public int getPersistenceType() {
        return 0;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.spControls;
    }

    public boolean needsDocking() {
        return WindowManager.getDefault().findMode((TopComponent)this) == null;
    }

    public void open() {
        Mode mode;
        if (this.needsDocking() && (mode = WindowManager.getDefault().findMode(Bundle.ProfilerControlPanel2_WindowMode())) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.initialized) {
            this.initialized = true;
            this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Integer n;
        super.readExternal(objectInput);
        try {
            n = (Integer)objectInput.readObject();
        }
        catch (Exception exception) {
            ProfilerLogger.severe((String)("Error while deserializing Profiler CP2: " + exception.getMessage()));
            LOGGER.log(Level.WARNING, null, exception);
            return;
        }
        if (n.compareTo(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS) > 0) {
            return;
        }
        this.spControls.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spStatus.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spResults.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spView.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        this.spBasicTelemetry.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        if (n.equals(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS)) {
            this.spSnapshots.setCollapsed(((Boolean)objectInput.readObject()).booleanValue());
        }
    }

    public void refreshSnapshotsList() {
        if (this.snapshotsSnippet != null) {
            this.snapshotsSnippet.refreshList();
        }
    }

    public void updateStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerControlPanel2.this.statusSnippet.refreshStatus();
                ProfilerControlPanel2.this.resultsSnippet.refreshStatus();
                ProfilerControlPanel2.this.basicTelemetrySnippet.refreshStatus();
            }
        });
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS);
        objectOutput.writeObject(this.spControls.isCollapsed());
        objectOutput.writeObject(this.spStatus.isCollapsed());
        objectOutput.writeObject(this.spResults.isCollapsed());
        objectOutput.writeObject(this.spView.isCollapsed());
        objectOutput.writeObject(this.spBasicTelemetry.isCollapsed());
        objectOutput.writeObject(this.spSnapshots.isCollapsed());
    }

    protected String preferredID() {
        return ID;
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowControlPanel");
        cpuIcon = Icons.getIcon((String)"ProfilerIcons.Cpu");
        fragmentIcon = Icons.getIcon((String)"ProfilerIcons.Fragment");
        memoryIcon = Icons.getIcon((String)"ProfilerIcons.Memory");
        heapDumpIcon = Icons.getIcon((String)"ProfilerIcons.HeapDump");
        emptyIcon = Icons.getIcon((String)"GeneralIcons.Empty");
        EXTERNALIZABLE_VERSION_WITH_SNAPSHOTS = 3;
        CP_BACKGROUND_COLOR = UIUtils.getProfilerResultsBackground();
    }

    private static final class RenameSnapshotPanel
    extends JPanel {
        private JTextField textField;

        RenameSnapshotPanel() {
            this.initComponents();
        }

        String getSnapshotName() {
            return this.textField.getText().trim();
        }

        void setSnapshotName(String string) {
            this.textField.setText(string);
            this.textField.selectAll();
        }

        private void initComponents() {
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.ProfilerControlPanel2_NewFileNameLbl());
            jLabel.setAlignmentX(0.0f);
            this.textField = new JTextField();
            jLabel.setLabelFor(this.textField);
            this.textField.setPreferredSize(new Dimension(350, this.textField.getPreferredSize().height));
            this.textField.requestFocus();
            this.textField.setAlignmentX(0.0f);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(15, 10, 5, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 15, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.textField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
        }
    }

    private static final class ViewPanel
    extends CPPanel
    implements ActionListener {
        private final JButton threadsButton;
        private final JButton vmTelemetryButton;
        private final JButton locksButton;

        ViewPanel() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(7, 6, 8, 6));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            this.vmTelemetryButton = new JButton(Bundle.ProfilerControlPanel2_TelemetryButtonName(), Icons.getIcon((String)"ProfilerIcons.ViewTelemetry32"));
            UIUtils.fixButtonUI((AbstractButton)this.vmTelemetryButton);
            this.vmTelemetryButton.addActionListener(this);
            this.vmTelemetryButton.setContentAreaFilled(false);
            this.vmTelemetryButton.setMargin(new Insets(1, 1, 1, 1));
            this.vmTelemetryButton.setVerticalTextPosition(3);
            this.vmTelemetryButton.setHorizontalTextPosition(0);
            this.vmTelemetryButton.setRolloverEnabled(true);
            this.vmTelemetryButton.setBorder(compoundBorder);
            this.vmTelemetryButton.setToolTipText(Bundle.ProfilerControlPanel2_TelemetryButtonToolTip());
            this.threadsButton = new JButton(Bundle.ProfilerControlPanel2_ThreadsButtonName(), Icons.getIcon((String)"ProfilerIcons.ViewThreads32"));
            UIUtils.fixButtonUI((AbstractButton)this.threadsButton);
            this.threadsButton.addActionListener(this);
            this.threadsButton.setContentAreaFilled(false);
            this.threadsButton.setMargin(new Insets(1, 1, 1, 1));
            this.threadsButton.setVerticalTextPosition(3);
            this.threadsButton.setHorizontalTextPosition(0);
            this.threadsButton.setRolloverEnabled(true);
            this.threadsButton.setBorder(compoundBorder);
            this.threadsButton.setToolTipText(Bundle.ProfilerControlPanel2_ThreadsButtonToolTip());
            this.locksButton = new JButton(Bundle.ProfilerControlPanel2_LocksButtonName(), Icons.getIcon((String)"ProfilerIcons.ViewLocks32"));
            UIUtils.fixButtonUI((AbstractButton)this.locksButton);
            this.locksButton.addActionListener(this);
            this.locksButton.setContentAreaFilled(false);
            this.locksButton.setMargin(new Insets(1, 1, 1, 1));
            this.locksButton.setVerticalTextPosition(3);
            this.locksButton.setHorizontalTextPosition(0);
            this.locksButton.setRolloverEnabled(true);
            this.locksButton.setBorder(compoundBorder);
            this.locksButton.setToolTipText(Bundle.ProfilerControlPanel2_LocksButtonToolTip());
            this.add(this.vmTelemetryButton);
            this.add(this.threadsButton);
            this.add(this.locksButton);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.vmTelemetryButton) {
                new ShowTelemetryViewAction().actionPerformed(null);
            } else if (actionEvent.getSource() == this.threadsButton) {
                ThreadsWindow.getDefault().showThreads();
            } else if (actionEvent.getSource() == this.locksButton) {
                LockContentionWindow.getDefault().showView();
            }
        }
    }

    private static final class StatusPanel
    extends CPPanel {
        private final JLabel modeValueLabel;
        private final JLabel onLabel;
        private final JLabel onValueLabel;
        private final JLabel profileValueLabel;
        private final JLabel statusValueLabel;
        private final JLabel typeValueLabel;
        private int profilingType;
        private String host = null;
        private int count = 0;
        private int mode = -1;
        private int state = -1;

        StatusPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(8, 3, 9, 3));
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(Bundle.ProfilerControlPanel2_ModeLabelString());
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            JLabel jLabel2 = new JLabel(Bundle.ProfilerControlPanel2_TypeLabelString());
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            JLabel jLabel3 = new JLabel(Bundle.ProfilerControlPanel2_ConfigLabelString());
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            this.onLabel = new JLabel(Bundle.ProfilerControlPanel2_OnLabelString());
            this.onLabel.setFont(this.onLabel.getFont().deriveFont(1));
            JLabel jLabel4 = new JLabel(Bundle.ProfilerControlPanel2_StatusLabelString());
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            this.modeValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.typeValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.profileValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.onValueLabel = new JLabel(Bundle.ProfilerControlPanel2_NoConfigurationString());
            this.statusValueLabel = new JLabel(Bundle.ProfilerControlPanel2_InactiveLabelString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)jLabel2, gridBagConstraints);
            this.add((Component)this.typeValueLabel, gridBagConstraints2);
            this.add((Component)jLabel3, gridBagConstraints);
            this.add((Component)this.profileValueLabel, gridBagConstraints2);
            this.add((Component)this.onLabel, gridBagConstraints);
            this.add((Component)this.onValueLabel, gridBagConstraints2);
            this.add((Component)jLabel4, gridBagConstraints);
            this.add((Component)this.statusValueLabel, gridBagConstraints2);
            this.onLabel.setVisible(false);
            this.onValueLabel.setVisible(false);
        }

        void refreshStatus() {
            ProfilingSettings profilingSettings;
            if (this.mode != Profiler.getDefault().getProfilingMode()) {
                this.mode = Profiler.getDefault().getProfilingMode();
                if (this.mode == 0) {
                    this.modeValueLabel.setText(Bundle.ProfilerControlPanel2_AttachLabelString());
                } else {
                    this.modeValueLabel.setText(Bundle.ProfilerControlPanel2_ProfileLabelString());
                }
            }
            if ((profilingSettings = Profiler.getDefault().getLastProfilingSettings()) != null && this.profilingType != profilingSettings.getProfilingType()) {
                switch (profilingSettings.getProfilingType()) {
                    case 32: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_CodeFragmentLabelString());
                        break;
                    }
                    case 64: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_CpuSamplingLabelString());
                        break;
                    }
                    case 8: 
                    case 16: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_CpuLabelString());
                        break;
                    }
                    case 128: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_MemorySamplingLabelString());
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_MemoryLabelString());
                        break;
                    }
                    case 1: {
                        this.typeValueLabel.setText(Bundle.ProfilerControlPanel2_MonitorLabelString());
                    }
                }
                this.profileValueLabel.setText(profilingSettings.getSettingsName());
            }
            int n = Profiler.getDefault().getProfilingState();
            String string = "";
            if (this.state != n) {
                this.state = n;
                switch (this.state) {
                    case 1: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_InactiveLabelString());
                        break;
                    }
                    case 2: {
                        TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
                        if (targetAppRunner != null) {
                            string = targetAppRunner.getProfilerEngineSettings().getRemoteHost();
                        }
                        if (this.host == null || !this.host.equals(string)) {
                            this.host = string;
                            if ("".equals(this.host)) {
                                this.onValueLabel.setText("");
                                this.onLabel.setVisible(false);
                                this.onValueLabel.setVisible(false);
                            } else {
                                this.onValueLabel.setText(this.host);
                                this.onLabel.setVisible(true);
                                this.onValueLabel.setVisible(true);
                            }
                        }
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_StartedLabelString());
                        this.count = 1;
                        break;
                    }
                    case 8: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_PausedLabelString());
                        break;
                    }
                    case 4: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_RunningLabelString());
                        break;
                    }
                    case 16: {
                        this.statusValueLabel.setText(Bundle.ProfilerControlPanel2_StoppedLabelString());
                    }
                }
            } else if (this.state == 2) {
                StringBuilder stringBuilder = new StringBuilder(Bundle.ProfilerControlPanel2_StartingLabelString());
                for (int i = 0; i < this.count; ++i) {
                    stringBuilder.append('.');
                }
                this.statusValueLabel.setText(stringBuilder.toString());
                ++this.count;
                if (this.count == 5) {
                    this.count = 0;
                }
            }
        }
    }

    private static final class SnapshotsPanel
    extends CPPanel
    implements ListSelectionListener,
    ActionListener,
    ChangeListener {
        private DefaultListModel listModel;
        private JButton deleteButton;
        private JButton exportButton;
        private JButton renameButton;
        private JButton openButton;
        private JComboBox combo;
        private JList list;
        private Lookup.Provider displayedProject;
        private boolean internalChange = false;
        private static final RequestProcessor updater = new RequestProcessor("Snapshots Updater");
        private static final Object updaterSync = new Object();
        private boolean updating = false;
        private boolean dirty = false;

        SnapshotsPanel() {
            Object object;
            JComponent jComponent;
            Object object2;
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.setLayout(new BorderLayout(6, 6));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY, Color.GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            LineBorder lineBorder = new LineBorder(Color.LIGHT_GRAY){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Color color = graphics.getColor();
                    graphics.setColor(this.lineColor);
                    graphics.drawLine(n, n2, n, n4 - 1);
                    graphics.setColor(color);
                }
            };
            this.combo = new JComboBox(new DefaultComboBoxModel()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = 1;
                    return dimension;
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.combo.setRenderer(new ProjectNameRenderer());
            this.combo.getAccessibleContext().setAccessibleName(Bundle.ProfilerControlPanel2_ComboAccessName());
            this.combo.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_ComboAccessDescr());
            ComboBoxUI comboBoxUI = this.combo.getUI();
            if (comboBoxUI instanceof BasicComboBoxUI) {
                object2 = (BasicComboBoxUI)comboBoxUI;
                jComponent = null;
                try {
                    object = BasicComboBoxUI.class.getDeclaredField("arrowButton");
                    ((Field)object).setAccessible(true);
                    jComponent = (JButton)((Field)object).get(object2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (jComponent != null) {
                    jComponent.setBackground(CP_BACKGROUND_COLOR);
                    jComponent.setBorder(BorderFactory.createCompoundBorder(lineBorder, BorderFactory.createEmptyBorder(0, ((AbstractButton)jComponent).getIconTextGap(), 0, ((AbstractButton)jComponent).getIconTextGap())));
                }
            }
            this.combo.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            this.combo.setBackground(CP_BACKGROUND_COLOR);
            this.combo.addActionListener(this);
            ProjectUtilities.addOpenProjectsListener((ChangeListener)this);
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.getAccessibleContext().setAccessibleName(Bundle.ProfilerControlPanel2_ListAccessName());
            this.list.setVisibleRowCount(8);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (bl && jList.isEnabled()) {
                        this.setForeground(jList.isFocusOwner() ? jList.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
                        this.setBackground(jList.isFocusOwner() ? jList.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
                    } else if (!jList.isEnabled()) {
                        this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                        this.setBackground(UIManager.getColor("TextField.inactiveBackground"));
                    } else {
                        this.setForeground(jList.getForeground());
                        this.setBackground(jList.getBackground());
                    }
                    if (object instanceof Snapshot) {
                        Snapshot snapshot = (Snapshot)object;
                        if (SnapshotsPanel.this.isOpen(snapshot)) {
                            jLabel.setFont(jLabel.getFont().deriveFont(1));
                        }
                        jLabel.setText(snapshot.getDisplayName());
                        jLabel.setIcon(snapshot.getIcon());
                    } else {
                        jLabel.setText(object.toString());
                    }
                    return jLabel;
                }
            });
            this.list.addListSelectionListener(this);
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        SnapshotsPanel.this.openSelectedSnapshots();
                    } else if (keyEvent.getKeyCode() == 127) {
                        final FileObject[] fileObjectArray = SnapshotsPanel.this.getSelectedSnapshotFiles();
                        if (fileObjectArray.length == 0) {
                            return;
                        }
                        if (ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotMsg(), (String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotCaption())) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    SnapshotsPanel.this.deleteSnapshots(fileObjectArray);
                                    SnapshotsPanel.this.refreshList();
                                }
                            });
                        }
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                        SnapshotsPanel.this.openSelectedSnapshots();
                    }
                }
            });
            this.add((Component)this.combo, "North");
            object2 = new JScrollPane(this.list, 20, 31);
            ((JComponent)object2).setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            ((JComponent)object2).setPreferredSize(new Dimension(1, ((JComponent)object2).getPreferredSize().height));
            this.add((Component)object2, "Center");
            this.openButton = new JButton(Bundle.ProfilerControlPanel2_OpenButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.openButton);
            this.openButton.setContentAreaFilled(false);
            this.openButton.setMargin(new Insets(3, 3, 3, 3));
            this.openButton.setRolloverEnabled(true);
            this.openButton.setBorder(compoundBorder);
            this.openButton.addActionListener(this);
            this.openButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_OpenButtonAccessDescr());
            this.renameButton = new JButton(Bundle.ProfilerControlPanel2_RenameButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.renameButton);
            this.renameButton.setContentAreaFilled(false);
            this.renameButton.setMargin(new Insets(3, 3, 3, 3));
            this.renameButton.setRolloverEnabled(true);
            this.renameButton.setBorder(compoundBorder);
            this.renameButton.addActionListener(this);
            this.renameButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_RenameButtonAccessDescr());
            this.deleteButton = new JButton(Bundle.ProfilerControlPanel2_DeleteButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.deleteButton);
            this.deleteButton.setContentAreaFilled(false);
            this.deleteButton.setMargin(new Insets(3, 3, 3, 3));
            this.deleteButton.setRolloverEnabled(true);
            this.deleteButton.setBorder(compoundBorder);
            this.deleteButton.addActionListener(this);
            this.deleteButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_DeleteButtonAccessDescr());
            this.exportButton = new JButton(Bundle.ProfilerControlPanel2_ExportButtonName());
            UIUtils.fixButtonUI((AbstractButton)this.exportButton);
            this.exportButton.setContentAreaFilled(false);
            this.exportButton.setMargin(new Insets(3, 3, 3, 3));
            this.exportButton.setRolloverEnabled(true);
            this.exportButton.setBorder(compoundBorder);
            this.exportButton.addActionListener(this);
            this.exportButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerControlPanel2_ExportButtonAccessDescr());
            jComponent = new JPanel();
            jComponent.setOpaque(false);
            jComponent.setLayout(new GridBagLayout());
            object = new GridBagConstraints();
            ((GridBagConstraints)object).fill = 2;
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).insets = new Insets(0, 0, 4, 0);
            ((GridBagConstraints)object).gridwidth = 0;
            jComponent.add((Component)this.openButton, object);
            jComponent.add((Component)this.renameButton, object);
            jComponent.add((Component)this.deleteButton, object);
            jComponent.add((Component)this.exportButton, object);
            ((GridBagConstraints)object).weighty = 1.0;
            ((GridBagConstraints)object).fill = 1;
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jComponent.add((Component)jPanel, object);
            this.add((Component)jComponent, "East");
            this.updateButtons();
            this.updateCombo();
            Lookup.Provider provider = NetBeansProfiler.getDefaultNB().getProfiledProject();
            if (provider == null) {
                provider = ProjectUtilities.getMainProject();
            }
            this.setDisplayedProject(provider);
        }

        private boolean isOpen(Snapshot snapshot) {
            File file = FileUtil.toFile((FileObject)snapshot.getFile());
            if (file == null) {
                return false;
            }
            if (snapshot.isHeapDump()) {
                Set set = WindowManager.getDefault().getRegistry().getOpened();
                for (TopComponent topComponent : set) {
                    if (!file.equals(topComponent.getClientProperty((Object)"nb.recent.file.path"))) continue;
                    return true;
                }
            } else {
                LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(file);
                if (loadedSnapshot != null) {
                    return true;
                }
            }
            return false;
        }

        public void setDisplayedProject(Lookup.Provider provider) {
            this.displayedProject = provider;
            this.list.clearSelection();
            this.refreshList();
            this.internalChange = true;
            if (provider == null) {
                this.combo.setSelectedItem(Bundle.ProfilerControlPanel2_GlobalComboItemString());
            } else {
                this.combo.setSelectedItem(provider);
            }
            this.internalChange = false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.openButton) {
                this.openSelectedSnapshots();
            } else if (actionEvent.getSource() == this.renameButton) {
                this.renameSelectedSnapshot();
            } else if (actionEvent.getSource() == this.deleteButton) {
                final FileObject[] fileObjectArray = this.getSelectedSnapshotFiles();
                if (ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotMsg(), (String)Bundle.ProfilerControlPanel2_ConfirmDeleteSnapshotCaption())) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotsPanel.this.deleteSnapshots(fileObjectArray);
                            SnapshotsPanel.this.refreshList();
                        }
                    });
                }
            } else if (actionEvent.getSource() == this.exportButton) {
                ResultsManager.getDefault().exportSnapshots(this.getSelectedSnapshotFiles());
            } else if (actionEvent.getSource() == this.combo && !this.internalChange) {
                Object object = this.combo.getSelectedItem();
                if (object instanceof Lookup.Provider) {
                    this.setDisplayedProject((Lookup.Provider)object);
                } else {
                    this.setDisplayedProject(null);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateCombo();
        }

        public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
            this.refreshList();
        }

        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
            SnapshotResultsWindow.closeWindow(loadedSnapshot);
            this.refreshList();
        }

        public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
            int n;
            if (SnapshotResultsWindow.hasSnapshotWindow(loadedSnapshot)) {
                SnapshotResultsWindow.get(loadedSnapshot).updateTitle();
            }
            this.refreshList();
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)loadedSnapshot.getFile()));
            if (fileObject != null && (n = this.listModel.indexOf(fileObject)) != -1) {
                this.list.ensureIndexIsVisible(n);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateButtons();
        }

        private FileObject[] getSelectedSnapshotFiles() {
            Object[] objectArray = this.list.getSelectedValues();
            FileObject[] fileObjectArray = new FileObject[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                fileObjectArray[i] = ((Snapshot)objectArray[i]).getFile();
            }
            return fileObjectArray;
        }

        private void deleteSnapshots(FileObject[] fileObjectArray) {
            boolean bl = true;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject = fileObjectArray[i];
                try {
                    DataObject.find((FileObject)fileObject).delete();
                    continue;
                }
                catch (Throwable throwable) {
                    bl = false;
                    throwable.printStackTrace();
                }
            }
            if (!bl) {
                ProfilerDialogs.displayError((String)Bundle.ProfilerControlPanel2_SnapshotsNotDeletedMsg());
            }
        }

        private LoadedSnapshot[] loadSelectedSnapshots() {
            FileObject[] fileObjectArray = this.getSelectedSnapshotFiles();
            return ResultsManager.getDefault().loadSnapshots(fileObjectArray);
        }

        private void openSelectedSnapshots() {
            FileObject[] fileObjectArray = this.getSelectedSnapshotFiles();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                final FileObject fileObject = fileObjectArray[i];
                String string = fileObject.getExt();
                SnapshotResultsWindow snapshotResultsWindow = null;
                if (string.equalsIgnoreCase("nps")) {
                    LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().loadSnapshot(fileObject);
                    if (loadedSnapshot != null) {
                        snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot);
                        snapshotResultsWindow.open();
                    }
                } else if (string.equalsIgnoreCase("hprof")) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ResultsManager.getDefault().openSnapshot(fileObject);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    });
                }
                if (snapshotResultsWindow == null) continue;
                snapshotResultsWindow.requestActive();
            }
        }

        private void renameSelectedSnapshot() {
            FileObject[] fileObjectArray = this.getSelectedSnapshotFiles();
            if (fileObjectArray.length == 1) {
                final FileObject fileObject = fileObjectArray[0];
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String string;
                        String string2 = fileObject.getName();
                        RenameSnapshotPanel renameSnapshotPanel = new RenameSnapshotPanel();
                        renameSnapshotPanel.setSnapshotName(string2);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)renameSnapshotPanel, Bundle.ProfilerControlPanel2_RenameSnapshotCaption(), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, RENAME_SNAPSHOT_HELP_CTX, null);
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                        dialog.setVisible(true);
                        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && !string2.equals(string = renameSnapshotPanel.getSnapshotName())) {
                            if (string.length() == 0) {
                                ProfilerDialogs.displayError((String)Bundle.ProfilerControlPanel2_EmptyNameMsg());
                                SnapshotsPanel.this.renameSelectedSnapshot();
                            } else {
                                FileLock fileLock = null;
                                try {
                                    fileLock = fileObject.lock();
                                    LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
                                    fileObject.rename(fileLock, string, fileObject.getExt());
                                    if (loadedSnapshot != null) {
                                        loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
                                    }
                                    ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                                }
                                catch (IOException iOException) {
                                    ProfilerLogger.warning((String)("Failed to rename snapshot " + fileObject + " to " + string + ": " + iOException.getMessage()));
                                    ProfilerDialogs.displayError((String)Bundle.ProfilerControlPanel2_RenameSnapshotFailedMsg(string));
                                    SnapshotsPanel.this.renameSelectedSnapshot();
                                }
                                finally {
                                    if (fileLock != null) {
                                        fileLock.releaseLock();
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshList() {
            Object object = updaterSync;
            synchronized (object) {
                if (this.updating) {
                    this.dirty = true;
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final List<Object> list = Arrays.asList(SnapshotsPanel.this.list.getSelectedValues());
                    updater.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            final ArrayList<Snapshot> arrayList = updaterSync;
                            synchronized (arrayList) {
                                SnapshotsPanel.this.dirty = false;
                                SnapshotsPanel.this.updating = true;
                            }
                            arrayList = new ArrayList<Snapshot>();
                            try {
                                for (FileObject fileObject : ResultsManager.getDefault().listSavedSnapshots(SnapshotsPanel.this.displayedProject, null)) {
                                    arrayList.add(new Snapshot(fileObject));
                                }
                                for (FileObject fileObject : ResultsManager.getDefault().listSavedHeapdumps(SnapshotsPanel.this.displayedProject, null)) {
                                    arrayList.add(new Snapshot(fileObject));
                                }
                            }
                            catch (Throwable throwable) {
                                LOGGER.log(Level.WARNING, null, throwable);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object;
                                    int n;
                                    SnapshotsPanel.this.listModel.clear();
                                    for (n = 0; n < arrayList.size(); ++n) {
                                        object = (Snapshot)arrayList.get(n);
                                        SnapshotsPanel.this.listModel.addElement(object);
                                        if (!list.contains(object)) continue;
                                        SnapshotsPanel.this.list.addSelectionInterval(n, n);
                                    }
                                    n = 0;
                                    object = updaterSync;
                                    synchronized (object) {
                                        SnapshotsPanel.this.updating = false;
                                        if (SnapshotsPanel.this.dirty) {
                                            n = 1;
                                        }
                                    }
                                    if (n != 0) {
                                        SnapshotsPanel.this.refreshList();
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        private void updateButtons() {
            int[] nArray = this.list.getSelectedIndices();
            this.openButton.setEnabled(nArray.length > 0);
            this.deleteButton.setEnabled(nArray.length > 0);
            this.exportButton.setEnabled(nArray.length > 0);
            if (nArray.length != 1) {
                this.renameButton.setEnabled(false);
            } else {
                Object e = this.list.getModel().getElementAt(nArray[0]);
                if (!(e instanceof Snapshot)) {
                    this.renameButton.setEnabled(false);
                } else {
                    this.renameButton.setEnabled(!this.isOpen((Snapshot)e));
                }
            }
        }

        private void updateCombo() {
            Lookup.Provider[] providerArray = ProjectUtilities.getSortedProjects((Lookup.Provider[])ProjectUtilities.getOpenedProjects());
            ArrayList<Object> arrayList = new ArrayList<Object>(providerArray.length + 1);
            arrayList.addAll(Arrays.asList(providerArray));
            arrayList.add(0, Bundle.ProfilerControlPanel2_GlobalComboItemString());
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.combo.getModel();
            defaultComboBoxModel.removeAllElements();
            for (Object e : arrayList) {
                defaultComboBoxModel.addElement(e);
            }
            if (this.displayedProject != null && defaultComboBoxModel.getIndexOf(this.displayedProject) != -1) {
                this.internalChange = true;
                this.combo.setSelectedItem(this.displayedProject);
                this.internalChange = false;
            } else {
                Lookup.Provider provider = ProjectUtilities.getMainProject();
                this.setDisplayedProject(provider);
            }
        }

        private static class Snapshot {
            private FileObject fo;
            private String displayName;
            private Icon icon;
            private boolean isHeapDump;

            Snapshot(FileObject fileObject) {
                this.fo = fileObject;
                this.loadDetails();
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public Icon getIcon() {
                return this.icon;
            }

            public FileObject getFile() {
                return this.fo;
            }

            public boolean isHeapDump() {
                return this.isHeapDump;
            }

            private void loadDetails() {
                if (this.fo.getExt().equalsIgnoreCase("hprof")) {
                    this.icon = heapDumpIcon;
                    this.displayName = ResultsManager.getDefault().getHeapDumpDisplayName(this.fo.getName());
                    this.isHeapDump = true;
                } else {
                    int n = ResultsManager.getDefault().getSnapshotType(this.fo);
                    this.displayName = ResultsManager.getDefault().getSnapshotDisplayName(this.fo.getName(), n);
                    this.icon = Snapshot.getIcon(n);
                    this.isHeapDump = false;
                }
            }

            private static Icon getIcon(int n) {
                switch (n) {
                    case 1: {
                        return cpuIcon;
                    }
                    case 2: {
                        return fragmentIcon;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        return memoryIcon;
                    }
                }
                return null;
            }

            public boolean equals(Object object) {
                return this.fo.equals(((Snapshot)object).fo);
            }

            public int hashCode() {
                return this.fo.hashCode();
            }
        }
    }

    private static final class ResultsSnippetPanel
    extends CPPanel
    implements ActionListener {
        private static final int CPU = 1;
        private static final int MEMORY = 2;
        private static final int FRAGMENT = 3;
        private static final Icon TAKE_SNAPSHOT_CPU_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotCpu32");
        private static final Icon TAKE_SNAPSHOT_MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotMemory32");
        private static final Icon TAKE_SNAPSHOT_FRAGMENT_ICON = Icons.getIcon((String)"ProfilerIcons.TakeSnapshotFragment32");
        private static final Icon TAKE_HEAP_DUMP_ICON = Icons.getIcon((String)"ProfilerIcons.TakeHeapDump32");
        private static final Icon LIVE_RESULTS_CPU_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsCpu32");
        private static final Icon LIVE_RESULTS_MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsMemory32");
        private static final Icon LIVE_RESULTS_FRAGMENT_ICON = Icons.getIcon((String)"ProfilerIcons.ViewLiveResultsFragment32");
        private final JButton takeCPUSnapshotButton;
        private final JButton takeFragmentSnapshotButton;
        private final JButton takeMemorySnapshotButton;
        private final JButton takeHeapDumpButton;
        private final JPanel centerPanel;
        private JButton liveResultsButton;
        private LoadedSnapshot lastSnapshot;
        private int displayedIcon = 1;

        ResultsSnippetPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(7, 5, 8, 0));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            this.takeCPUSnapshotButton = new JButton(Bundle.ProfilerControlPanel2_TakeSnapshotButtonName(), TAKE_SNAPSHOT_CPU_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeCPUSnapshotButton);
            this.takeCPUSnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeCPUSnapshotButton.getIcon()).getImage()))));
            this.takeCPUSnapshotButton.addActionListener(this);
            this.takeCPUSnapshotButton.setContentAreaFilled(false);
            this.takeCPUSnapshotButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeCPUSnapshotButton.setVerticalTextPosition(3);
            this.takeCPUSnapshotButton.setHorizontalTextPosition(0);
            this.takeCPUSnapshotButton.setRolloverEnabled(true);
            this.takeCPUSnapshotButton.setBorder(compoundBorder);
            this.takeCPUSnapshotButton.setToolTipText(Bundle.ProfilerControlPanel2_TakeSnapshotButtonToolTip());
            this.takeMemorySnapshotButton = new JButton(Bundle.ProfilerControlPanel2_TakeSnapshotButtonName(), TAKE_SNAPSHOT_MEMORY_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeMemorySnapshotButton);
            this.takeMemorySnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeMemorySnapshotButton.getIcon()).getImage()))));
            this.takeMemorySnapshotButton.addActionListener(this);
            this.takeMemorySnapshotButton.setContentAreaFilled(false);
            this.takeMemorySnapshotButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeMemorySnapshotButton.setVerticalTextPosition(3);
            this.takeMemorySnapshotButton.setHorizontalTextPosition(0);
            this.takeMemorySnapshotButton.setRolloverEnabled(true);
            this.takeMemorySnapshotButton.setBorder(compoundBorder);
            this.takeMemorySnapshotButton.setToolTipText(Bundle.ProfilerControlPanel2_TakeSnapshotButtonToolTip());
            this.takeHeapDumpButton = new JButton((Action)((Object)HeapDumpAction.getInstance()));
            this.takeHeapDumpButton.setText(Bundle.ProfilerControlPanel2_DumpHeapButtonName());
            this.takeHeapDumpButton.setIcon(TAKE_HEAP_DUMP_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeHeapDumpButton);
            this.takeHeapDumpButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeHeapDumpButton.getIcon()).getImage()))));
            this.takeHeapDumpButton.addActionListener(this);
            this.takeHeapDumpButton.setContentAreaFilled(false);
            this.takeHeapDumpButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeHeapDumpButton.setVerticalTextPosition(3);
            this.takeHeapDumpButton.setHorizontalTextPosition(0);
            this.takeHeapDumpButton.setRolloverEnabled(true);
            this.takeHeapDumpButton.setBorder(compoundBorder);
            this.takeFragmentSnapshotButton = new JButton(Bundle.ProfilerControlPanel2_TakeSnapshotButtonName(), TAKE_SNAPSHOT_FRAGMENT_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.takeFragmentSnapshotButton);
            this.takeFragmentSnapshotButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.takeFragmentSnapshotButton.getIcon()).getImage()))));
            this.takeFragmentSnapshotButton.addActionListener(this);
            this.takeFragmentSnapshotButton.setContentAreaFilled(false);
            this.takeFragmentSnapshotButton.setMargin(new Insets(1, 2, 1, 2));
            this.takeFragmentSnapshotButton.setVerticalTextPosition(3);
            this.takeFragmentSnapshotButton.setHorizontalTextPosition(0);
            this.takeFragmentSnapshotButton.setRolloverEnabled(true);
            this.takeFragmentSnapshotButton.setBorder(compoundBorder);
            this.takeFragmentSnapshotButton.setToolTipText(Bundle.ProfilerControlPanel2_TakeSnapshotButtonToolTip());
            this.liveResultsButton = new JButton(Bundle.ProfilerControlPanel2_LiveResultsButtonName(), LIVE_RESULTS_CPU_ICON);
            UIUtils.fixButtonUI((AbstractButton)this.liveResultsButton);
            this.liveResultsButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.liveResultsButton.getIcon()).getImage()))));
            this.liveResultsButton.addActionListener(this);
            this.liveResultsButton.setContentAreaFilled(false);
            this.liveResultsButton.setMargin(new Insets(1, 2, 1, 2));
            this.liveResultsButton.setVerticalTextPosition(3);
            this.liveResultsButton.setHorizontalTextPosition(0);
            this.liveResultsButton.setRolloverEnabled(true);
            this.liveResultsButton.setBorder(compoundBorder);
            this.liveResultsButton.setToolTipText(Bundle.ProfilerControlPanel2_LiveResultsButtonToolTip());
            this.displayedIcon = 1;
            this.centerPanel = new JPanel();
            this.centerPanel.setOpaque(false);
            this.centerPanel.setLayout(new FlowLayout(0, 0, 0));
            this.centerPanel.add(this.takeCPUSnapshotButton);
            this.centerPanel.add(this.takeHeapDumpButton);
            this.centerPanel.add(this.liveResultsButton);
            this.add((Component)this.centerPanel, "Center");
            this.refreshStatus();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.takeCPUSnapshotButton || actionEvent.getSource() == this.takeFragmentSnapshotButton) {
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ResultsManager.getDefault().takeSnapshot();
                    }
                });
            } else if (actionEvent.getSource() == this.takeMemorySnapshotButton) {
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ResultsManager.getDefault().takeSnapshot();
                    }
                });
            } else if (actionEvent.getSource() == this.liveResultsButton) {
                LiveResultsWindow.getDefault().open();
                LiveResultsWindow.getDefault().requestActive();
                LiveResultsWindow.getDefault().refreshLiveResults();
            }
        }

        public void refreshStatus() {
            int n;
            this.updateResultsButtons();
            int n2 = Profiler.getDefault().getProfilingState();
            int n3 = n2 != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
            switch (n3) {
                case 1: {
                    n = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            if (this.displayedIcon != n) {
                this.displayedIcon = n;
                this.centerPanel.remove(this.centerPanel.getComponent(0));
                if (n == 1) {
                    this.centerPanel.add((Component)this.takeCPUSnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_CPU_ICON);
                } else if (n == 2) {
                    this.centerPanel.add((Component)this.takeMemorySnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_MEMORY_ICON);
                } else {
                    this.centerPanel.add((Component)this.takeFragmentSnapshotButton, 0);
                    this.liveResultsButton.setIcon(LIVE_RESULTS_FRAGMENT_ICON);
                }
                this.liveResultsButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.liveResultsButton.getIcon()).getImage()))));
            }
        }

        public void resultsAvailable() {
            this.updateResultsButtons();
        }

        public void resultsReset() {
            this.updateResultsButtons();
        }

        private void updateResultsButtons() {
            int n = Profiler.getDefault().getProfilingState();
            int n2 = n != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
            boolean bl = n == 8 || n == 4;
            bl = bl && n2 != 0;
            this.liveResultsButton.setEnabled(bl);
            boolean bl2 = ResultsManager.getDefault().resultsAvailable();
            this.takeCPUSnapshotButton.setEnabled(bl && bl2);
            this.takeMemorySnapshotButton.setEnabled(bl && bl2);
            this.takeFragmentSnapshotButton.setEnabled(bl && bl2);
        }

        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
            if (this.lastSnapshot == loadedSnapshot) {
                this.lastSnapshot = null;
            }
        }

        public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
            this.lastSnapshot = loadedSnapshot;
            if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                int n = LiveResultsWindow.hasDefault() ? LiveResultsWindow.getDefault().getSortingColumn() : -1;
                boolean bl = LiveResultsWindow.hasDefault() ? LiveResultsWindow.getDefault().getSortingOrder() : false;
                ResultsManager.getDefault().openSnapshot(loadedSnapshot, n, bl);
            }
            if (ProfilerIDESettings.getInstance().getAutoSaveSnapshot()) {
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot);
                if (!ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                    ResultsManager.getDefault().closeSnapshot(loadedSnapshot);
                }
            }
        }
    }

    private static final class ProjectNameRenderer
    extends DefaultListCellRenderer {
        private Renderer renderer = new Renderer();
        private boolean firstFontSet = false;

        private ProjectNameRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.renderer.setComponentOrientation(jLabel.getComponentOrientation());
            this.renderer.setFontEx(jLabel.getFont());
            this.renderer.setOpaque(jLabel.isOpaque());
            this.renderer.setForeground(jLabel.getForeground());
            this.renderer.setBackground(jLabel.getBackground());
            this.renderer.setEnabled(jLabel.isEnabled());
            this.renderer.setBorder(jLabel.getBorder());
            if (object != null && object instanceof Lookup.Provider) {
                Lookup.Provider provider = (Lookup.Provider)object;
                this.renderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)provider));
                this.renderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)provider));
                if (ProjectUtilities.getMainProject() == object) {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(1));
                } else {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(0));
                }
            } else {
                this.renderer.setText(jLabel.getText());
                this.renderer.setIcon(emptyIcon);
            }
            return this.renderer;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    private static final class ControlsPanel
    extends CPPanel {
        ControlsPanel() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            CompoundBorder compoundBorder = new CompoundBorder((Border)new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), (Border)new FlatToolBar.FlatMarginBorder());
            JButton jButton = new JButton((Action)SystemAction.get(RerunAction.class));
            jButton.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton);
            jButton.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton.getIcon()).getImage()))));
            jButton.setContentAreaFilled(false);
            jButton.setMargin(new Insets(3, 3, 3, 3));
            jButton.setRolloverEnabled(true);
            jButton.setBorder(compoundBorder);
            this.add(jButton);
            JButton jButton2 = new JButton((Action)((Object)StopAction.getInstance())){

                @Override
                public void setText(String string) {
                }

                @Override
                public void setIcon(Icon icon) {
                    super.setIcon(icon);
                    this.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)this.getIcon()).getImage()))));
                }
            };
            UIUtils.fixButtonUI((AbstractButton)jButton2);
            jButton2.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton2.getIcon()).getImage()))));
            jButton2.setContentAreaFilled(false);
            jButton2.setMargin(new Insets(3, 3, 3, 3));
            jButton2.setRolloverEnabled(true);
            jButton2.setBorder(compoundBorder);
            this.add(jButton2);
            JButton jButton3 = new JButton((Action)((Object)ResetResultsAction.getInstance()));
            jButton3.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton3);
            jButton3.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton3.getIcon()).getImage()))));
            jButton3.setContentAreaFilled(false);
            jButton3.setMargin(new Insets(3, 3, 3, 3));
            jButton3.setRolloverEnabled(true);
            jButton3.setBorder(compoundBorder);
            this.add(jButton3);
            JButton jButton4 = new JButton((Action)((Object)RunGCAction.getInstance()));
            jButton4.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton4);
            jButton4.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton4.getIcon()).getImage()))));
            jButton4.setContentAreaFilled(false);
            jButton4.setMargin(new Insets(3, 3, 3, 3));
            jButton4.setRolloverEnabled(true);
            jButton4.setBorder(compoundBorder);
            this.add(jButton4);
            JButton jButton5 = new JButton((Action)((Object)ModifyProfilingAction.getInstance()));
            jButton5.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton5);
            jButton5.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton5.getIcon()).getImage()))));
            jButton5.setContentAreaFilled(false);
            jButton5.setMargin(new Insets(3, 3, 3, 3));
            jButton5.setRolloverEnabled(true);
            jButton5.setBorder(compoundBorder);
            this.add(jButton5);
            JButton jButton6 = new JButton(TelemetryOverviewAction.getInstance());
            jButton6.setText(null);
            UIUtils.fixButtonUI((AbstractButton)jButton6);
            jButton6.setDisabledIcon(new IconUIResource(new ImageIcon(WhiteFilter.createDisabledImage(((ImageIcon)jButton6.getIcon()).getImage()))));
            jButton6.setContentAreaFilled(false);
            jButton6.setMargin(new Insets(3, 3, 3, 3));
            jButton6.setRolloverEnabled(true);
            jButton6.setBorder(compoundBorder);
            this.add(jButton6);
        }
    }

    private static class CPPanel
    extends JPanel {
        CPPanel() {
            this.setOpaque(true);
            this.setBackground(CP_BACKGROUND_COLOR);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
    }

    private static final class BasicTelemetryPanel
    extends CPPanel {
        private final JLabel instrFilterValueLabel;
        private final JLabel instrValueLabel;
        private final JLabel relTimeValueLabel;
        private final JLabel threadsValueLabel;
        private final JLabel totalMemValueLabel;
        private final JLabel typeValueLabel;
        private final JLabel usedMemValueLabel;
        private final NumberFormat intFormat;
        private final NumberFormat percentFormat = NumberFormat.getPercentInstance();
        private String savedInstrFilterText = "";
        private String savedInstrText = "";
        private boolean inactive = true;

        BasicTelemetryPanel() {
            this.percentFormat.setMinimumFractionDigits(1);
            this.percentFormat.setMaximumIntegerDigits(2);
            this.intFormat = NumberFormat.getIntegerInstance();
            this.intFormat.setGroupingUsed(true);
            this.setBorder(BorderFactory.createEmptyBorder(8, 3, 9, 3));
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(Bundle.ProfilerControlPanel2_InstrumentedLabelString());
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            JLabel jLabel2 = new JLabel(Bundle.ProfilerControlPanel2_FilterLabelString());
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            JLabel jLabel3 = new JLabel(Bundle.ProfilerControlPanel2_ThreadsLabelString());
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            JLabel jLabel4 = new JLabel(Bundle.ProfilerControlPanel2_TypeLabelString());
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            JLabel jLabel5 = new JLabel(Bundle.ProfilerControlPanel2_TotalMemoryLabelString());
            jLabel5.setFont(jLabel5.getFont().deriveFont(1));
            JLabel jLabel6 = new JLabel(Bundle.ProfilerControlPanel2_UsedMemoryLabelString());
            jLabel6.setFont(jLabel6.getFont().deriveFont(1));
            JLabel jLabel7 = new JLabel(Bundle.ProfilerControlPanel2_GcTimeLabelString());
            jLabel7.setFont(jLabel7.getFont().deriveFont(1));
            this.instrValueLabel = new JLabel(this.savedInstrText);
            this.instrFilterValueLabel = new JLabel("");
            this.threadsValueLabel = new JLabel("");
            this.typeValueLabel = new JLabel("");
            this.totalMemValueLabel = new JLabel("");
            this.usedMemValueLabel = new JLabel("");
            this.relTimeValueLabel = new JLabel("");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)jLabel, gridBagConstraints);
            this.add((Component)this.instrValueLabel, gridBagConstraints2);
            this.add((Component)jLabel2, gridBagConstraints);
            this.add((Component)this.instrFilterValueLabel, gridBagConstraints2);
            this.add((Component)jLabel3, gridBagConstraints);
            this.add((Component)this.threadsValueLabel, gridBagConstraints2);
            this.add((Component)jLabel5, gridBagConstraints);
            this.add((Component)this.totalMemValueLabel, gridBagConstraints2);
            this.add((Component)jLabel6, gridBagConstraints);
            this.add((Component)this.usedMemValueLabel, gridBagConstraints2);
            this.add((Component)jLabel7, gridBagConstraints);
            this.add((Component)this.relTimeValueLabel, gridBagConstraints2);
        }

        void refreshStatus() {
            Object object;
            int n = Profiler.getDefault().getProfilingState();
            String string = "";
            if (n == 4) {
                object = Profiler.getDefault().getTargetAppRunner().getProfilingSessionStatus();
                int n2 = object.currentInstrType;
                switch (n2) {
                    case 1: {
                        string = Bundle.ProfilerControlPanel2_NoLinesCodeRegionMsg(object.instrEndLine - object.instrStartLine);
                        break;
                    }
                    case 3: 
                    case 4: {
                        int n3 = object.getNInstrMethods();
                        if (n3 > 0) {
                            --n3;
                        }
                        string = Bundle.ProfilerControlPanel2_NoMethodsMsg(n3);
                        break;
                    }
                    case 5: 
                    case 6: {
                        int n4 = object.getNInstrClasses();
                        string = Bundle.ProfilerControlPanel2_NoClassesMsg(n4);
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 7: {
                        string = Bundle.ProfilerControlPanel2_NothingInstrumentedMsg();
                    }
                }
            }
            if (this.savedInstrText == null || !this.savedInstrText.equals(string)) {
                this.savedInstrText = string;
                this.instrValueLabel.setText(this.savedInstrText);
            }
            object = "";
            switch (n) {
                case 4: {
                    this.inactive = false;
                    MonitoredData monitoredData = Profiler.getDefault().getVMTelemetryManager().getLastData();
                    if (monitoredData != null) {
                        this.threadsValueLabel.setText("" + this.intFormat.format(monitoredData.getNUserThreads() + monitoredData.getNSystemThreads()));
                        this.totalMemValueLabel.setText("" + this.intFormat.format(monitoredData.getTotalMemory()) + " B");
                        this.usedMemValueLabel.setText("" + this.intFormat.format(monitoredData.getTotalMemory() - monitoredData.getFreeMemory()) + " B");
                        this.relTimeValueLabel.setText("" + this.percentFormat.format((float)monitoredData.getRelativeGCTimeInPerMil() / 1000.0f));
                        this.typeValueLabel.setText("");
                        object = Profiler.getDefault().getLastProfilingSettings().getSelectedInstrumentationFilter().toString();
                        break;
                    }
                    this.threadsValueLabel.setText("");
                    this.totalMemValueLabel.setText("");
                    this.usedMemValueLabel.setText("");
                    this.relTimeValueLabel.setText("");
                    this.typeValueLabel.setText("");
                    break;
                }
                default: {
                    if (this.inactive) {
                        return;
                    }
                    this.inactive = true;
                    this.threadsValueLabel.setText("");
                    this.totalMemValueLabel.setText("");
                    this.usedMemValueLabel.setText("");
                    this.relTimeValueLabel.setText("");
                    this.typeValueLabel.setText("");
                }
            }
            if (this.savedInstrFilterText == null || !this.savedInstrFilterText.equals(object)) {
                this.savedInstrFilterText = object;
                this.instrFilterValueLabel.setText(this.savedInstrFilterText);
            }
        }
    }

    public static final class WhiteFilter
    extends RGBImageFilter {
        private final float[] hsv = new float[3];

        public WhiteFilter() {
            this.canFilterIndexColorModel = true;
        }

        public static Image createDisabledImage(Image image) {
            WhiteFilter whiteFilter = new WhiteFilter();
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), whiteFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 24 & 0xFF;
            if (n4 <= 1) {
                return n3;
            }
            Color.RGBtoHSB(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 >> 0 & 0xFF, this.hsv);
            this.hsv[1] = 0.0f;
            return Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]) + ((n4 /= 2) << 24);
        }
    }

    public static final class VerticalLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = container.getWidth() - insets.left - insets.right;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!component.isVisible()) continue;
                int n4 = component.getPreferredSize().height;
                if (i == componentArray.length - 1 && n2 + n4 < container.getHeight() - insets.bottom) {
                    n4 = container.getHeight() - insets.bottom - n2;
                }
                component.setBounds(n, n2, n3, n4);
                n2 += n4;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension(container.getInsets().left + container.getInsets().right, container.getInsets().top + container.getInsets().bottom);
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getMinimumSize();
                n = Math.max(n, dimension2.width);
                n2 += dimension2.height;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(container.getInsets().left + container.getInsets().right, container.getInsets().top + container.getInsets().bottom);
            int n = 0;
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                n = Math.max(n, dimension2.width);
                n2 += dimension2.height;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    public static final class Listener
    extends Delegate<ProfilerControlPanel2>
    implements SnapshotsListener,
    ResultsListener {
        @Override
        public void resultsAvailable() {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.resultsAvailable();
            }
        }

        @Override
        public void resultsReset() {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.resultsReset();
            }
        }

        @Override
        public void snapshotLoaded(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotLoaded(loadedSnapshot);
            }
        }

        @Override
        public void snapshotRemoved(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.snapshotRemoved(loadedSnapshot);
            }
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotRemoved(loadedSnapshot);
            }
        }

        @Override
        public void snapshotSaved(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).snapshotsSnippet.snapshotSaved(loadedSnapshot);
            }
        }

        @Override
        public void snapshotTaken(LoadedSnapshot loadedSnapshot) {
            if (this.getDelegate() != null) {
                ((ProfilerControlPanel2)((Object)this.getDelegate())).resultsSnippet.snapshotTaken(loadedSnapshot);
            }
        }
    }
}

