#ifndef _EFL_GFX_MAP_EO_LEGACY_H_
#define _EFL_GFX_MAP_EO_LEGACY_H_

#ifndef _EFL_GFX_MAP_EO_CLASS_TYPE
#define _EFL_GFX_MAP_EO_CLASS_TYPE

typedef Eo Efl_Gfx_Map;

#endif

#ifndef _EFL_GFX_MAP_EO_TYPES
#define _EFL_GFX_MAP_EO_TYPES


#endif
/**
 * @brief Texture UV mapping for all objects (rotation, perspective, 3d, ...).
 *
 * Evas allows different transformations to be applied to all kinds of objects.
 * These are applied by means of UV mapping.
 *
 * With UV mapping, one maps points in the source object to a 3D space
 * positioning at target. This allows rotation, perspective, scale and lots of
 * other effects, depending on the map that is used.
 *
 * Each map point may carry a multiplier color. If properly calculated, these
 * can do shading effects on the object, producing 3D effects.
 *
 * At the moment of writing, maps can only have 4 points (no more, no less).
 * Usually, it will be necessary to update the map points (start afresh with
 * @ref Efl.Gfx.Map.map_populate) whenever the object geometry changes.
 *
 * @note For now this mixin is only compatible with @c Efl.Canvas.Object and
 * shouldn't be used anywhere else.
 *
 * @note There are a few differences with legacy @c Evas_Map: - A map is now a
 * property of an object, rather than a separate entity. -
 * @ref Efl.Gfx.Map.map_move_sync is enabled by default -
 * @ref Efl.Gfx.Map.map_populate will be called automatically if another map
 * function is called while the object has no map info.
 *
 * @ingroup Efl_Gfx_Map
 */

/**
 * @brief Whether map transformation is enabled on this object.
 *
 * The default map enable state is off ($false). The other properties and
 * methods in this class have no effect until this property is enabled.
 *
 * @return Enabled state.
 *
 * @ingroup Efl_Gfx_Map
 */
EAPI Eina_Bool evas_object_map_enable_get(const Efl_Gfx_Map *obj);

#endif
