/*
 * Decompiled with CFR 0.152.
 */
package gnu.activation.viewers;

import java.awt.Dimension;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class TextEditor
extends TextArea
implements CommandObject,
ActionListener {
    private transient DataHandler dh;

    public TextEditor() {
        super("", 24, 80, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize(24, 80);
    }

    @Override
    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        this.dh = dh;
        InputStream in = dh.getInputStream();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int len = in.read(buf);
        while (len != -1) {
            bytes.write(buf, 0, len);
            len = in.read(buf);
        }
        in.close();
        this.setText(bytes.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if ("save".equals(event.getActionCommand()) && this.dh != null) {
            OutputStream out = null;
            try {
                out = this.dh.getOutputStream();
                if (out != null) {
                    out.write(this.getText().getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
    }
}

