/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.converter.xml.xslt.PluginFactoryImpl;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.registry.ConverterInfo;

public final class DocumentDeserializerImpl
implements DocumentDeserializer,
URIResolver {
    private final ConvertData cd;
    private final PluginFactoryImpl pluginFactory;

    public DocumentDeserializerImpl(PluginFactoryImpl pf, ConvertData cd) {
        this.cd = cd;
        this.pluginFactory = pf;
    }

    public Document deserialize() throws ConvertException, IOException {
        this.log("\nFound the XSLT deserializer");
        Iterator<Object> enumerate = this.cd.getDocumentEnumeration();
        org.w3c.dom.Document domDoc = null;
        DOMDocument docOut = null;
        ByteArrayOutputStream baos = null;
        GenericOfficeDocument sxwDoc = new GenericOfficeDocument("output");
        while (enumerate.hasNext()) {
            docOut = (DOMDocument)enumerate.next();
        }
        if (docOut != null) {
            try {
                domDoc = docOut.getContentDOM();
                baos = this.transform(domDoc);
                sxwDoc.initContentDOM();
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                sxwDoc.setContentDOM(dBuilder.parse(new ByteArrayInputStream(baos.toByteArray())));
            }
            catch (Exception e) {
                System.out.println("The following error occurred:" + e);
            }
        }
        return sxwDoc;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (href != null) {
            if (href.equals("javax.xml.transform.dom.DOMSource") || href.length() == 0) {
                return null;
            }
            try {
                ConverterInfo ci = this.pluginFactory.getConverterInfo();
                String newhRef = "jar:" + ci.getJarName() + "!/" + href;
                StreamSource sheetFile = new StreamSource(newhRef);
                return sheetFile;
            }
            catch (Exception e) {
                System.out.println("\nException in Xslt Resolver " + e);
                return null;
            }
        }
        return null;
    }

    private ByteArrayOutputStream transform(org.w3c.dom.Document xmlDoc) {
        this.log("\nTransforming...");
        ConverterInfo ci = this.pluginFactory.getConverterInfo();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            String teststr = ci.getXsltDeserial();
            teststr = teststr.substring(0, 6);
            org.w3c.dom.Document xslDoc = null;
            if (teststr.equals("http:/") || teststr.equals("file:/") || teststr.equals("jar://")) {
                this.log(ci.getXsltDeserial());
                xslDoc = dBuilder.parse(ci.getXsltDeserial());
            } else {
                this.log(ci.getJarName() + "!/" + ci.getXsltDeserial());
                xslDoc = dBuilder.parse("jar:" + ci.getJarName() + "!/" + ci.getXsltDeserial());
            }
            DOMSource xslDomSource = new DOMSource(xslDoc);
            DOMSource xmlDomSource = new DOMSource(xmlDoc);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setURIResolver(this);
            Transformer transformer = tFactory.newTransformer(xslDomSource);
            transformer.transform(xmlDomSource, new StreamResult(baos));
            this.log("\n** Transform Complete ***");
        }
        catch (StackOverflowError sOE) {
            System.out.println("\nERROR : Stack Overflow Error During Transformation\n Try increasing the stack size by passing the -Xss1m option to the JRE.");
            throw sOE;
        }
        catch (Exception e) {
            System.out.println("An error occurred in the transformation : " + e);
        }
        return baos;
    }

    private void log(String str) {
        Debug.log(4, str);
    }
}

