/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class Section
extends Element {
    private static final Node[] EMPTY_ARRAY = new Node[0];
    private static final FlowControlOperation[] EMPTY_FLOWCONTROL = new FlowControlOperation[0];
    private ArrayList allElements;
    private transient Node[] allElementsCached;
    private ArrayList operationsBefore;
    private ArrayList operationsAfter;
    private transient FlowControlOperation[] operationsBeforeCached;
    private transient FlowControlOperation[] operationsAfterCached;
    private boolean repeat;

    public Section() {
        this.setType("section");
        this.allElements = new ArrayList();
    }

    public void addNode(Node node) {
        this.addNode(this.allElements.size(), node);
    }

    public void addNode(int n, Node node) {
        Node node2;
        if (n < 0) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (n > this.allElements.size()) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (node == null) {
            throw new NullPointerException("Band.addElement(...): element is null.");
        }
        if (node instanceof Section) {
            for (node2 = this; node2 != null; node2 = node2.getParent()) {
                if (node2 != node) continue;
                throw new IllegalArgumentException("adding container's parent to itself");
            }
        }
        if ((node2 = node.getParent()) != null) {
            if (node2 == this) {
                return;
            }
            if (node2 instanceof Section) {
                Section section = (Section)node2;
                section.removeNode(node);
            } else {
                node.setParent(null);
            }
        }
        this.allElements.add(n, node);
        this.allElementsCached = null;
        node.setParent(this);
    }

    public void addNodes(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("Band.addElements(...): collection is null.");
        }
        for (Element element : collection) {
            this.addNode(element);
        }
    }

    public Element getElementByName(String string) {
        if (string == null) {
            throw new NullPointerException("Band.getElement(...): name is null.");
        }
        for (Node node : this.getNodeArray()) {
            Element element;
            String string2;
            if (!(node instanceof Element) || (string2 = (element = (Element)node).getName()) == null || !string2.equals(string)) continue;
            return element;
        }
        return null;
    }

    public void removeNode(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (node.getParent() != this) {
            return;
        }
        node.setParent(null);
        this.allElements.remove(node);
        this.allElementsCached = null;
    }

    public List getNodes() {
        return Collections.unmodifiableList(this.allElements);
    }

    public int getNodeCount() {
        return this.allElements.size();
    }

    public Node[] getNodeArray() {
        if (this.allElementsCached == null) {
            if (this.allElements.isEmpty()) {
                this.allElementsCached = EMPTY_ARRAY;
            } else {
                Node[] nodeArray = new Node[this.allElements.size()];
                nodeArray = this.allElements.toArray(nodeArray);
                this.allElementsCached = nodeArray;
            }
        }
        return this.allElementsCached;
    }

    public Node getNode(int n) {
        if (this.allElementsCached == null) {
            if (this.allElements.isEmpty()) {
                this.allElementsCached = EMPTY_ARRAY;
            } else {
                Node[] nodeArray = new Node[this.allElements.size()];
                nodeArray = this.allElements.toArray(nodeArray);
                this.allElementsCached = nodeArray;
            }
        }
        return this.allElementsCached[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("={name=\"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\", namespace=\"");
        stringBuffer.append(this.getNamespace());
        stringBuffer.append("\", type=\"");
        stringBuffer.append(this.getType());
        stringBuffer.append("\", size=\"");
        stringBuffer.append(this.allElements.size());
        stringBuffer.append("\"}");
        return stringBuffer.toString();
    }

    public FlowControlOperation[] getOperationBefore() {
        if (this.operationsBefore == null) {
            return EMPTY_FLOWCONTROL;
        }
        if (this.operationsBeforeCached == null) {
            this.operationsBeforeCached = this.operationsBefore.toArray(EMPTY_FLOWCONTROL);
        }
        return this.operationsBeforeCached;
    }

    public FlowControlOperation[] getOperationAfter() {
        if (this.operationsAfter == null) {
            return EMPTY_FLOWCONTROL;
        }
        if (this.operationsAfterCached == null) {
            this.operationsAfterCached = this.operationsAfter.toArray(EMPTY_FLOWCONTROL);
        }
        return this.operationsAfterCached;
    }

    public void setOperationBefore(FlowControlOperation[] flowControlOperationArray) {
        if (this.operationsBefore == null) {
            this.operationsBefore = new ArrayList(flowControlOperationArray.length);
        } else {
            this.operationsBefore.clear();
            this.operationsBefore.ensureCapacity(flowControlOperationArray.length);
        }
        for (int i = 0; i < flowControlOperationArray.length; ++i) {
            this.operationsBefore.add(flowControlOperationArray[i]);
        }
        this.operationsBeforeCached = (FlowControlOperation[])flowControlOperationArray.clone();
    }

    public void setOperationAfter(FlowControlOperation[] flowControlOperationArray) {
        if (this.operationsAfter == null) {
            this.operationsAfter = new ArrayList(flowControlOperationArray.length);
        } else {
            this.operationsAfter.clear();
            this.operationsAfter.ensureCapacity(flowControlOperationArray.length);
        }
        for (int i = 0; i < flowControlOperationArray.length; ++i) {
            this.operationsAfter.add(flowControlOperationArray[i]);
        }
        this.operationsAfterCached = (FlowControlOperation[])flowControlOperationArray.clone();
    }

    public void addOperationAfter(FlowControlOperation flowControlOperation) {
        if (this.operationsAfter == null) {
            this.operationsAfter = new ArrayList();
        }
        this.operationsAfter.add(flowControlOperation);
        this.operationsAfterCached = null;
    }

    public void addOperationBefore(FlowControlOperation flowControlOperation) {
        if (this.operationsBefore == null) {
            this.operationsBefore = new ArrayList();
        }
        this.operationsBefore.add(flowControlOperation);
        this.operationsBeforeCached = null;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    public Element findFirstChild(String string, String string2) {
        Node[] nodeArray = this.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Element element;
            Node node = nodeArray[i];
            if (!(node instanceof Element) || !ObjectUtilities.equal((Object)string, (Object)(element = (Element)node).getNamespace()) || !ObjectUtilities.equal((Object)string2, (Object)element.getType())) continue;
            return element;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        Section section = (Section)super.clone();
        if (this.operationsAfter != null) {
            section.operationsAfter = (ArrayList)this.operationsAfter.clone();
        }
        if (this.operationsBefore != null) {
            section.operationsBefore = (ArrayList)this.operationsBefore.clone();
        }
        section.allElements = (ArrayList)this.allElements.clone();
        section.allElements.clear();
        int n = this.allElements.size();
        if (this.allElementsCached != null) {
            section.allElementsCached = (Node[])this.allElementsCached.clone();
            for (int i = 0; i < this.allElementsCached.length; ++i) {
                Node node = (Node)this.allElementsCached[i].clone();
                section.allElements.add(node);
                section.allElementsCached[i] = node;
                node.setParent(section);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Node node = (Node)this.allElements.get(i);
                Node node2 = (Node)node.clone();
                section.allElements.add(node2);
                node2.setParent(section);
            }
        }
        return section;
    }
}

