/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationsImpl;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionTypesKt {
    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isFunctionType($receiver) || (Boolean)DFS.dfsFromNode($receiver, isFunctionTypeOrSubtype.1.INSTANCE, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<KotlinType, Boolean>(){
            private boolean result;

            public boolean beforeChildren(@NotNull KotlinType current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if (FunctionTypesKt.isFunctionType(current)) {
                    this.result = true;
                }
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
        }) != false;
    }

    public static final boolean isFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor descriptor2 = $receiver.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && FunctionTypesKt.isNumberedFunctionClassFqName(DescriptorUtilsKt.getFqNameUnsafe(descriptor2));
    }

    public static final boolean isNonExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && !FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    public static final boolean isExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(@NotNull KotlinType $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        String shortName;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        if (!fqName2.startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return false;
        }
        List<Name> segments = fqName2.pathSegments();
        if (segments.size() != 2) {
            return false;
        }
        String string = shortName = ((Name)CollectionsKt.last(segments)).asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"shortName");
        FqName fqName3 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return BuiltInFictitiousFunctionClassFactory.Companion.isFunctionClassName(string, fqName3);
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = FunctionTypesKt.isFunctionType($receiver);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver) ? ((TypeProjection)CollectionsKt.first($receiver.getArguments())).getType() : (KotlinType)null;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = FunctionTypesKt.isFunctionType($receiver);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($receiver.getArguments())).getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = FunctionTypesKt.isFunctionType($receiver);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<TypeProjection> arguments2 = $receiver.getArguments();
        int first = FunctionTypesKt.isExtensionFunctionType($receiver) ? 1 : 0;
        int last = arguments2.size() - 1;
        boolean bl2 = first <= last;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Not an exact function type: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return arguments2.subList(first, last);
    }

    @Nullable
    public static final Name extractParameterNameFromFunctionTypeArgument(@NotNull KotlinType $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.parameterName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.parameterName");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor annotation = annotationDescriptor;
        Object object2 = CollectionsKt.singleOrNull((Iterable)annotation.getAllValueArguments().values());
        if (!(object2 instanceof StringValue)) {
            object2 = null;
        }
        if ((object = (StringValue)object2) == null || (object = (String)((ConstantValue)object).getValue()) == null || (object = (String)AddToStdlibKt.check(object, extractParameterNameFromFunctionTypeArgument.name.1.INSTANCE)) == null) {
            return null;
        }
        Object name2 = object;
        return Name.identifier((String)name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, @NotNull KotlinBuiltIns builtIns) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + (receiverType != null ? 1 : 0) + 1);
        KotlinType kotlinType = receiverType;
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType != null ? TypeUtilsKt.asTypeProjection(kotlinType) : null);
        Iterable iterable = parameterTypes;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            KotlinType kotlinType2;
            void type2;
            Name name2;
            void index;
            int n = index$iv++;
            KotlinType kotlinType3 = (KotlinType)item$iv;
            int n2 = n;
            Collection collection = arguments2;
            List<Name> list = parameterNames;
            Name name3 = list != null && (list = list.get((int)index)) != null ? (Name)AddToStdlibKt.check(list, getFunctionTypeArgumentProjections.1.name.1.INSTANCE) : (name2 = null);
            if (name2 != null) {
                ClassDescriptor annotationClass = builtIns.getBuiltInClassByName(KotlinBuiltIns.FQ_NAMES.parameterName.shortName());
                ConstantValueFactory constantValueFactory = new ConstantValueFactory(builtIns);
                String string = name2.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
                StringValue nameValue = constantValueFactory.createStringValue(string);
                KotlinType kotlinType4 = annotationClass.getDefaultType();
                ClassConstructorDescriptor classConstructorDescriptor = annotationClass.getUnsubstitutedPrimaryConstructor();
                if (classConstructorDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                AnnotationDescriptorImpl parameterNameAnnotation = new AnnotationDescriptorImpl(kotlinType4, MapsKt.mapOf((Pair)TuplesKt.to((Object)CollectionsKt.single(classConstructorDescriptor.getValueParameters()), (Object)nameValue)), SourceElement.NO_SOURCE);
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, new AnnotationsImpl(CollectionsKt.plus((Iterable)type2.getAnnotations(), (Object)parameterNameAnnotation)));
            } else {
                kotlinType2 = type2;
            }
            void typeToUse = kotlinType2;
            TypeProjection typeProjection = TypeUtilsKt.asTypeProjection((KotlinType)typeToUse);
            collection.add(typeProjection);
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType));
        return arguments2;
    }
}

