/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.WindowsResourceCompileSpec;
import org.gradle.util.TreeVisitor;

public abstract class AbstractPlatformToolProvider
implements PlatformToolProvider {
    protected final OperatingSystemInternal targetOperatingSystem;
    protected final BuildOperationProcessor buildOperationProcessor;

    public AbstractPlatformToolProvider(BuildOperationProcessor buildOperationProcessor, OperatingSystemInternal targetOperatingSystem) {
        this.targetOperatingSystem = targetOperatingSystem;
        this.buildOperationProcessor = buildOperationProcessor;
    }

    public boolean isAvailable() {
        return true;
    }

    public void explain(TreeVisitor<? super String> visitor) {
    }

    @Override
    public String getExecutableName(String executablePath) {
        return this.targetOperatingSystem.getInternalOs().getExecutableName(executablePath);
    }

    @Override
    public String getSharedLibraryName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public String getSharedLibraryLinkFileName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public String getStaticLibraryName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getStaticLibraryName(libraryPath);
    }

    public <T> T get(Class<T> toolType) {
        throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        if (CppCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createCppCompiler());
        }
        if (CppPCHCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createCppPCHCompiler());
        }
        if (CCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createCCompiler());
        }
        if (CPCHCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createCPCHCompiler());
        }
        if (ObjectiveCppCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createObjectiveCppCompiler());
        }
        if (ObjectiveCppPCHCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createObjectiveCppPCHCompiler());
        }
        if (ObjectiveCCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createObjectiveCCompiler());
        }
        if (ObjectiveCPCHCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createObjectiveCPCHCompiler());
        }
        if (WindowsResourceCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createWindowsResourceCompiler());
        }
        if (AssembleSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createAssembler());
        }
        if (LinkerSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createLinker());
        }
        if (StaticLibraryArchiverSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createStaticLibraryArchiver());
        }
        throw new IllegalArgumentException(String.format("Don't know how to compile from a spec of type %s.", spec.getClass().getSimpleName()));
    }

    protected final RuntimeException unavailableTool(String message) {
        return new RuntimeException(message);
    }

    protected Compiler<?> createCppCompiler() {
        throw this.unavailableTool("C++ compiler is not available");
    }

    protected Compiler<?> createCppPCHCompiler() {
        throw this.unavailableTool("C++ pre-compiled header compiler is not available");
    }

    protected Compiler<?> createCCompiler() {
        throw this.unavailableTool("C compiler is not available");
    }

    protected Compiler<?> createCPCHCompiler() {
        throw this.unavailableTool("C pre-compiled header compiler is not available");
    }

    protected Compiler<?> createObjectiveCppCompiler() {
        throw this.unavailableTool("Obj-C++ compiler is not available");
    }

    protected Compiler<?> createObjectiveCppPCHCompiler() {
        throw this.unavailableTool("Obj-C++ pre-compiled header compiler is not available");
    }

    protected Compiler<?> createObjectiveCCompiler() {
        throw this.unavailableTool("Obj-C compiler is not available");
    }

    protected Compiler<?> createObjectiveCPCHCompiler() {
        throw this.unavailableTool("Obj-C compiler is not available");
    }

    protected Compiler<?> createWindowsResourceCompiler() {
        throw this.unavailableTool("Windows resource compiler is not available");
    }

    protected Compiler<?> createAssembler() {
        throw this.unavailableTool("Assembler is not available");
    }

    protected Compiler<?> createLinker() {
        throw this.unavailableTool("Linker is not available");
    }

    protected Compiler<?> createStaticLibraryArchiver() {
        throw this.unavailableTool("Static library archiver is not available");
    }

    @Override
    public String getObjectFileExtension() {
        return this.targetOperatingSystem.isWindows() ? ".obj" : ".o";
    }
}

