/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionAwareHelper
implements ConventionMapping,
HasConvention {
    private final Convention _convention;
    private final IConventionAware _source;
    private final Map<String, MappedPropertyImpl> _mappings = new HashMap<String, MappedPropertyImpl>();

    public ConventionAwareHelper(IConventionAware source) {
        this(source, new DefaultConvention());
    }

    public ConventionAwareHelper(IConventionAware source, Convention convention) {
        this._source = source;
        this._convention = convention;
    }

    private ConventionMapping.MappedProperty map(String propertyName, Value<?> value) {
        if (!JavaReflectionUtil.propertyExists((Object)this._source, (String)propertyName)) {
            throw new InvalidUserDataException("You can't map a property that does not exist: propertyName=" + propertyName);
        }
        MappedPropertyImpl mappedProperty = new MappedPropertyImpl(value);
        this._mappings.put(propertyName, mappedProperty);
        return mappedProperty;
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Closure<?> value) {
        return this.map(propertyName, new Value<Object>(){

            @Override
            public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
                switch (value.getMaximumNumberOfParameters()) {
                    case 0: {
                        return value.call();
                    }
                    case 1: {
                        return value.call((Object)convention);
                    }
                }
                return value.call(new Object[]{convention, conventionAwareObject});
            }
        });
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Callable<?> value) {
        return this.map(propertyName, new Value<Object>(){

            @Override
            public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
                return GUtil.uncheckedCall((Callable)value);
            }
        });
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name, this.getClass());
        }
        this.map(name, (Closure)value);
    }

    @Override
    public <T> T getConventionValue(T actualValue, String propertyName, boolean isExplicitValue) {
        if (isExplicitValue) {
            return actualValue;
        }
        Object returnValue = actualValue;
        if (this._mappings.containsKey(propertyName)) {
            boolean useMapping = true;
            if (actualValue instanceof Collection && !((Collection)actualValue).isEmpty()) {
                useMapping = false;
            } else if (actualValue instanceof Map && !((Map)actualValue).isEmpty()) {
                useMapping = false;
            }
            if (useMapping) {
                returnValue = this._mappings.get(propertyName).getValue(this._convention, this._source);
            }
        }
        return returnValue;
    }

    @Override
    public Convention getConvention() {
        return this._convention;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappedPropertyImpl
    implements ConventionMapping.MappedProperty {
        private final Value<?> value;
        private boolean haveValue;
        private boolean cache;
        private Object cachedValue;

        private MappedPropertyImpl(Value<?> value) {
            this.value = value;
        }

        public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
            if (!this.cache) {
                return this.value.getValue(convention, conventionAwareObject);
            }
            if (!this.haveValue) {
                this.cachedValue = this.value.getValue(convention, conventionAwareObject);
                this.haveValue = true;
            }
            return this.cachedValue;
        }

        @Override
        public void cache() {
            this.cache = true;
            this.cachedValue = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Value<T> {
        public T getValue(Convention var1, IConventionAware var2);
    }
}

