/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.util.ConfigureUtil;

public class ModuleFactoryDelegate {
    private final ClientModule clientModule;
    private final DependencyFactory dependencyFactory;

    public ModuleFactoryDelegate(ClientModule clientModule, DependencyFactory dependencyFactory) {
        this.clientModule = clientModule;
        this.dependencyFactory = dependencyFactory;
    }

    public void prepareDelegation(Closure configureClosure) {
        ClientModuleConfigureDelegate delegate = new ClientModuleConfigureDelegate(this.clientModule, this);
        configureClosure.setDelegate((Object)delegate);
        configureClosure.setResolveStrategy(1);
    }

    public void dependency(Object dependencyNotation) {
        this.dependency(dependencyNotation, null);
    }

    public void dependency(Object dependencyNotation, Closure configureClosure) {
        Dependency dependency = this.dependencyFactory.createDependency(dependencyNotation);
        this.clientModule.addDependency((ModuleDependency)dependency);
        ConfigureUtil.configure(configureClosure, dependency);
    }

    public void dependencies(Object[] dependencyNotations) {
        for (Object notation : dependencyNotations) {
            this.clientModule.addDependency((ModuleDependency)this.dependencyFactory.createDependency(notation));
        }
    }

    public void module(Object dependencyNotation, Closure configureClosure) {
        this.clientModule.addDependency(this.dependencyFactory.createModule(dependencyNotation, configureClosure));
    }

    private static class ClientModuleConfigureDelegate
    extends GroovyObjectSupport {
        private final ModuleFactoryDelegate moduleFactoryDelegate;
        private final ClientModule clientModule;

        public ClientModuleConfigureDelegate(ClientModule clientModule, ModuleFactoryDelegate moduleFactoryDelegate) {
            this.clientModule = clientModule;
            this.moduleFactoryDelegate = moduleFactoryDelegate;
        }

        public Object invokeMethod(String name, Object args) {
            if (name.equals("dependency") || name.equals("dependencies") || name.equals("module")) {
                return InvokerHelper.invokeMethod((Object)this.moduleFactoryDelegate, (String)name, (Object)args);
            }
            return InvokerHelper.invokeMethod((Object)this.clientModule, (String)name, (Object)args);
        }

        public Object getProperty(String property) {
            return InvokerHelper.getProperty((Object)this.clientModule, (String)property);
        }

        public void setProperty(String property, Object newValue) {
            InvokerHelper.setProperty((Object)this.clientModule, (String)property, (Object)newValue);
        }
    }
}

