/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalkerFactory;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;
import org.gradle.internal.IoActions;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;

public class TarTaskOutputPacker
implements TaskOutputPacker {
    private static final String METADATA_PATH = "METADATA";
    private static final Pattern PROPERTY_PATH = Pattern.compile("property-([^/]+)(?:/(.*))?");
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final DefaultDirectoryWalkerFactory directoryWalkerFactory;
    private final FileSystem fileSystem;

    public TarTaskOutputPacker(FileSystem fileSystem) {
        this.directoryWalkerFactory = new DefaultDirectoryWalkerFactory(JavaVersion.current(), fileSystem);
        this.fileSystem = fileSystem;
    }

    public void pack(final TaskOutputsInternal taskOutputs, OutputStream output, final TaskOutputOriginWriter writeOrigin) {
        IoActions.withResource((Closeable)new TarOutputStream(output, "utf-8"), (Action)new Action<TarOutputStream>(){

            public void execute(TarOutputStream outputStream) {
                outputStream.setLongFileMode(3);
                outputStream.setBigNumberMode(2);
                outputStream.setAddPaxHeadersForNonAsciiNames(true);
                try {
                    TarTaskOutputPacker.this.packMetadata(writeOrigin, outputStream);
                    TarTaskOutputPacker.this.pack(taskOutputs, outputStream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packMetadata(TaskOutputOriginWriter writeMetadata, TarOutputStream outputStream) throws IOException {
        TarEntry entry = new TarEntry(METADATA_PATH);
        entry.setMode(33188);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writeMetadata.execute(baos);
        entry.setSize((long)baos.size());
        outputStream.putNextEntry(entry);
        try {
            outputStream.write(baos.toByteArray());
        }
        finally {
            outputStream.closeEntry();
        }
    }

    private void pack(TaskOutputsInternal taskOutputs, TarOutputStream outputStream) {
        for (TaskOutputFilePropertySpec spec : taskOutputs.getFileProperties()) {
            try {
                this.packProperty((CacheableTaskOutputFilePropertySpec)spec, outputStream);
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not pack property '%s': %s", spec.getPropertyName(), ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void packProperty(CacheableTaskOutputFilePropertySpec propertySpec, TarOutputStream outputStream) throws IOException {
        String propertyName = propertySpec.getPropertyName();
        File outputFile = propertySpec.getOutputFile();
        if (outputFile == null) {
            return;
        }
        switch (propertySpec.getOutputType()) {
            case DIRECTORY: {
                this.storeDirectoryProperty(propertyName, outputFile, outputStream);
                break;
            }
            case FILE: {
                this.storeFileProperty(propertyName, outputFile, outputStream);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void storeDirectoryProperty(String propertyName, File directory, final TarOutputStream outputStream) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", directory));
        }
        final String propertyRoot = "property-" + propertyName + "/";
        outputStream.putNextEntry(new TarEntry(propertyRoot));
        outputStream.closeEntry();
        FileVisitor visitor = new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                try {
                    TarTaskOutputPacker.this.storeDirectoryEntry(dirDetails, propertyRoot, outputStream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }

            public void visitFile(FileVisitDetails fileDetails) {
                try {
                    String path = propertyRoot + fileDetails.getRelativePath().getPathString();
                    TarTaskOutputPacker.this.storeFileEntry(fileDetails.getFile(), path, fileDetails.getLastModified(), fileDetails.getSize(), fileDetails.getMode(), outputStream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        };
        this.directoryWalkerFactory.create().walkDir(directory, RelativePath.EMPTY_ROOT, visitor, (Spec<? super FileTreeElement>)Specs.satisfyAll(), new AtomicBoolean(), false);
    }

    private void storeFileProperty(String propertyName, File file, TarOutputStream outputStream) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("Expected '%s' to be a file", file));
        }
        String path = "property-" + propertyName;
        this.storeFileEntry(file, path, file.lastModified(), file.length(), this.fileSystem.getUnixMode(file), outputStream);
    }

    private void storeDirectoryEntry(FileVisitDetails dirDetails, String propertyRoot, TarOutputStream outputStream) throws IOException {
        String path = dirDetails.getRelativePath().getPathString();
        TarEntry entry = new TarEntry(propertyRoot + path + "/");
        TarTaskOutputPacker.storeModificationTime(entry, dirDetails.getLastModified());
        entry.setMode(0x4000 | dirDetails.getMode());
        outputStream.putNextEntry(entry);
        outputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFileEntry(File file, String path, long lastModified, long size, int mode, TarOutputStream outputStream) throws IOException {
        TarEntry entry = new TarEntry(path);
        TarTaskOutputPacker.storeModificationTime(entry, lastModified);
        entry.setSize(size);
        entry.setMode(0x8000 | mode);
        outputStream.putNextEntry(entry);
        try {
            Files.copy((File)file, (OutputStream)outputStream);
        }
        finally {
            outputStream.closeEntry();
        }
    }

    public void unpack(final TaskOutputsInternal taskOutputs, InputStream input, final TaskOutputOriginReader readOrigin) {
        IoActions.withResource((Closeable)new TarInputStream(input), (Action)new Action<TarInputStream>(){

            public void execute(TarInputStream tarInput) {
                try {
                    TarTaskOutputPacker.this.unpack(taskOutputs, tarInput, readOrigin);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
    }

    private void unpack(TaskOutputsInternal taskOutputs, TarInputStream tarInput, TaskOutputOriginReader readOriginAction) throws IOException {
        TarEntry entry;
        ImmutableMap propertySpecs = Maps.uniqueIndex(taskOutputs.getFileProperties(), (Function)new Function<TaskFilePropertySpec, String>(){

            public String apply(TaskFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
        boolean originSeen = false;
        while ((entry = tarInput.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.equals(METADATA_PATH)) {
                originSeen = true;
                readOriginAction.execute((InputStream)new CloseShieldInputStream((InputStream)tarInput));
                continue;
            }
            Matcher matcher = PROPERTY_PATH.matcher(name);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached result format error, invalid contents: " + name);
            }
            String propertyName = matcher.group(1);
            CacheableTaskOutputFilePropertySpec propertySpec = (CacheableTaskOutputFilePropertySpec)propertySpecs.get(propertyName);
            if (propertySpec == null) {
                throw new IllegalStateException(String.format("No output property '%s' registered", propertyName));
            }
            File specRoot = propertySpec.getOutputFile();
            String path = matcher.group(2);
            File outputFile = Strings.isNullOrEmpty((String)path) ? specRoot : new File(specRoot, path);
            if (entry.isDirectory()) {
                if (propertySpec.getOutputType() != CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY) {
                    throw new IllegalStateException("Property should be an output directory property: " + propertyName);
                }
                FileUtils.forceMkdir((File)outputFile);
            } else {
                Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)tarInput);
            }
            this.fileSystem.chmod(outputFile, entry.getMode() & 0x1FF);
            long lastModified = TarTaskOutputPacker.getModificationTime(entry);
            if (outputFile.setLastModified(lastModified)) continue;
            throw new UnsupportedOperationException(String.format("Could not set modification time for '%s'", outputFile));
        }
        if (!originSeen) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
    }

    private static void storeModificationTime(TarEntry entry, long lastModified) {
        entry.setModTime(lastModified);
        long excessNanos = TimeUnit.MILLISECONDS.toNanos(lastModified % 1000L);
        entry.setGroupId(-excessNanos);
    }

    private static long getModificationTime(TarEntry entry) {
        long lastModified = entry.getModTime().getTime();
        long excessNanos = -entry.getLongGroupId();
        if (excessNanos < 0L || excessNanos >= NANOS_PER_SECOND) {
            throw new IllegalStateException("Invalid excess nanos: " + excessNanos);
        }
        return lastModified += TimeUnit.NANOSECONDS.toMillis(excessNanos);
    }
}

