/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecHandleBuilder
extends AbstractExecHandleBuilder
implements ExecHandleBuilder {
    private final List<Object> arguments = new ArrayList<Object>();

    public DefaultExecHandleBuilder() {
        super(new IdentityFileResolver());
    }

    public DefaultExecHandleBuilder(PathToFileResolver fileResolver) {
        super(fileResolver);
    }

    @Override
    public DefaultExecHandleBuilder executable(Object executable) {
        super.executable(executable);
        return this;
    }

    public DefaultExecHandleBuilder commandLine(Object ... arguments) {
        this.commandLine(Arrays.asList(arguments));
        return this;
    }

    public DefaultExecHandleBuilder commandLine(Iterable<?> args) {
        ArrayList argsList = Lists.newArrayList(args);
        this.executable(argsList.get(0));
        this.setArgs(argsList.subList(1, argsList.size()));
        return this;
    }

    public void setCommandLine(Object ... args) {
        this.commandLine(args);
    }

    public void setCommandLine(Iterable<?> args) {
        this.commandLine(args);
    }

    public DefaultExecHandleBuilder args(Object ... args) {
        if (args == null) {
            throw new IllegalArgumentException("args == null!");
        }
        this.arguments.addAll(Arrays.asList(args));
        return this;
    }

    public DefaultExecHandleBuilder args(Iterable<?> args) {
        GUtil.addToCollection(this.arguments, (Iterable[])new Iterable[]{args});
        return this;
    }

    public DefaultExecHandleBuilder setArgs(Iterable<?> arguments) {
        this.arguments.clear();
        GUtil.addToCollection(this.arguments, (Iterable[])new Iterable[]{arguments});
        return this;
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object argument : this.arguments) {
            args.add(argument.toString());
        }
        return args;
    }

    @Override
    public List<String> getAllArguments() {
        return this.getArgs();
    }

    @Override
    public DefaultExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        super.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder workingDir(Object dir) {
        super.workingDir(dir);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder redirectErrorStream() {
        super.redirectErrorStream();
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setStandardOutput(OutputStream outputStream) {
        super.setStandardOutput(outputStream);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setStandardInput(InputStream inputStream) {
        super.setStandardInput(inputStream);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder listener(ExecHandleListener listener) {
        super.listener(listener);
        return this;
    }

    @Override
    public DefaultExecHandleBuilder setTimeout(int timeoutMillis) {
        super.setTimeout(timeoutMillis);
        return this;
    }

    public ExecHandleBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }
}

