/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.util.TextUtil;

public abstract class AbstractTestLogger {
    private final StyledTextOutputFactory textOutputFactory;
    private final LogLevel logLevel;
    private final int displayGranularity;
    private TestDescriptor lastSeenTestDescriptor;
    private TestLogEvent lastSeenTestEvent;

    protected AbstractTestLogger(StyledTextOutputFactory textOutputFactory, LogLevel logLevel, int displayGranularity) {
        this.textOutputFactory = textOutputFactory;
        this.logLevel = logLevel;
        this.displayGranularity = displayGranularity;
    }

    protected void logEvent(TestDescriptor descriptor, TestLogEvent event) {
        this.logEvent(descriptor, event, null);
    }

    protected void logEvent(TestDescriptor descriptor, TestLogEvent event, @Nullable String details) {
        StyledTextOutput output = this.textOutputFactory.create("TestEventLogger", this.logLevel);
        if (!descriptor.equals(this.lastSeenTestDescriptor) || event != this.lastSeenTestEvent) {
            output.println().append((CharSequence)this.getEventPath(descriptor));
            output.withStyle(this.getStyle(event)).println((Object)event.toString());
        }
        this.lastSeenTestDescriptor = descriptor;
        this.lastSeenTestEvent = event;
        if (details != null) {
            output.append((CharSequence)TextUtil.toPlatformLineSeparators((String)details));
        }
    }

    private String getEventPath(TestDescriptor descriptor) {
        ArrayList names = Lists.newArrayList();
        for (TestDescriptor current = descriptor; current != null; current = current.getParent()) {
            if (this.isAtomicTestWhoseParentIsNotTheTestClass(current)) {
                names.add(current.getClassName() + "." + current.getName());
                continue;
            }
            names.add(current.getName());
        }
        int effectiveDisplayGranularity = this.displayGranularity == -1 ? names.size() - 1 : Math.min(this.displayGranularity, names.size() - 1);
        List displayedNames = Lists.reverse((List)names).subList(effectiveDisplayGranularity, names.size());
        return Joiner.on((String)" > ").join(displayedNames) + " ";
    }

    private boolean isAtomicTestWhoseParentIsNotTheTestClass(TestDescriptor current) {
        return !current.isComposite() && current.getClassName() != null && (current.getParent() == null || !current.getClassName().equals(current.getParent().getName()));
    }

    private StyledTextOutput.Style getStyle(TestLogEvent event) {
        switch (event) {
            case PASSED: {
                return StyledTextOutput.Style.Identifier;
            }
            case FAILED: {
                return StyledTextOutput.Style.Failure;
            }
            case SKIPPED: {
                return StyledTextOutput.Style.Info;
            }
        }
        return StyledTextOutput.Style.Normal;
    }
}

