/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.internal.component.model.ComponentResolveMetadata;

class ProjectDependencyForcingResolver
implements ModuleConflictResolver {
    private final ModuleConflictResolver delegate;

    ProjectDependencyForcingResolver(ModuleConflictResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T extends ComponentResolutionState> T select(Collection<? extends T> candidates) {
        ArrayList<ComponentResolutionState> projectCandidates = null;
        ComponentResolutionState foundProjectCandidate = null;
        for (ComponentResolutionState candidate : candidates) {
            ComponentResolveMetadata metaData = candidate.getMetaData();
            if (metaData == null || !(metaData.getComponentId() instanceof ProjectComponentIdentifier)) continue;
            if (foundProjectCandidate == null) {
                foundProjectCandidate = candidate;
                continue;
            }
            if (projectCandidates == null) {
                projectCandidates = new ArrayList<ComponentResolutionState>();
                projectCandidates.add(foundProjectCandidate);
            }
            projectCandidates.add(candidate);
        }
        if (projectCandidates != null) {
            return this.delegate.select(projectCandidates);
        }
        return (T)(foundProjectCandidate != null ? foundProjectCandidate : (ComponentResolutionState)this.delegate.select(candidates));
    }
}

