/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Buildable;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.attributes.DefaultArtifactAttributes;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.transform.ArtifactAttributeMatchingCache;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.resolve.ArtifactResolveException;

public class DefaultArtifactTransforms
implements ArtifactTransforms {
    private ArtifactAttributeMatchingCache matchingCache;

    public DefaultArtifactTransforms(ArtifactAttributeMatchingCache matchingCache) {
        this.matchingCache = matchingCache;
    }

    @Override
    public <T extends HasAttributes> Transformer<T, Collection<? extends T>> variantSelector(AttributeContainerInternal attributes) {
        return new AttributeMatchingVariantSelector((AttributeContainer)attributes.asImmutable());
    }

    @Override
    public ArtifactVisitor visitor(ArtifactVisitor visitor, @Nullable AttributeContainerInternal attributes, ImmutableAttributesFactory attributesFactory) {
        if (attributes == null || attributes.isEmpty()) {
            return visitor;
        }
        return new ArtifactTransformingVisitor(visitor, (AttributeContainerInternal)attributes.asImmutable(), attributesFactory);
    }

    private class ArtifactTransformingVisitor
    implements ArtifactVisitor {
        private final ArtifactVisitor visitor;
        private final AttributeContainerInternal attributes;
        private final ImmutableAttributesFactory attributesFactory;

        private ArtifactTransformingVisitor(@Nullable ArtifactVisitor visitor, AttributeContainerInternal attributes, ImmutableAttributesFactory attributesFactory) {
            this.visitor = visitor;
            this.attributes = attributes;
            this.attributesFactory = attributesFactory;
        }

        @Override
        public void visitArtifact(ResolvedArtifact artifact) {
            ArrayList transformResults = DefaultArtifactTransforms.this.matchingCache.getTransformedArtifacts(artifact, (AttributeContainer)this.attributes);
            if (transformResults == null && DefaultArtifactTransforms.this.matchingCache.areMatchingAttributes(artifact.getAttributes(), (AttributeContainer)this.attributes)) {
                transformResults = Collections.singletonList(artifact);
                DefaultArtifactTransforms.this.matchingCache.putTransformedArtifact(artifact, (AttributeContainer)this.attributes, transformResults);
            }
            if (transformResults != null) {
                for (ResolvedArtifact resolvedArtifact : transformResults) {
                    this.visitor.visitArtifact(resolvedArtifact);
                }
                return;
            }
            ImmutableAttributes artifactAttributes = ((AttributeContainerInternal)artifact.getAttributes()).asImmutable();
            Transformer<List<File>, File> transform = DefaultArtifactTransforms.this.matchingCache.getTransform((AttributeContainer)artifactAttributes, (AttributeContainer)this.attributes);
            if (transform == null) {
                throw new ArtifactResolveException("Artifact " + artifact + " is not compatible with requested attributes " + this.attributes);
            }
            TaskDependency buildDependencies = ((Buildable)artifact).getBuildDependencies();
            transformResults = Lists.newArrayList();
            List transformedFiles = (List)transform.transform((Object)artifact.getFile());
            for (File output : transformedFiles) {
                ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(artifact.getId().getComponentIdentifier(), output.getName());
                DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forAttributeContainer(output.getName(), (AttributeContainer)this.attributes);
                DefaultResolvedArtifact resolvedArtifact = new DefaultResolvedArtifact(artifact.getModuleVersion().getId(), (IvyArtifactName)artifactName, (ComponentArtifactIdentifier)newId, buildDependencies, output, this.attributes, this.attributesFactory);
                transformResults.add(resolvedArtifact);
                this.visitor.visitArtifact(resolvedArtifact);
            }
            DefaultArtifactTransforms.this.matchingCache.putTransformedArtifact(artifact, (AttributeContainer)this.attributes, transformResults);
        }

        @Override
        public boolean includeFiles() {
            return this.visitor.includeFiles();
        }

        @Override
        public void visitFiles(@Nullable ComponentIdentifier componentIdentifier, Iterable<File> files) {
            ArrayList<File> result = new ArrayList<File>();
            RuntimeException transformException = null;
            try {
                for (File file : files) {
                    try {
                        AttributeContainer fileWithAttributes;
                        List transformResults = DefaultArtifactTransforms.this.matchingCache.getTransformedFile(file, (AttributeContainer)this.attributes);
                        if (transformResults == null) {
                            fileWithAttributes = DefaultArtifactAttributes.forFile(file, this.attributesFactory);
                            if (DefaultArtifactTransforms.this.matchingCache.areMatchingAttributes(fileWithAttributes, (AttributeContainer)this.attributes)) {
                                transformResults = Collections.singletonList(file);
                                DefaultArtifactTransforms.this.matchingCache.putTransformedFile(file, (AttributeContainer)this.attributes, transformResults);
                            }
                        }
                        if (transformResults != null) {
                            result.addAll(transformResults);
                            continue;
                        }
                        fileWithAttributes = DefaultArtifactAttributes.forFile(file, this.attributesFactory);
                        Transformer<List<File>, File> transform = DefaultArtifactTransforms.this.matchingCache.getTransform(fileWithAttributes, (AttributeContainer)this.attributes);
                        if (transform == null) continue;
                        transformResults = (List)transform.transform((Object)file);
                        DefaultArtifactTransforms.this.matchingCache.putTransformedFile(file, (AttributeContainer)this.attributes, transformResults);
                        result.addAll(transformResults);
                    }
                    catch (RuntimeException e) {
                        transformException = e;
                        break;
                    }
                }
            }
            catch (Throwable t) {
                this.visitor.visitFiles(componentIdentifier, files);
            }
            if (transformException != null) {
                throw transformException;
            }
            if (!result.isEmpty()) {
                this.visitor.visitFiles(componentIdentifier, result);
            }
        }
    }

    private class AttributeMatchingVariantSelector<T extends HasAttributes>
    implements Transformer<T, Collection<? extends T>> {
        private final AttributeContainer attributes;

        private AttributeMatchingVariantSelector(AttributeContainer attributes) {
            this.attributes = attributes;
        }

        public String toString() {
            return "Variant selector for " + this.attributes;
        }

        public T transform(Collection<? extends T> variants) {
            if (this.attributes.isEmpty()) {
                return (T)((HasAttributes)variants.iterator().next());
            }
            HasAttributes canTransform = null;
            for (HasAttributes variant : variants) {
                ImmutableAttributes variantAttributes = ((AttributeContainerInternal)variant.getAttributes()).asImmutable();
                if (DefaultArtifactTransforms.this.matchingCache.areMatchingAttributes((AttributeContainer)variantAttributes, this.attributes)) {
                    return (T)variant;
                }
                if (DefaultArtifactTransforms.this.matchingCache.getTransform((AttributeContainer)variantAttributes, this.attributes) == null) continue;
                canTransform = variant;
            }
            return (T)canTransform;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributeMatchingVariantSelector)) {
                return false;
            }
            AttributeMatchingVariantSelector that = (AttributeMatchingVariantSelector)o;
            return Objects.equal((Object)this.attributes, (Object)that.attributes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.attributes});
        }
    }
}

