/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Arrays;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.daemon.DaemonForkOptions;
import org.gradle.process.internal.daemon.WorkerDaemonFactory;

public class DaemonScalaCompiler<T extends ScalaJavaJointCompileSpec>
extends AbstractDaemonCompiler<T> {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("scala", "com.typesafe.zinc", "xsbti", "com.sun.tools.javac", "sbt");
    private final Iterable<File> zincClasspath;

    public DaemonScalaCompiler(File daemonWorkingDir, Compiler<T> delegate, WorkerDaemonFactory daemonFactory, Iterable<File> zincClasspath) {
        super(daemonWorkingDir, delegate, daemonFactory);
        this.zincClasspath = zincClasspath;
    }

    protected DaemonForkOptions toDaemonOptions(T spec) {
        return this.createJavaForkOptions(spec).mergeWith(this.createScalaForkOptions(spec));
    }

    private DaemonForkOptions createJavaForkOptions(T spec) {
        ForkOptions options = spec.getCompileOptions().getForkOptions();
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs());
    }

    private DaemonForkOptions createScalaForkOptions(T spec) {
        ScalaForkOptions options = spec.getScalaCompileOptions().getForkOptions();
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs(), this.zincClasspath, SHARED_PACKAGES);
    }
}

