/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.visitors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.gradleplugin.foundation.filters.AllowAllProjectAndTaskFilter;
import org.gradle.gradleplugin.foundation.filters.ProjectAndTaskFilter;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTreePopulationVisitor {
    public static <P, T> void visitProjectAndTasks(List<ProjectView> projects, Visitor<P, T> visitor, P rootProjectObject) {
        TaskTreePopulationVisitor.visitProjectAndTasks(projects, visitor, new AllowAllProjectAndTaskFilter(), rootProjectObject);
    }

    public static <P, T> void visitProjectAndTasks(List<ProjectView> projects, Visitor<P, T> visitor, ProjectAndTaskFilter filter, P rootProjectObject) {
        List<P> userProjectObjects = TaskTreePopulationVisitor.visitProjects(visitor, filter, projects, rootProjectObject, new AlphabeticalProjectNameComparator(), new AlphabeticalTaskNameComparator());
        visitor.completedVisitingProject(rootProjectObject, userProjectObjects, Collections.emptyList());
    }

    private static <P, T> List<P> visitProjects(Visitor<P, T> visitor, ProjectAndTaskFilter filter, List<ProjectView> sourceProjects, P parentProjectObject, Comparator<ProjectView> projectSorter, Comparator<TaskView> taskSorter) {
        ArrayList<P> projectObjects = new ArrayList<P>();
        sourceProjects = CollectionUtils.sort(sourceProjects, projectSorter);
        Iterator iterator = sourceProjects.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            ProjectView project = (ProjectView)iterator.next();
            if (filter.doesAllowProject(project)) {
                P userProjectObject = visitor.visitProject(project, index, parentProjectObject);
                projectObjects.add(userProjectObject);
                List<P> subProjectObjects = TaskTreePopulationVisitor.visitProjects(visitor, filter, project.getSubProjects(), userProjectObject, projectSorter, taskSorter);
                List<T> taskObjects = TaskTreePopulationVisitor.visitTasks(visitor, filter, project, subProjectObjects.size(), userProjectObject, taskSorter);
                visitor.completedVisitingProject(userProjectObject, subProjectObjects, taskObjects);
            }
            ++index;
        }
        return projectObjects;
    }

    private static <P, T> List<T> visitTasks(Visitor<P, T> visitor, ProjectAndTaskFilter filter, ProjectView project, int startingIndex, P userProjectObject, Comparator<TaskView> taskSorter) {
        ArrayList<T> taskObjects = new ArrayList<T>();
        List tasks = CollectionUtils.sort(project.getTasks(), taskSorter);
        Iterator iterator = tasks.iterator();
        int index = startingIndex;
        while (iterator.hasNext()) {
            TaskView task = (TaskView)iterator.next();
            if (filter.doesAllowTask(task)) {
                T taskObject = visitor.visitTask(task, index, project, userProjectObject);
                taskObjects.add(taskObject);
            }
            ++index;
        }
        return taskObjects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlphabeticalTaskNameComparator
    implements Comparator<TaskView> {
        @Override
        public int compare(TaskView o1, TaskView o2) {
            return GUtil.caseInsensitive().compare(o1.getName(), o2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlphabeticalProjectNameComparator
    implements Comparator<ProjectView> {
        @Override
        public int compare(ProjectView o1, ProjectView o2) {
            return GUtil.caseInsensitive().compare(o1.getName(), o2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor<P, T> {
        public P visitProject(ProjectView var1, int var2, P var3);

        public T visitTask(TaskView var1, int var2, ProjectView var3, P var4);

        public void completedVisitingProject(P var1, List<P> var2, List<T> var3);
    }
}

