/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.AlternateUIInteraction;
import org.gradle.gradleplugin.userinterface.swing.common.PreferencesAssistant;
import org.gradle.gradleplugin.userinterface.swing.generic.AbstractGradleUIInstance;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputPanelLord;
import org.gradle.gradleplugin.userinterface.swing.generic.OutputUILord;

public class SinglePaneUIInstance
extends AbstractGradleUIInstance {
    private static final String SPLITTER_PREFERENCES_ID = "splitter-id";
    private JSplitPane splitter;
    private OutputPanelLord outputPanelLord;

    public void initialize(SettingsNode settings, AlternateUIInteraction alternateUIInteraction) {
        this.outputPanelLord = new OutputPanelLord(this.gradlePluginLord, alternateUIInteraction);
        super.initialize(settings, alternateUIInteraction);
    }

    protected void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.createCenterPanel(), "Center");
    }

    public OutputUILord getOutputUILord() {
        return this.outputPanelLord;
    }

    private Component createCenterPanel() {
        this.splitter = new JSplitPane(0);
        this.splitter.setTopComponent(this.createMainGradlePanel());
        this.splitter.setBottomComponent(this.outputPanelLord.getMainPanel());
        this.splitter.setContinuousLayout(true);
        this.splitter.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (4L == (e.getChangeFlags() & 4L)) {
                    SinglePaneUIInstance.this.splitter.removeHierarchyListener(this);
                    Window window = SwingUtilities.getWindowAncestor(SinglePaneUIInstance.this.splitter);
                    if (window != null) {
                        Dimension dimension = window.getSize();
                        int halfHeight = dimension.height / 2;
                        SinglePaneUIInstance.this.splitter.setDividerLocation(halfHeight);
                    }
                    PreferencesAssistant.restoreSettings(SinglePaneUIInstance.this.settings, SinglePaneUIInstance.this.splitter, SinglePaneUIInstance.SPLITTER_PREFERENCES_ID, SinglePaneUIInstance.class);
                    SinglePaneUIInstance.this.splitter.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if ("dividerLocation".equals(evt.getPropertyName())) {
                                PreferencesAssistant.saveSettings(SinglePaneUIInstance.this.settings, SinglePaneUIInstance.this.splitter, SinglePaneUIInstance.SPLITTER_PREFERENCES_ID, SinglePaneUIInstance.class);
                            }
                        }
                    });
                }
            }
        });
        this.splitter.setResizeWeight(1.0);
        return this.splitter;
    }
}

