/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jacoco;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.specs.Spec;
import org.gradle.util.VersionNumber;

public class JacocoAgentJar {
    private static final VersionNumber V_0_6_2_0 = VersionNumber.parse((String)"0.6.2.0");
    private static final VersionNumber V_0_7_6_0 = VersionNumber.parse((String)"0.7.6.0");
    private final Project project;
    private FileCollection agentConf;
    private File agentJar;

    public JacocoAgentJar(Project project) {
        this.project = project;
    }

    public FileCollection getAgentConf() {
        return this.agentConf;
    }

    public void setAgentConf(FileCollection agentConf) {
        this.agentConf = agentConf;
    }

    public File getJar() {
        if (this.agentJar == null) {
            this.agentJar = this.project.zipTree((Object)this.getAgentConfConventionValue().getSingleFile()).filter((Spec)new Spec<File>(){

                public boolean isSatisfiedBy(File file) {
                    return file.getName().equals("jacocoagent.jar");
                }
            }).getSingleFile();
        }
        return this.agentJar;
    }

    public boolean supportsJmx() {
        boolean pre062 = Iterables.any((Iterable)this.getAgentConfConventionValue(), (Predicate)new Predicate<File>(){

            public boolean apply(File file) {
                return V_0_6_2_0.compareTo(JacocoAgentJar.extractVersion(file.getName())) > 0;
            }
        });
        return !pre062;
    }

    public boolean supportsInclNoLocationClasses() {
        boolean pre076 = Iterables.any((Iterable)this.getAgentConfConventionValue(), (Predicate)new Predicate<File>(){

            public boolean apply(File file) {
                return V_0_7_6_0.compareTo(JacocoAgentJar.extractVersion(file.getName())) > 0;
            }
        });
        return !pre076;
    }

    private FileCollection getAgentConfConventionValue() {
        if (this instanceof IConventionAware) {
            return (FileCollection)((IConventionAware)this).getConventionMapping().getConventionValue((Object)this.agentConf, "agentConf", false);
        }
        return this.agentConf;
    }

    public static VersionNumber extractVersion(String jarName) {
        int versionStart = "org.jacoco.agent-".length();
        int versionEnd = jarName.length() - ".jar".length();
        return VersionNumber.parse((String)jarName.substring(versionStart, versionEnd));
    }
}

