/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.antlr.AntlrTask;
import org.gradle.api.plugins.antlr.internal.AntlrSourceVirtualDirectoryImpl;
import org.gradle.api.tasks.SourceSet;

public class AntlrPlugin
implements Plugin<Project> {
    public static final String ANTLR_CONFIGURATION_NAME = "antlr";
    private final SourceDirectorySetFactory sourceDirectorySetFactory;

    @Inject
    public AntlrPlugin(SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.sourceDirectorySetFactory = sourceDirectorySetFactory;
    }

    public void apply(final Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        Configuration antlrConfiguration = ((Configuration)project.getConfigurations().create(ANTLR_CONFIGURATION_NAME)).setVisible(false).setDescription("The Antlr libraries to be used for this project.");
        antlrConfiguration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)project.getDependencies().create((Object)"antlr:antlr:2.7.7@jar"));
            }
        });
        project.getConfigurations().getByName("compile").extendsFrom(new Configuration[]{antlrConfiguration});
        project.getTasks().withType(AntlrTask.class, (Action)new Action<AntlrTask>(){

            public void execute(AntlrTask antlrTask) {
                antlrTask.getConventionMapping().map("antlrClasspath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return project.getConfigurations().getByName(AntlrPlugin.ANTLR_CONFIGURATION_NAME);
                    }
                });
            }
        });
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                AntlrSourceVirtualDirectoryImpl antlrDirectoryDelegate = new AntlrSourceVirtualDirectoryImpl(((DefaultSourceSet)sourceSet).getDisplayName(), AntlrPlugin.this.sourceDirectorySetFactory);
                new DslObject((Object)sourceSet).getConvention().getPlugins().put(AntlrPlugin.ANTLR_CONFIGURATION_NAME, antlrDirectoryDelegate);
                String srcDir = "src/" + sourceSet.getName() + "/antlr";
                antlrDirectoryDelegate.getAntlr().srcDir((Object)srcDir);
                sourceSet.getAllSource().source(antlrDirectoryDelegate.getAntlr());
                String taskName = sourceSet.getTaskName("generate", "GrammarSource");
                AntlrTask antlrTask = (AntlrTask)project.getTasks().create(taskName, AntlrTask.class);
                antlrTask.setDescription("Processes the " + sourceSet.getName() + " Antlr grammars.");
                antlrTask.setSource(antlrDirectoryDelegate.getAntlr());
                String outputDirectoryName = project.getBuildDir() + "/generated-src/antlr/" + sourceSet.getName();
                File outputDirectory = new File(outputDirectoryName);
                antlrTask.setOutputDirectory(outputDirectory);
                sourceSet.getJava().srcDir((Object)outputDirectory);
                project.getTasks().getByName(sourceSet.getCompileJavaTaskName()).dependsOn(new Object[]{taskName});
            }
        });
    }
}

