/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.artifacts.maven.PublishFilter;
import org.gradle.api.publication.maven.internal.DefaultPomFilter;
import org.gradle.api.publication.maven.internal.PomFilter;
import org.gradle.internal.Factory;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.WrapUtil;

public class BasePomFilterContainer
implements PomFilterContainer {
    private Map<String, PomFilter> pomFilters = new HashMap<String, PomFilter>();
    private PomFilter defaultPomFilter;
    private Factory<MavenPom> mavenPomFactory;

    public BasePomFilterContainer(Factory<MavenPom> mavenPomFactory) {
        this.mavenPomFactory = mavenPomFactory;
    }

    @Override
    public PublishFilter getFilter() {
        return this.getDefaultPomFilter().getFilter();
    }

    @Override
    public void setFilter(PublishFilter defaultFilter) {
        this.getDefaultPomFilter().setFilter(defaultFilter);
    }

    @Override
    public MavenPom getPom() {
        return this.getDefaultPomFilter().getPomTemplate();
    }

    @Override
    public void setPom(MavenPom defaultPom) {
        this.getDefaultPomFilter().setPomTemplate(defaultPom);
    }

    @Override
    public void filter(Closure filter) {
        this.setFilter(this.toFilter(filter));
    }

    @Override
    public MavenPom addFilter(String name, Closure filter) {
        return this.addFilter(name, this.toFilter(filter));
    }

    private PublishFilter toFilter(Closure filter) {
        return (PublishFilter)DefaultGroovyMethods.asType((Closure)filter, PublishFilter.class);
    }

    @Override
    public MavenPom pom(Closure configureClosure) {
        return (MavenPom)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getPom());
    }

    @Override
    public MavenPom pom(String name, Closure configureClosure) {
        return (MavenPom)ConfigureUtil.configure((Closure)configureClosure, (Object)this.pom(name));
    }

    @Override
    public MavenPom addFilter(String name, PublishFilter publishFilter) {
        if (name == null || publishFilter == null) {
            throw new InvalidUserDataException("Name and Filter must not be null.");
        }
        MavenPom pom = (MavenPom)this.mavenPomFactory.create();
        this.pomFilters.put(name, new DefaultPomFilter(name, pom, publishFilter));
        return pom;
    }

    @Override
    public PublishFilter filter(String name) {
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null.");
        }
        return this.pomFilters.get(name).getFilter();
    }

    @Override
    public MavenPom pom(String name) {
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null.");
        }
        return this.pomFilters.get(name).getPomTemplate();
    }

    @Override
    public Iterable<PomFilter> getActivePomFilters() {
        Set activeArtifactPoms = this.pomFilters.size() == 0 && this.getDefaultPomFilter() != null ? WrapUtil.toSet((Object[])new PomFilter[]{this.getDefaultPomFilter()}) : this.pomFilters.values();
        return activeArtifactPoms;
    }

    public Factory<MavenPom> getMavenPomFactory() {
        return this.mavenPomFactory;
    }

    public PomFilter getDefaultPomFilter() {
        if (this.defaultPomFilter == null) {
            this.defaultPomFilter = new DefaultPomFilter("default", (MavenPom)this.mavenPomFactory.create(), PublishFilter.ALWAYS_ACCEPT);
        }
        return this.defaultPomFilter;
    }

    public void setDefaultPomFilter(PomFilter defaultPomFilter) {
        this.defaultPomFilter = defaultPomFilter;
    }

    public Map<String, PomFilter> getPomFilters() {
        return this.pomFilters;
    }

    protected BasePomFilterContainer newInstance() {
        return new BasePomFilterContainer(this.mavenPomFactory);
    }
}

