/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.remote.internal.inet.InetEndpoint;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketInetAddress
implements InetEndpoint {
    public static final org.gradle.internal.serialize.Serializer<SocketInetAddress> SERIALIZER = new Serializer();
    private final InetAddress address;
    private final int port;

    public SocketInetAddress(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public String getDisplayName() {
        return this.address + ":" + this.port;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SocketInetAddress other = (SocketInetAddress)o;
        return other.address.equals(this.address) && other.port == this.port;
    }

    public int hashCode() {
        return this.address.hashCode() ^ this.port;
    }

    @Override
    public List<InetAddress> getCandidates() {
        return Collections.singletonList(this.address);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Serializer
    implements org.gradle.internal.serialize.Serializer<SocketInetAddress> {
        private Serializer() {
        }

        @Override
        public SocketInetAddress read(Decoder decoder) throws Exception {
            return new SocketInetAddress(this.readAddress(decoder), decoder.readInt());
        }

        private InetAddress readAddress(Decoder decoder) throws IOException {
            return InetAddress.getByAddress(decoder.readBinary());
        }

        @Override
        public void write(Encoder encoder, SocketInetAddress address) throws Exception {
            this.writeAddress(encoder, address);
            encoder.writeInt(address.port);
        }

        private void writeAddress(Encoder encoder, SocketInetAddress address) throws IOException {
            encoder.writeBinary(address.address.getAddress());
        }
    }
}

