/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.cfg.WhenOnClassExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnSealedExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "()V", "collectNestedSubclasses", "", "baseDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "currentDescriptor", "subclasses", "", "getMissingCases", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "nullable", "", "getNestedSubclasses", "", "getNestedSubclasses$kotlin_compiler", "isApplicable", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
public final class WhenOnSealedExhaustivenessChecker
extends WhenOnClassExhaustivenessChecker {
    public static final WhenOnSealedExhaustivenessChecker INSTANCE;

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression, @NotNull BindingContext context, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        boolean bl = DescriptorUtils.isSealedClass(subjectDescriptor);
        if (_Assertions.ENABLED && !bl) {
            String string = "isWhenOnSealedClassExhaustive should be called with a sealed class descriptor: " + subjectDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassDescriptor classDescriptor = subjectDescriptor;
        if (classDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Set<ClassDescriptor> memberClassDescriptors = this.getNestedSubclasses$kotlin_compiler(classDescriptor);
        return CollectionsKt.plus((Collection)this.getMissingClassCases(expression, memberClassDescriptors, context), (Iterable)WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression, context, nullable));
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkParameterIsNotNull(subjectType, "subjectType");
        return DescriptorUtils.isSealedClass(TypeUtils.getClassDescriptor(subjectType));
    }

    @NotNull
    public final Set<ClassDescriptor> getNestedSubclasses$kotlin_compiler(@NotNull ClassDescriptor baseDescriptor) {
        Intrinsics.checkParameterIsNotNull(baseDescriptor, "baseDescriptor");
        LinkedHashSet memberClassDescriptors = new LinkedHashSet();
        this.collectNestedSubclasses(baseDescriptor, baseDescriptor, memberClassDescriptors);
        return memberClassDescriptors;
    }

    private final void collectNestedSubclasses(ClassDescriptor baseDescriptor, ClassDescriptor currentDescriptor, Set<ClassDescriptor> subclasses) {
        Function2<MemberScope, Boolean, Unit> collectSubclasses$ = new Function2<MemberScope, Boolean, Unit>(baseDescriptor, subclasses){
            final /* synthetic */ ClassDescriptor $baseDescriptor;
            final /* synthetic */ Set $subclasses;

            public final void invoke(@NotNull MemberScope scope, boolean collectNested) {
                Intrinsics.checkParameterIsNotNull(scope, "scope");
                for (DeclarationDescriptor descriptor2 : ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
                    if (!(descriptor2 instanceof ClassDescriptor)) continue;
                    if (DescriptorUtils.isDirectSubclass((ClassDescriptor)descriptor2, this.$baseDescriptor)) {
                        this.$subclasses.add(descriptor2);
                    }
                    if (!collectNested) continue;
                    WhenOnSealedExhaustivenessChecker.access$collectNestedSubclasses(WhenOnSealedExhaustivenessChecker.INSTANCE, this.$baseDescriptor, (ClassDescriptor)descriptor2, this.$subclasses);
                }
            }
            {
                this.$baseDescriptor = classDescriptor;
                this.$subclasses = set;
                super(2);
            }
        };
        if (Intrinsics.areEqual(currentDescriptor, baseDescriptor) && DescriptorUtils.isTopLevelDeclaration(currentDescriptor)) {
            DeclarationDescriptor declarationDescriptor = currentDescriptor.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor");
            }
            collectSubclasses$.invoke(((PackageFragmentDescriptor)declarationDescriptor).getMemberScope(), false);
        }
        MemberScope memberScope2 = currentDescriptor.getUnsubstitutedInnerClassesScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "currentDescriptor.unsubstitutedInnerClassesScope");
        collectSubclasses$.invoke(memberScope2, true);
    }

    private WhenOnSealedExhaustivenessChecker() {
        INSTANCE = this;
    }

    static {
        new WhenOnSealedExhaustivenessChecker();
    }

    public static final /* synthetic */ void access$collectNestedSubclasses(WhenOnSealedExhaustivenessChecker $this, @NotNull ClassDescriptor baseDescriptor, @NotNull ClassDescriptor currentDescriptor, @NotNull Set subclasses) {
        $this.collectNestedSubclasses(baseDescriptor, currentDescriptor, subclasses);
    }
}

