/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.com.google.common.base.Throwables;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a;\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u00022\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"checkAndUpdateReplHistoryCollection", "", "T", "col", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "baseHistory", "", "(Ljava/util/List;Ljava/lang/Iterable;)Ljava/lang/Integer;", "renderReplStackTrace", "", "cause", "", "startFromMethodName", "kotlin-compiler"})
public final class ReplUtilKt {
    @Nullable
    public static final <T> Integer checkAndUpdateReplHistoryCollection(@NotNull List<Pair<ReplCodeLine, T>> col, @NotNull Iterable<ReplCodeLine> baseHistory) {
        Intrinsics.checkParameterIsNotNull(col, "col");
        Intrinsics.checkParameterIsNotNull(baseHistory, "baseHistory");
        Iterator<ReplCodeLine> baseHistoryIt = baseHistory.iterator();
        int idx = 0;
        while (baseHistoryIt.hasNext()) {
            ReplCodeLine curLine = baseHistoryIt.next();
            if (Intrinsics.areEqual(col.get(idx).getFirst(), curLine) ^ true) {
                return curLine.getNo();
            }
            ++idx;
        }
        CollectionsKt.dropLast(col, col.size() - idx);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause, @NotNull String startFromMethodName) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(cause, "cause");
        Intrinsics.checkParameterIsNotNull(startFromMethodName, "startFromMethodName");
        ArrayList<StackTraceElement> newTrace = CollectionsKt.arrayListOf(new StackTraceElement[0]);
        boolean skip2 = true;
        for (IndexedValue<Object> indexedValue : CollectionsKt.reversed(ArraysKt.withIndex((Object[])cause.getStackTrace()))) {
            int i = indexedValue.component1();
            StackTraceElement element = (StackTraceElement)indexedValue.component2();
            if (Intrinsics.areEqual(element.getClassName() + "." + element.getMethodName(), startFromMethodName)) {
                skip2 = false;
            }
            if (skip2) continue;
            newTrace.add(element);
        }
        List resultingTrace = CollectionsKt.dropLast(CollectionsKt.reversed((Iterable)newTrace), 1);
        Throwable throwable = cause;
        if (throwable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
        }
        Collection collection = resultingTrace;
        Throwable throwable2 = throwable;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v1;
        StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[thisCollection$iv.size()]);
        if (stackTraceElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = stackTraceElementArray;
        throwable2.setStackTrace((StackTraceElement[])objectArray);
        String string = Throwables.getStackTraceAsString(cause);
        Intrinsics.checkExpressionValueIsNotNull(string, "Throwables.getStackTraceAsString(cause)");
        return string;
    }
}

