/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCallArgs;", "", "size", "", "(I)V", "bits", "Ljava/util/BitSet;", "getBits", "()Ljava/util/BitSet;", "getSize", "()I", "generateOnStackIfNeeded", "", "callGenerator", "Lorg/jetbrains/kotlin/codegen/CallGenerator;", "isConstructor", "mark", "", "index", "toInts", "", "kotlin-compiler"})
public final class DefaultCallArgs {
    @NotNull
    private final BitSet bits;
    private final int size;

    @NotNull
    public final BitSet getBits() {
        return this.bits;
    }

    public final void mark(int index2) {
        boolean bl = index2 < this.size;
        if (_Assertions.ENABLED && !bl) {
            String string = "Mask index should be less then size, but " + index2 + " >= " + this.size;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.bits.set(index2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> toInts() {
        if (this.bits.isEmpty() || this.size == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        int mask = 0;
        int n = 0;
        int n2 = this.size - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (i != false && i % 32 == false) {
                    masks.add(mask);
                    mask = 0;
                }
                mask |= this.bits.get((int)i) ? 1 << i % 32 : 0;
                if (i == n2) break;
                ++i;
            }
        }
        masks.add(mask);
        return masks;
    }

    public final boolean generateOnStackIfNeeded(@NotNull CallGenerator callGenerator, boolean isConstructor) {
        Intrinsics.checkParameterIsNotNull(callGenerator, "callGenerator");
        List<Integer> toInts = this.toInts();
        if (!toInts.isEmpty()) {
            Type parameterType;
            Iterator<Integer> iterator2 = toInts.iterator();
            while (iterator2.hasNext()) {
                int mask = ((Number)iterator2.next()).intValue();
                Type type2 = Type.INT_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(type2, "Type.INT_TYPE");
                StackValue stackValue = StackValue.constant(mask, Type.INT_TYPE);
                Intrinsics.checkExpressionValueIsNotNull(stackValue, "StackValue.constant(mask, Type.INT_TYPE)");
                callGenerator.putValueIfNeeded(type2, stackValue);
            }
            Type type3 = parameterType = isConstructor ? AsmTypes.DEFAULT_CONSTRUCTOR_MARKER : AsmTypes.OBJECT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type3, "parameterType");
            StackValue stackValue = StackValue.constant(null, parameterType);
            Intrinsics.checkExpressionValueIsNotNull(stackValue, "StackValue.constant(null, parameterType)");
            callGenerator.putValueIfNeeded(type3, stackValue);
        }
        Collection collection = toInts;
        return !collection.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    public DefaultCallArgs(int size) {
        this.size = size;
        this.bits = new BitSet(this.size);
    }
}

